/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.index.impl;

import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.core.index.IDocument;
import org.eclipse.jdt.internal.core.index.IQueryResult;

public class IndexedFile
implements IQueryResult {
    protected String path;
    protected int fileNumber;

    public IndexedFile(String path, int fileNum) {
        if (fileNum < 1) {
            throw new IllegalArgumentException();
        }
        this.fileNumber = fileNum;
        this.path = path;
    }

    public IndexedFile(IDocument document, int fileNum) {
        if (fileNum < 1) {
            throw new IllegalArgumentException();
        }
        this.path = document.getName();
        this.fileNumber = fileNum;
    }

    public static String convertPath(String pathString) {
        int index = pathString.indexOf("|");
        if (index == -1) {
            return pathString;
        }
        Path jarPath = new Path(pathString.substring(0, index));
        if (!jarPath.isAbsolute()) {
            return String.valueOf(jarPath.makeAbsolute().toString()) + pathString.substring(index, pathString.length());
        }
        return String.valueOf(jarPath.toOSString()) + pathString.substring(index, pathString.length());
    }

    public int footprint() {
        return 16 + (32 + this.path.length() * 2);
    }

    public int getFileNumber() {
        return this.fileNumber;
    }

    public String getPath() {
        return this.path;
    }

    public void setFileNumber(int fileNumber) {
        this.fileNumber = fileNumber;
    }

    public String toString() {
        return "IndexedFile(" + this.fileNumber + ": " + this.path + ")";
    }
}

