/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.core.index.IIndex;
import org.eclipse.jdt.internal.core.index.impl.BlocksIndexInput;
import org.eclipse.jdt.internal.core.index.impl.IndexInput;
import org.eclipse.jdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.jdt.internal.core.search.PatternSearchJob;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.jdt.internal.core.search.matching.SearchPattern;

public class SubTypeSearchJob
extends PatternSearchJob {
    Map inputs = new HashMap(5);

    public SubTypeSearchJob(SearchPattern pattern, IJavaSearchScope scope, int detailLevel, IIndexSearchRequestor requestor, IndexManager indexManager) {
        super(pattern, scope, detailLevel, requestor, indexManager);
    }

    public SubTypeSearchJob(SearchPattern pattern, IJavaSearchScope scope, IJavaElement focus, int detailLevel, IIndexSearchRequestor requestor, IndexManager indexManager) {
        super(pattern, scope, focus, false, detailLevel, requestor, indexManager);
    }

    public void closeAll() {
        Iterator openedInputs = this.inputs.values().iterator();
        while (openedInputs.hasNext()) {
            IndexInput input = (IndexInput)openedInputs.next();
            try {
                input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean search(IIndex index, IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (index == null) {
            return true;
        }
        ReadWriteMonitor monitor = this.indexManager.getMonitorFor(index);
        if (monitor == null) {
            return true;
        }
        try {
            try {
                monitor.enterRead();
                if (index.hasChanged()) {
                    try {
                        try {
                            monitor.exitRead();
                            monitor.enterWrite();
                            this.indexManager.saveIndex(index);
                        }
                        catch (IOException e) {
                            Object var5_7 = null;
                            monitor.exitWriteEnterRead();
                            Object var7_10 = null;
                            monitor.exitRead();
                            return false;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        monitor.exitWriteEnterRead();
                        throw throwable;
                    }
                    Object var5_9 = null;
                    monitor.exitWriteEnterRead();
                }
                long start = System.currentTimeMillis();
                IndexInput input = (IndexInput)this.inputs.get(index);
                if (input == null) {
                    input = new BlocksIndexInput(index.getIndexFile());
                    input.open();
                    this.inputs.put(index, input);
                }
                this.pattern.findIndexMatches(input, this.requestor, this.detailLevel, progressMonitor, this.scope);
                this.executionTime += System.currentTimeMillis() - start;
                Object var7_11 = null;
                monitor.exitRead();
                return true;
            }
            catch (IOException e) {
                Object var7_12 = null;
                monitor.exitRead();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var7_13 = null;
            monitor.exitRead();
            throw throwable;
        }
    }
}

