/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.indexing;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.jdt.internal.core.index.IDocument;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.indexing.SourceIndexer;

public class SourceIndexerRequestor
implements ISourceElementRequestor,
IIndexConstants {
    SourceIndexer indexer;
    IDocument document;
    char[] packageName;
    char[][] enclosingTypeNames = new char[5][];
    int depth = 0;
    int methodDepth = 0;

    public SourceIndexerRequestor(SourceIndexer indexer, IDocument document) {
        this.indexer = indexer;
        this.document = document;
    }

    public void acceptConstructorReference(char[] typeName, int argCount, int sourcePosition) {
        this.indexer.addConstructorReference(typeName, argCount);
        int lastDot = CharOperation.lastIndexOf('.', typeName);
        if (lastDot != -1) {
            char[][] qualification = CharOperation.splitOn('.', CharOperation.subarray(typeName, 0, lastDot));
            int i = 0;
            int length = qualification.length;
            while (i < length) {
                this.indexer.addNameReference(qualification[i]);
                ++i;
            }
        }
    }

    public void acceptFieldReference(char[] fieldName, int sourcePosition) {
        this.indexer.addFieldReference(fieldName);
    }

    public void acceptImport(int declarationStart, int declarationEnd, char[] name, boolean onDemand) {
        char[][] qualification = CharOperation.splitOn('.', CharOperation.subarray(name, 0, CharOperation.lastIndexOf('.', name)));
        int i = 0;
        int length = qualification.length;
        while (i < length) {
            this.indexer.addNameReference(qualification[i]);
            ++i;
        }
    }

    public void acceptLineSeparatorPositions(int[] positions) {
    }

    public void acceptMethodReference(char[] methodName, int argCount, int sourcePosition) {
        this.indexer.addMethodReference(methodName, argCount);
    }

    public void acceptPackage(int declarationStart, int declarationEnd, char[] name) {
        this.packageName = name;
    }

    public void acceptProblem(IProblem problem) {
    }

    public void acceptTypeReference(char[][] typeName, int sourceStart, int sourceEnd) {
        int length = typeName.length;
        int i = 0;
        while (i < length - 1) {
            this.acceptUnknownReference(typeName[i], 0);
            ++i;
        }
        this.acceptTypeReference(typeName[length - 1], 0);
    }

    public void acceptTypeReference(char[] simpleTypeName, int sourcePosition) {
        this.indexer.addTypeReference(simpleTypeName);
    }

    public void acceptUnknownReference(char[][] name, int sourceStart, int sourceEnd) {
        int i = 0;
        while (i < name.length) {
            this.acceptUnknownReference(name[i], 0);
            ++i;
        }
    }

    public void acceptUnknownReference(char[] name, int sourcePosition) {
        this.indexer.addNameReference(name);
    }

    public char[][] enclosingTypeNames() {
        if (this.depth == 0) {
            return null;
        }
        char[][] qualification = new char[this.depth][];
        System.arraycopy(this.enclosingTypeNames, 0, qualification, 0, this.depth);
        return qualification;
    }

    public void enterClass(int declarationStart, int modifiers, char[] name, int nameSourceStart, int nameSourceEnd, char[] superclass, char[][] superinterfaces) {
        if (superclass != null) {
            superclass = CharOperation.lastSegment(superclass, '.');
            this.indexer.addConstructorReference(superclass, 0);
        }
        if (superinterfaces != null) {
            int i = 0;
            int length = superinterfaces.length;
            while (i < length) {
                superinterfaces[i] = CharOperation.lastSegment(superinterfaces[i], '.');
                ++i;
            }
        }
        char[][] enclosingTypeNames = this.methodDepth > 0 ? IIndexConstants.ONE_ZERO_CHAR : this.enclosingTypeNames();
        this.indexer.addClassDeclaration(modifiers, this.packageName, name, enclosingTypeNames, superclass, superinterfaces);
        this.pushTypeName(name);
    }

    public void enterCompilationUnit() {
    }

    public void enterConstructor(int declarationStart, int modifiers, char[] name, int nameSourceStart, int nameSourceEnd, char[][] parameterTypes, char[][] parameterNames, char[][] exceptionTypes) {
        this.indexer.addConstructorDeclaration(name, parameterTypes, exceptionTypes);
        ++this.methodDepth;
    }

    public void enterField(int declarationStart, int modifiers, char[] type, char[] name, int nameSourceStart, int nameSourceEnd) {
        this.indexer.addFieldDeclaration(type, name);
        ++this.methodDepth;
    }

    public void enterInitializer(int declarationSourceStart, int modifiers) {
        ++this.methodDepth;
    }

    public void enterInterface(int declarationStart, int modifiers, char[] name, int nameSourceStart, int nameSourceEnd, char[][] superinterfaces) {
        if (superinterfaces != null) {
            int i = 0;
            int length = superinterfaces.length;
            while (i < length) {
                superinterfaces[i] = CharOperation.lastSegment(superinterfaces[i], '.');
                ++i;
            }
        }
        char[][] enclosingTypeNames = this.methodDepth > 0 ? IIndexConstants.ONE_ZERO_CHAR : this.enclosingTypeNames();
        this.indexer.addInterfaceDeclaration(modifiers, this.packageName, name, enclosingTypeNames, superinterfaces);
        this.pushTypeName(name);
    }

    public void enterMethod(int declarationStart, int modifiers, char[] returnType, char[] name, int nameSourceStart, int nameSourceEnd, char[][] parameterTypes, char[][] parameterNames, char[][] exceptionTypes) {
        this.indexer.addMethodDeclaration(name, parameterTypes, returnType, exceptionTypes);
        ++this.methodDepth;
    }

    public void exitClass(int declarationEnd) {
        this.popTypeName();
    }

    public void exitCompilationUnit(int declarationEnd) {
    }

    public void exitConstructor(int declarationEnd) {
        --this.methodDepth;
    }

    public void exitField(int initializationStart, int declarationEnd, int declarationSourceEnd) {
        --this.methodDepth;
    }

    public void exitInitializer(int declarationEnd) {
        --this.methodDepth;
    }

    public void exitInterface(int declarationEnd) {
        this.popTypeName();
    }

    public void exitMethod(int declarationEnd) {
        --this.methodDepth;
    }

    public void popTypeName() {
        try {
            this.enclosingTypeNames[--this.depth] = null;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }

    public void pushTypeName(char[] typeName) {
        if (this.depth == this.enclosingTypeNames.length) {
            this.enclosingTypeNames = new char[this.depth * 2][];
            System.arraycopy(this.enclosingTypeNames, 0, this.enclosingTypeNames, 0, this.depth);
        }
        this.enclosingTypeNames[this.depth++] = typeName;
    }
}

