/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer.dsl;

import au.com.dius.pact.consumer.ConsumerPactBuilder;
import au.com.dius.pact.consumer.dsl.DslPart;
import au.com.dius.pact.consumer.dsl.PactDslJsonRootValue;
import au.com.dius.pact.consumer.dsl.PactDslRequestWithPath;
import au.com.dius.pact.consumer.dsl.PactDslRequestWithoutPath;
import au.com.dius.pact.consumer.dsl.PactDslWithState;
import au.com.dius.pact.consumer.dsl.QuoteUtil;
import au.com.dius.pact.model.OptionalBody;
import au.com.dius.pact.model.PactFragment;
import au.com.dius.pact.model.ProviderState;
import au.com.dius.pact.model.Request;
import au.com.dius.pact.model.RequestResponseInteraction;
import au.com.dius.pact.model.RequestResponsePact;
import au.com.dius.pact.model.Response;
import au.com.dius.pact.model.generators.Generators;
import au.com.dius.pact.model.matchingrules.MatchingRule;
import au.com.dius.pact.model.matchingrules.MatchingRules;
import au.com.dius.pact.model.matchingrules.MatchingRulesImpl;
import au.com.dius.pact.model.matchingrules.RegexMatcher;
import com.mifmif.common.regex.Generex;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.xml.transform.TransformerException;
import org.apache.http.entity.ContentType;
import org.json.JSONObject;
import org.w3c.dom.Document;
import scala.collection.JavaConversions$;
import scala.collection.Seq;

public class PactDslResponse {
    private static final String CONTENT_TYPE = "Content-Type";
    private final ConsumerPactBuilder consumerPactBuilder;
    private PactDslRequestWithPath request;
    private final PactDslRequestWithoutPath defaultRequestValues;
    private final PactDslResponse defaultResponseValues;
    private int responseStatus = 200;
    private Map<String, String> responseHeaders = new HashMap<String, String>();
    private OptionalBody responseBody = OptionalBody.missing();
    private MatchingRules responseMatchers = new MatchingRulesImpl();
    private Generators responseGenerators = new Generators();

    public PactDslResponse(ConsumerPactBuilder consumerPactBuilder, PactDslRequestWithPath request, PactDslRequestWithoutPath defaultRequestValues, PactDslResponse defaultResponseValues) {
        this.consumerPactBuilder = consumerPactBuilder;
        this.request = request;
        this.defaultRequestValues = defaultRequestValues;
        this.defaultResponseValues = defaultResponseValues;
        this.setupDefaultValues();
    }

    private void setupDefaultValues() {
        if (this.defaultResponseValues != null) {
            this.responseStatus = this.defaultResponseValues.responseStatus;
            this.responseHeaders.putAll(this.defaultResponseValues.responseHeaders);
            this.responseBody = this.defaultResponseValues.responseBody;
            this.responseMatchers = ((MatchingRulesImpl)this.defaultResponseValues.responseMatchers).copy();
            this.responseGenerators = new Generators(this.defaultResponseValues.responseGenerators.getCategories());
        }
    }

    public PactDslResponse status(int status) {
        this.responseStatus = status;
        return this;
    }

    public PactDslResponse headers(Map<String, String> headers) {
        this.responseHeaders.putAll(headers);
        return this;
    }

    public PactDslResponse body(String body) {
        this.responseBody = OptionalBody.body((String)body);
        return this;
    }

    public PactDslResponse body(String body, String mimeType) {
        this.responseBody = OptionalBody.body((String)body);
        this.responseHeaders.put(CONTENT_TYPE, mimeType);
        return this;
    }

    public PactDslResponse body(String body, ContentType mimeType) {
        return this.body(body, mimeType.toString());
    }

    public PactDslResponse body(Supplier<String> body) {
        this.responseBody = OptionalBody.body((String)body.get());
        return this;
    }

    public PactDslResponse body(Supplier<String> body, String mimeType) {
        this.responseBody = OptionalBody.body((String)body.get());
        this.responseHeaders.put(CONTENT_TYPE, mimeType);
        return this;
    }

    public PactDslResponse body(Supplier<String> body, ContentType mimeType) {
        return this.body(body, mimeType.toString());
    }

    public PactDslResponse bodyWithSingleQuotes(String body) {
        if (body != null) {
            body = QuoteUtil.convert(body);
        }
        return this.body(body);
    }

    public PactDslResponse bodyWithSingleQuotes(String body, String mimeType) {
        if (body != null) {
            body = QuoteUtil.convert(body);
        }
        return this.body(body, mimeType);
    }

    public PactDslResponse bodyWithSingleQuotes(String body, ContentType mimeType) {
        return this.bodyWithSingleQuotes(body, mimeType.toString());
    }

    public PactDslResponse body(JSONObject body) {
        this.responseBody = OptionalBody.body((String)body.toString());
        if (!this.responseHeaders.containsKey(CONTENT_TYPE)) {
            this.responseHeaders.put(CONTENT_TYPE, ContentType.APPLICATION_JSON.toString());
        }
        return this;
    }

    public PactDslResponse body(DslPart body) {
        DslPart parent = body.close();
        if (parent instanceof PactDslJsonRootValue) {
            ((PactDslJsonRootValue)parent).setEncodeJson(true);
        }
        this.responseMatchers.addCategory(parent.getMatchers());
        this.responseGenerators.addGenerators(parent.generators);
        this.responseBody = parent.getBody() != null ? OptionalBody.body((String)parent.getBody().toString()) : OptionalBody.nullBody();
        if (!this.responseHeaders.containsKey(CONTENT_TYPE)) {
            this.responseHeaders.put(CONTENT_TYPE, ContentType.APPLICATION_JSON.toString());
        }
        return this;
    }

    public PactDslResponse body(Document body) throws TransformerException {
        this.responseBody = OptionalBody.body((String)ConsumerPactBuilder.xmlToString(body));
        if (!this.responseHeaders.containsKey(CONTENT_TYPE)) {
            this.responseHeaders.put(CONTENT_TYPE, ContentType.APPLICATION_XML.toString());
        }
        return this;
    }

    public PactDslResponse matchHeader(String header, String regexp) {
        return this.matchHeader(header, regexp, new Generex(regexp).random());
    }

    public PactDslResponse matchHeader(String header, String regexp, String headerExample) {
        this.responseMatchers.addCategory("header").addRule(header, (MatchingRule)new RegexMatcher(regexp));
        this.responseHeaders.put(header, headerExample);
        return this;
    }

    private void addInteraction() {
        this.consumerPactBuilder.getInteractions().add(new RequestResponseInteraction(this.request.description, this.request.state, new Request(this.request.requestMethod, this.request.path, this.request.query, this.request.requestHeaders, this.request.requestBody, this.request.requestMatchers, this.request.requestGenerators), new Response(Integer.valueOf(this.responseStatus), this.responseHeaders, this.responseBody, this.responseMatchers, this.responseGenerators)));
    }

    public PactFragment toFragment() {
        this.addInteraction();
        return new PactFragment(this.request.consumer, this.request.provider, (Seq<RequestResponseInteraction>)JavaConversions$.MODULE$.asScalaBuffer(this.consumerPactBuilder.getInteractions()).toSeq());
    }

    public RequestResponsePact toPact() {
        this.addInteraction();
        return new RequestResponsePact(this.request.provider, this.request.consumer, this.consumerPactBuilder.getInteractions());
    }

    public PactDslRequestWithPath uponReceiving(String description) {
        this.addInteraction();
        return new PactDslRequestWithPath(this.consumerPactBuilder, this.request, description, this.defaultRequestValues, this.defaultResponseValues);
    }

    public PactDslWithState given(String state) {
        this.addInteraction();
        return new PactDslWithState(this.consumerPactBuilder, this.request.consumer.getName(), this.request.provider.getName(), new ProviderState(state), this.defaultRequestValues, this.defaultResponseValues);
    }

    public PactDslWithState given(String state, Map<String, Object> params) {
        this.addInteraction();
        return new PactDslWithState(this.consumerPactBuilder, this.request.consumer.getName(), this.request.provider.getName(), new ProviderState(state, params), this.defaultRequestValues, this.defaultResponseValues);
    }
}

