/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.model;

import au.com.dius.pact.core.model.ContentType;
import au.com.dius.pact.core.model.HttpPart;
import au.com.dius.pact.core.model.OptionalBody;
import au.com.dius.pact.core.model.PactReaderKt;
import au.com.dius.pact.core.support.Json;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import javax.mail.BodyPart;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J&\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007J&\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007\u00a8\u0006\r"}, d2={"Lau/com/dius/pact/core/model/BaseRequest;", "Lau/com/dius/pact/core/model/HttpPart;", "()V", "isMultipartFileUpload", "", "withMultipartFileUpload", "partName", "", "filename", "contentType", "Lau/com/dius/pact/core/model/ContentType;", "contents", "Companion", "pact-jvm-core-model"})
public abstract class BaseRequest
extends HttpPart {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final BaseRequest withMultipartFileUpload(@NotNull String partName, @NotNull String filename, @NotNull ContentType contentType, @NotNull String contents) {
        Intrinsics.checkParameterIsNotNull((Object)partName, (String)"partName");
        Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
        Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
        Intrinsics.checkParameterIsNotNull((Object)contents, (String)"contents");
        return this.withMultipartFileUpload(partName, filename, contentType.getContentType(), contents);
    }

    @NotNull
    public final BaseRequest withMultipartFileUpload(@NotNull String partName, @NotNull String filename, @NotNull String contentType, @NotNull String contents) {
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull((Object)partName, (String)"partName");
        Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
        Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
        Intrinsics.checkParameterIsNotNull((Object)contents, (String)"contents");
        MimeMultipart multipart = new MimeMultipart("form-data");
        InternetHeaders internetHeaders = new InternetHeaders();
        internetHeaders.setHeader("Content-Disposition", "form-data; name=\"" + partName + "\"; filename=\"" + filename + '\"');
        internetHeaders.setHeader("Content-Type", contentType);
        String string = contents;
        InternetHeaders internetHeaders2 = internetHeaders;
        MimeMultipart mimeMultipart = multipart;
        Charset charset2 = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray2 = string.getBytes(charset2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray3 = byArray = byArray2;
        InternetHeaders internetHeaders3 = internetHeaders2;
        mimeMultipart.addBodyPart((BodyPart)new MimeBodyPart(internetHeaders3, byArray3));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        multipart.writeTo((OutputStream)stream);
        this.setBody(OptionalBody.Companion.body(stream.toByteArray(), new ContentType(contentType)));
        this.getHeaders().put("Content-Type", CollectionsKt.listOf((Object)multipart.getContentType()));
        return this;
    }

    public final boolean isMultipartFileUpload() {
        return StringsKt.equals((String)this.mimeType(), (String)"multipart/form-data", (boolean)true);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a8\u0006\t"}, d2={"Lau/com/dius/pact/core/model/BaseRequest$Companion;", "", "()V", "parseQueryParametersToMap", "", "", "", "query", "Lcom/google/gson/JsonElement;", "pact-jvm-core-model"})
    public static final class Companion {
        @NotNull
        public final Map<String, List<String>> parseQueryParametersToMap(@Nullable JsonElement query) {
            Map map;
            if (query == null) {
                map = MapsKt.emptyMap();
            } else if (query.isJsonObject()) {
                map = Json.INSTANCE.toMap(query);
                if (map == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.collections.List<kotlin.String>>");
                }
            } else if (query.isJsonPrimitive()) {
                String string;
                JsonPrimitive jsonPrimitive = query.getAsJsonPrimitive();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonPrimitive, (String)"query.asJsonPrimitive");
                if (jsonPrimitive.isString()) {
                    JsonPrimitive jsonPrimitive2 = query.getAsJsonPrimitive();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsonPrimitive2, (String)"query.asJsonPrimitive");
                    string = jsonPrimitive2.getAsString();
                } else {
                    string = query.getAsJsonPrimitive().toString();
                }
                map = PactReaderKt.queryStringToMap$default(string, false, 2, null);
            } else {
                map = MapsKt.emptyMap();
            }
            return map;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

