/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.pactbroker;

import au.com.dius.pact.com.github.michaelbull.result.Err;
import au.com.dius.pact.com.github.michaelbull.result.Ok;
import au.com.dius.pact.com.github.michaelbull.result.Result;
import au.com.dius.pact.core.pactbroker.HalClient;
import au.com.dius.pact.core.pactbroker.IHalClient;
import au.com.dius.pact.core.pactbroker.InvalidHalResponse;
import au.com.dius.pact.core.pactbroker.InvalidNavigationRequest;
import au.com.dius.pact.core.pactbroker.NotFoundHalResponse;
import au.com.dius.pact.core.pactbroker.RequestFailedException;
import au.com.dius.pact.core.pactbroker.util.HttpClientUtils;
import au.com.dius.pact.core.support.HttpClient;
import au.com.dius.pact.core.support.KotlinLanguageSupportKt;
import com.github.salomonbrys.kotson.BuilderKt;
import com.github.salomonbrys.kotson.ElementKt;
import com.github.salomonbrys.kotson.MutableKt;
import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u0000 ^2\u00020\u0001:\u0001^B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J.\u0010+\u001a\u0004\u0018\u00010\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010,\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u0003H\u0002J\u0010\u0010.\u001a\u00020%2\u0006\u0010/\u001a\u00020\u0003H\u0016J\u0018\u0010.\u001a\u00020%2\u0006\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u000201H\u0016J$\u00102\u001a\u00020%2\u0006\u00103\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J,\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u00032\u001a\u00107\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u000508H\u0016J*\u00109\u001a\u0012\u0012\u0004\u0012\u00020%\u0012\b\u0012\u00060;j\u0002`<0:2\u0006\u0010/\u001a\u00020\u00032\b\b\u0002\u00100\u001a\u000201H\u0002J6\u0010=\u001a\u0004\u0018\u00010\u00062\u0006\u0010>\u001a\u00020?2\b\u0010@\u001a\u0004\u0018\u00010\u00032\u001a\u00107\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00060AJ0\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002010C2\u0006\u00103\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u0006\u0010D\u001a\u000205J\u001d\u0010E\u001a\u0002HF\"\b\b\u0000\u0010F*\u00020G2\u0006\u0010H\u001a\u0002HF\u00a2\u0006\u0002\u0010IJ\u0012\u0010J\u001a\u0004\u0018\u00010\u00032\u0006\u0010K\u001a\u00020\u0003H\u0016J\u0010\u0010L\u001a\u00020\u00012\u0006\u00103\u001a\u00020\u0003H\u0016J$\u0010L\u001a\u00020\u00012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u00103\u001a\u00020\u0003H\u0016J\"\u0010M\u001a\u00020\u00032\u0006\u0010N\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005J(\u0010O\u001a\u0012\u0012\u0004\u0012\u000201\u0012\b\u0012\u00060;j\u0002`<0:2\u0006\u0010P\u001a\u00020\u00032\u0006\u0010@\u001a\u00020\u0003H\u0016Jb\u0010O\u001a\u0012\u0012\u0004\u0012\u000201\u0012\b\u0012\u00060;j\u0002`<0:2\u0006\u0010P\u001a\u00020\u00032\u0006\u0010@\u001a\u00020\u000328\u0010Q\u001a4\u0012\u0013\u0012\u00110!\u00a2\u0006\f\bS\u0012\b\bK\u0012\u0004\b\b(T\u0012\u0013\u0012\u00110U\u00a2\u0006\f\bS\u0012\b\bK\u0012\u0004\b\b(V\u0012\u0004\u0012\u000201\u0018\u00010RH\u0016J<\u0010W\u001a\u0012\u0012\u0004\u0012\u000201\u0012\b\u0012\u00060;j\u0002`<0:2\u0006\u00103\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010X\u001a\u00020\u0003H\u0016J\b\u0010Y\u001a\u00020\u0011H\u0016J\u001a\u0010Z\u001a\u0004\u0018\u00010\u00062\u0006\u0010/\u001a\u00020\u00032\u0006\u0010[\u001a\u00020\u0003H\u0016J6\u0010Z\u001a\u0004\u0018\u00010\u00062\u0006\u0010/\u001a\u00020\u00032\u0006\u0010[\u001a\u00020\u00032\u001a\u00107\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00060AH\u0016J>\u0010Z\u001a\u0004\u0018\u00010\u00062\u0006\u0010/\u001a\u00020\u00032\u0006\u0010[\u001a\u00020\u00032\u001a\u00107\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00060A2\u0006\u00100\u001a\u000201H\u0016J\u001e\u0010\\\u001a\u00020\u00012\u0014\u0010]\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR&\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\t\"\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\r\"\u0004\b#\u0010\u000fR\u001c\u0010$\u001a\u0004\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006_"}, d2={"Lau/com/dius/pact/core/pactbroker/HalClient;", "Lau/com/dius/pact/core/pactbroker/IHalClient;", "baseUrl", "", "options", "", "", "(Ljava/lang/String;Ljava/util/Map;)V", "getBaseUrl", "()Ljava/lang/String;", "defaultHeaders", "", "getDefaultHeaders", "()Ljava/util/Map;", "setDefaultHeaders", "(Ljava/util/Map;)V", "httpClient", "Lorg/apache/http/impl/client/CloseableHttpClient;", "getHttpClient", "()Lorg/apache/http/impl/client/CloseableHttpClient;", "setHttpClient", "(Lorg/apache/http/impl/client/CloseableHttpClient;)V", "httpContext", "Lorg/apache/http/client/protocol/HttpClientContext;", "getHttpContext", "()Lorg/apache/http/client/protocol/HttpClientContext;", "setHttpContext", "(Lorg/apache/http/client/protocol/HttpClientContext;)V", "lastUrl", "getLastUrl", "setLastUrl", "(Ljava/lang/String;)V", "maxPublishRetries", "", "getOptions", "setOptions", "pathInfo", "Lcom/google/gson/JsonElement;", "getPathInfo", "()Lcom/google/gson/JsonElement;", "setPathInfo", "(Lcom/google/gson/JsonElement;)V", "publishRetryInterval", "encodePathParameter", "key", "value", "fetch", "path", "encodePath", "", "fetchLink", "link", "forAll", "", "linkName", "closure", "Ljava/util/function/Consumer;", "getJson", "Lau/com/dius/pact/com/github/michaelbull/result/Result;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "handleFailure", "resp", "Lorg/apache/http/HttpResponse;", "body", "Ljava/util/function/BiFunction;", "hrefForLink", "Lkotlin/Pair;", "initPathInfo", "initialiseRequest", "Method", "Lorg/apache/http/HttpMessage;", "method", "(Lorg/apache/http/HttpMessage;)Lorg/apache/http/HttpMessage;", "linkUrl", "name", "navigate", "parseLinkUrl", "href", "postJson", "url", "handler", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "status", "Lorg/apache/http/client/methods/CloseableHttpResponse;", "response", "putJson", "json", "setupHttpClient", "uploadJson", "bodyJson", "withDocContext", "docAttributes", "Companion", "pact-jvm-core-pact-broker"})
public class HalClient
implements IHalClient {
    @Nullable
    private CloseableHttpClient httpClient;
    @Nullable
    private HttpClientContext httpContext;
    @Nullable
    private JsonElement pathInfo;
    @Nullable
    private String lastUrl;
    @NotNull
    private Map<String, String> defaultHeaders;
    private int maxPublishRetries;
    private int publishRetryInterval;
    @NotNull
    private final String baseUrl;
    @NotNull
    private Map<String, ? extends Object> options;
    @NotNull
    public static final String ROOT = "/";
    @NotNull
    public static final String LINKS = "_links";
    @NotNull
    public static final String PREEMPTIVE_AUTHENTICATION = "pact.pactbroker.httpclient.usePreemptiveAuthentication";
    @NotNull
    private static final Regex URL_TEMPLATE_REGEX;
    public static final Companion Companion;

    @Nullable
    public final CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public final void setHttpClient(@Nullable CloseableHttpClient closeableHttpClient) {
        this.httpClient = closeableHttpClient;
    }

    @Nullable
    public final HttpClientContext getHttpContext() {
        return this.httpContext;
    }

    public final void setHttpContext(@Nullable HttpClientContext httpClientContext) {
        this.httpContext = httpClientContext;
    }

    @Nullable
    public final JsonElement getPathInfo() {
        return this.pathInfo;
    }

    public final void setPathInfo(@Nullable JsonElement jsonElement) {
        this.pathInfo = jsonElement;
    }

    @Nullable
    public final String getLastUrl() {
        return this.lastUrl;
    }

    public final void setLastUrl(@Nullable String string) {
        this.lastUrl = string;
    }

    @NotNull
    public final Map<String, String> getDefaultHeaders() {
        return this.defaultHeaders;
    }

    public final void setDefaultHeaders(@NotNull Map<String, String> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"<set-?>");
        this.defaultHeaders = map;
    }

    @NotNull
    public final <Method extends HttpMessage> Method initialiseRequest(@NotNull Method method) {
        Intrinsics.checkParameterIsNotNull(method, (String)"method");
        Map<String, String> $this$forEach$iv = this.defaultHeaders;
        boolean $i$f$forEach = false;
        Map<String, String> map = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> $dstr$key$value = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry<String, String> entry = $dstr$key$value;
            boolean bl3 = false;
            String key = entry.getKey();
            entry = $dstr$key$value;
            bl3 = false;
            String value = entry.getValue();
            method.addHeader(key, value);
        }
        return method;
    }

    @Override
    @NotNull
    public Result<Boolean, Exception> postJson(@NotNull String url, @NotNull String body) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        return this.postJson(url, body, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Result<Boolean, Exception> postJson(@NotNull String url, @NotNull String body, @Nullable Function2<? super Integer, ? super CloseableHttpResponse, Boolean> handler) {
        Result result;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        Companion.getLogger().debug((Function0)new Function0<String>(url, body){
            final /* synthetic */ String $url;
            final /* synthetic */ String $body;

            @NotNull
            public final String invoke() {
                return "Posting JSON to " + this.$url + '\n' + this.$body;
            }
            {
                this.$url = string;
                this.$body = string2;
                super(0);
            }
        });
        CloseableHttpClient client = this.setupHttpClient();
        Result.Companion this_$iv = Result.Companion;
        boolean $i$f$of = false;
        try {
            Boolean bl;
            boolean bl2;
            boolean bl3 = false;
            HttpPost httpPost = (HttpPost)this.initialiseRequest((HttpMessage)new HttpPost(url));
            httpPost.addHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
            httpPost.setEntity((HttpEntity)new StringEntity(body, ContentType.APPLICATION_JSON));
            Closeable closeable = (Closeable)client.execute((HttpUriRequest)httpPost, (HttpContext)this.httpContext);
            boolean bl4 = false;
            Throwable throwable = null;
            try {
                boolean bl5;
                CloseableHttpResponse it = (CloseableHttpResponse)closeable;
                boolean bl6 = false;
                Companion.getLogger().debug((Function0)new Function0<String>(it){
                    final /* synthetic */ CloseableHttpResponse $it;

                    @NotNull
                    public final String invoke() {
                        StringBuilder stringBuilder = new StringBuilder().append("Got response ");
                        CloseableHttpResponse closeableHttpResponse = this.$it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpResponse, (String)"it");
                        return stringBuilder.append(closeableHttpResponse.getStatusLine()).toString();
                    }
                    {
                        this.$it = closeableHttpResponse;
                        super(0);
                    }
                });
                Companion.getLogger().debug((Function0)new Function0<String>(it){
                    final /* synthetic */ CloseableHttpResponse $it;

                    @NotNull
                    public final String invoke() {
                        String string;
                        StringBuilder stringBuilder = new StringBuilder().append("Response body: ");
                        CloseableHttpResponse closeableHttpResponse = this.$it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpResponse, (String)"it");
                        Object object = closeableHttpResponse.getEntity();
                        if (object != null && (object = object.getContent()) != null) {
                            Object object2 = object;
                            StringBuilder stringBuilder2 = stringBuilder;
                            Charset charset = Charsets.UTF_8;
                            boolean bl = false;
                            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object2, charset);
                            stringBuilder = stringBuilder2;
                            string = TextStreamsKt.readText((Reader)inputStreamReader);
                        } else {
                            string = null;
                        }
                        return stringBuilder.append(string).toString();
                    }
                    {
                        this.$it = closeableHttpResponse;
                        super(0);
                    }
                });
                if (handler != null) {
                    CloseableHttpResponse closeableHttpResponse = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpResponse, (String)"it");
                    StatusLine statusLine = closeableHttpResponse.getStatusLine();
                    Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"it.statusLine");
                    bl5 = (Boolean)handler.invoke((Object)statusLine.getStatusCode(), (Object)it);
                } else {
                    CloseableHttpResponse closeableHttpResponse = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpResponse, (String)"it");
                    StatusLine statusLine = closeableHttpResponse.getStatusLine();
                    Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"it.statusLine");
                    bl5 = statusLine.getStatusCode() < 300;
                }
                bl2 = bl5;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Boolean bl7 = bl = Boolean.valueOf(bl2);
            result = (Result)new Ok((Object)bl7);
        }
        catch (Exception ex$iv) {
            result = (Result)new Err((Object)ex$iv);
        }
        return result;
    }

    @NotNull
    public CloseableHttpClient setupHttpClient() {
        if (this.httpClient == null) {
            if (this.options.containsKey("authentication") && !(this.options.get("authentication") instanceof List)) {
                HttpClient.INSTANCE.getLogger().warn((Function0)setupHttpClient.1.INSTANCE);
            }
            URI uri = new URI(this.baseUrl);
            Pair result = HttpClient.INSTANCE.newHttpClient(this.options.get("authentication"), uri, this.defaultHeaders, this.maxPublishRetries, this.publishRetryInterval);
            this.httpClient = (CloseableHttpClient)result.getFirst();
            if (Intrinsics.areEqual((Object)System.getProperty(PREEMPTIVE_AUTHENTICATION), (Object)"true")) {
                HttpHost targetHost = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
                Companion.getLogger().warn((Function0)new Function0<String>(targetHost){
                    final /* synthetic */ HttpHost $targetHost;

                    @NotNull
                    public final String invoke() {
                        return "Using preemptive basic authentication with the pact broker at " + this.$targetHost;
                    }
                    {
                        this.$targetHost = httpHost;
                        super(0);
                    }
                });
                BasicAuthCache authCache = new BasicAuthCache();
                BasicScheme basicAuth = new BasicScheme();
                authCache.put(targetHost, (AuthScheme)basicAuth);
                HttpClientContext httpClientContext = this.httpContext = HttpClientContext.create();
                if (httpClientContext == null) {
                    Intrinsics.throwNpe();
                }
                httpClientContext.setCredentialsProvider((CredentialsProvider)result.getSecond());
                HttpClientContext httpClientContext2 = this.httpContext;
                if (httpClientContext2 == null) {
                    Intrinsics.throwNpe();
                }
                httpClientContext2.setAuthCache((AuthCache)authCache);
            }
        }
        CloseableHttpClient closeableHttpClient = this.httpClient;
        if (closeableHttpClient == null) {
            Intrinsics.throwNpe();
        }
        return closeableHttpClient;
    }

    @Override
    @NotNull
    public IHalClient navigate(@NotNull Map<String, ? extends Object> options, @NotNull String link) {
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        Intrinsics.checkParameterIsNotNull((Object)link, (String)"link");
        JsonElement jsonElement = this.pathInfo;
        if (jsonElement == null) {
            jsonElement = this.fetch(ROOT);
        }
        this.pathInfo = jsonElement;
        this.pathInfo = this.fetchLink(link, options);
        return this;
    }

    @Override
    @NotNull
    public IHalClient navigate(@NotNull String link) {
        Intrinsics.checkParameterIsNotNull((Object)link, (String)"link");
        HalClient halClient = this;
        boolean bl = false;
        Map map = MapsKt.emptyMap();
        return halClient.navigate(map, link);
    }

    @Override
    @NotNull
    public JsonElement fetch(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return this.fetch(path, true);
    }

    @Override
    @NotNull
    public JsonElement fetch(@NotNull String path, boolean encodePath) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.lastUrl = path;
        Companion.getLogger().debug((Function0)new Function0<String>(path){
            final /* synthetic */ String $path;

            @NotNull
            public final String invoke() {
                return "Fetching: " + this.$path;
            }
            {
                this.$path = string;
                super(0);
            }
        });
        Result<JsonElement, Exception> response = this.getJson(path, encodePath);
        if (response instanceof Ok) {
            return (JsonElement)((Ok)response).getValue();
        }
        if (response instanceof Err) {
            throw (Throwable)((Err)response).getError();
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IHalClient withDocContext(@NotNull Map<String, ? extends Object> docAttributes) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull(docAttributes, (String)"docAttributes");
        JsonObject links = new JsonObject();
        Iterable iterable = docAttributes.entrySet();
        String string = LINKS;
        JsonElement jsonElement = (JsonElement)links;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            JsonElement jsonElement2;
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            Object v = it.getValue();
            if (v instanceof Map) {
                Collection<Pair> collection2;
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                Object v2 = it.getValue();
                if (v2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<*, *>");
                }
                Iterable iterable2 = ((Map)v2).entrySet();
                Object k2 = k;
                boolean $i$f$map2 = false;
                void var16_18 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void entry2;
                    Map.Entry entry3 = (Map.Entry)item$iv$iv2;
                    collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    Pair pair = Intrinsics.areEqual(entry2.getKey(), (Object)"href") ? TuplesKt.to((Object)String.valueOf(entry2.getKey()), (Object)URLDecoder.decode(String.valueOf(entry2.getValue()), "UTF-8")) : TuplesKt.to((Object)String.valueOf(entry2.getKey()), entry2.getValue());
                    collection2.add(pair);
                }
                collection2 = (List)destination$iv$iv2;
                k = k2;
                jsonElement2 = (JsonElement)BuilderKt.jsonObject((Iterable)collection2);
            } else {
                jsonElement2 = (JsonElement)ElementKt.getJsonNull();
            }
            Pair pair = TuplesKt.to(k, (Object)jsonElement2);
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        MutableKt.set((JsonElement)jsonElement, (String)string, (Object)BuilderKt.jsonObject((Iterable)collection));
        this.pathInfo = (JsonElement)links;
        return this;
    }

    private final Result<JsonElement, Exception> getJson(String path, boolean encodePath) {
        Result result;
        this.setupHttpClient();
        Result.Companion this_$iv = Result.Companion;
        boolean $i$f$of = false;
        try {
            JsonElement jsonElement;
            CloseableHttpResponse response;
            boolean bl = false;
            HttpGet httpGet = (HttpGet)this.initialiseRequest((HttpMessage)new HttpGet(HttpClientUtils.INSTANCE.buildUrl(this.baseUrl, path, encodePath)));
            httpGet.addHeader("Content-Type", "application/json");
            httpGet.addHeader("Accept", "application/hal+json, application/json");
            CloseableHttpClient closeableHttpClient = this.httpClient;
            if (closeableHttpClient == null) {
                Intrinsics.throwNpe();
            }
            CloseableHttpResponse closeableHttpResponse = response = closeableHttpClient.execute((HttpUriRequest)httpGet, (HttpContext)this.httpContext);
            Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpResponse, (String)"response");
            StatusLine statusLine = closeableHttpResponse.getStatusLine();
            Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"response.statusLine");
            if (statusLine.getStatusCode() < 300) {
                ContentType contentType;
                ContentType contentType2 = contentType = ContentType.getOrDefault((HttpEntity)response.getEntity());
                Intrinsics.checkExpressionValueIsNotNull((Object)contentType2, (String)"contentType");
                if (!HttpClientUtils.INSTANCE.isJsonResponse(contentType2)) {
                    throw (Throwable)new InvalidHalResponse("Expected a HAL+JSON response from the pact broker, but got '" + contentType + '\'');
                }
            } else {
                StatusLine statusLine2 = response.getStatusLine();
                Intrinsics.checkExpressionValueIsNotNull((Object)statusLine2, (String)"response.statusLine");
                switch (statusLine2.getStatusCode()) {
                    case 404: {
                        throw (Throwable)new NotFoundHalResponse("No HAL document found at path '" + path + '\'');
                    }
                }
                throw (Throwable)new RequestFailedException("Request to path '" + path + "' failed with response '" + response.getStatusLine() + '\'');
            }
            JsonElement jsonElement2 = jsonElement = new JsonParser().parse(EntityUtils.toString((HttpEntity)response.getEntity()));
            result = (Result)new Ok((Object)jsonElement2);
        }
        catch (Exception ex$iv) {
            result = (Result)new Err((Object)ex$iv);
        }
        return result;
    }

    static /* synthetic */ Result getJson$default(HalClient halClient, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getJson");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return halClient.getJson(string, bl);
    }

    private final JsonElement fetchLink(String link, Map<String, ? extends Object> options) {
        Pair<String, Boolean> href = this.hrefForLink(link, options);
        return this.fetch((String)href.getFirst(), (Boolean)href.getSecond());
    }

    private final Pair<String, Boolean> hrefForLink(String link, Map<String, ? extends Object> options) {
        JsonElement links;
        JsonElement jsonElement = this.pathInfo;
        if ((jsonElement != null && (jsonElement = ElementKt.getNullObj((JsonElement)jsonElement)) != null ? jsonElement.get(LINKS) : null) == null) {
            throw (Throwable)new InvalidHalResponse("Expected a HAL+JSON response from the pact broker, but got " + "a response with no '_links'. URL: '" + this.baseUrl + "', LINK: '" + link + '\'');
        }
        JsonElement jsonElement2 = this.pathInfo;
        if (jsonElement2 == null) {
            Intrinsics.throwNpe();
        }
        if ((links = ElementKt.get((JsonElement)jsonElement2, (String)LINKS)).isJsonObject()) {
            if (!ElementKt.getObj((JsonElement)links).has(link)) {
                throw (Throwable)new InvalidHalResponse("Link '" + link + "' was not found in the response, only the following links where " + "found: " + ElementKt.keys((JsonObject)ElementKt.getObj((JsonElement)links)) + ". URL: '" + this.baseUrl + "', LINK: '" + link + '\'');
            }
            JsonElement linkData = ElementKt.get((JsonElement)links, (String)link);
            if (linkData.isJsonArray()) {
                if (options.containsKey("name")) {
                    Pair pair;
                    Object v4;
                    block12: {
                        JsonArray jsonArray = linkData.getAsJsonArray();
                        Intrinsics.checkExpressionValueIsNotNull((Object)jsonArray, (String)"linkData.asJsonArray");
                        Iterable iterable = (Iterable)jsonArray;
                        boolean bl = false;
                        Iterable iterable2 = iterable;
                        boolean bl2 = false;
                        for (Object t : iterable2) {
                            JsonElement it = (JsonElement)t;
                            boolean bl3 = false;
                            JsonElement jsonElement3 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement3, (String)"it");
                            if (!(jsonElement3.isJsonObject() && Intrinsics.areEqual((Object)ElementKt.get((JsonElement)it, (String)"name"), (Object)options.get("name")))) continue;
                            v4 = t;
                            break block12;
                        }
                        v4 = null;
                    }
                    JsonElement linkByName = v4;
                    if (linkByName != null && linkByName.isJsonObject() && ElementKt.get((JsonElement)linkByName, (String)"templated").isJsonPrimitive() && ElementKt.getBool((JsonElement)ElementKt.get((JsonElement)linkByName, (String)"templated"))) {
                        String string = ElementKt.get((JsonElement)linkByName, (String)"href").toString();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"linkByName[\"href\"].toString()");
                        pair = TuplesKt.to((Object)this.parseLinkUrl(string, options), (Object)false);
                    } else if (linkByName != null && linkByName.isJsonObject()) {
                        pair = TuplesKt.to((Object)ElementKt.getString((JsonElement)ElementKt.get((JsonElement)linkByName, (String)"href")), (Object)true);
                    } else {
                        throw (Throwable)new InvalidNavigationRequest("Link '" + link + "' does not have an entry with name '" + options.get("name") + "'. " + "URL: '" + this.baseUrl + "', LINK: '" + link + '\'');
                    }
                    return pair;
                }
                throw (Throwable)new InvalidNavigationRequest("Link '" + link + "' has multiple entries. You need to filter by the link name. " + "URL: '" + this.baseUrl + "', LINK: '" + link + '\'');
            }
            if (linkData.isJsonObject()) {
                return ElementKt.getObj((JsonElement)linkData).has("templated") && ElementKt.get((JsonElement)linkData, (String)"templated").isJsonPrimitive() && ElementKt.getBool((JsonElement)ElementKt.get((JsonElement)linkData, (String)"templated")) ? TuplesKt.to((Object)this.parseLinkUrl(ElementKt.getString((JsonElement)ElementKt.get((JsonElement)linkData, (String)"href")), options), (Object)false) : TuplesKt.to((Object)ElementKt.getString((JsonElement)ElementKt.get((JsonElement)linkData, (String)"href")), (Object)true);
            }
            throw (Throwable)new InvalidHalResponse("Expected link in map form in the response, but " + "found: " + linkData + ". URL: '" + this.baseUrl + "', LINK: '" + link + '\'');
        }
        throw (Throwable)new InvalidHalResponse("Expected a map of links in the response, but " + "found: " + links + ". URL: '" + this.baseUrl + "', LINK: '" + link + '\'');
    }

    @NotNull
    public final String parseLinkUrl(@NotNull String href, @NotNull Map<String, ? extends Object> options) {
        Intrinsics.checkParameterIsNotNull((Object)href, (String)"href");
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        String result = "";
        MatchResult match = Regex.find$default((Regex)URL_TEMPLATE_REGEX, (CharSequence)href, (int)0, (int)2, null);
        int index = 0;
        while (match != null) {
            MatchResult.Destructured destructured;
            int start = match.getRange().getFirst() - 1;
            if (start >= index) {
                int n = index;
                result = result + StringsKt.substring((String)href, (IntRange)new IntRange(n, start));
            }
            index = match.getRange().getLast() + 1;
            MatchResult.Destructured destructured2 = destructured = match.getDestructured();
            boolean bl = false;
            String key = (String)destructured2.getMatch().getGroupValues().get(1);
            result = result + this.encodePathParameter(options, key, match.getValue());
            match = URL_TEMPLATE_REGEX.find((CharSequence)href, index);
        }
        if (index < href.length()) {
            String string = href;
            StringBuilder stringBuilder = new StringBuilder().append(result);
            boolean bl = false;
            String string2 = string.substring(index);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            String string3 = string2;
            result = stringBuilder.append(string3).toString();
        }
        return result;
    }

    private final String encodePathParameter(Map<String, ? extends Object> options, String key, String value) {
        Escaper escaper = UrlEscapers.urlPathSegmentEscaper();
        Object object = options.get(key);
        if (object == null || (object = object.toString()) == null) {
            object = value;
        }
        return escaper.escape((String)object);
    }

    public final void initPathInfo() {
        JsonElement jsonElement = this.pathInfo;
        if (jsonElement == null) {
            jsonElement = this.fetch(ROOT);
        }
        this.pathInfo = jsonElement;
    }

    @Override
    @Nullable
    public Object uploadJson(@NotNull String path, @NotNull String bodyJson) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)bodyJson, (String)"bodyJson");
        return this.uploadJson(path, bodyJson, uploadJson.1.INSTANCE, true);
    }

    @Override
    @Nullable
    public Object uploadJson(@NotNull String path, @NotNull String bodyJson, @NotNull BiFunction<String, String, Object> closure) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)bodyJson, (String)"bodyJson");
        Intrinsics.checkParameterIsNotNull(closure, (String)"closure");
        return this.uploadJson(path, bodyJson, closure, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object uploadJson(@NotNull String path, @NotNull String bodyJson, @NotNull BiFunction<String, String, Object> closure, boolean encodePath) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)bodyJson, (String)"bodyJson");
        Intrinsics.checkParameterIsNotNull(closure, (String)"closure");
        CloseableHttpClient client = this.setupHttpClient();
        HttpPut httpPut = (HttpPut)this.initialiseRequest((HttpMessage)new HttpPut(HttpClientUtils.INSTANCE.buildUrl(this.baseUrl, path, encodePath)));
        httpPut.addHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
        httpPut.setEntity((HttpEntity)new StringEntity(bodyJson, ContentType.APPLICATION_JSON));
        Closeable closeable = (Closeable)client.execute((HttpUriRequest)httpPut, (HttpContext)this.httpContext);
        boolean bl = false;
        Throwable throwable = null;
        try {
            Object object;
            CloseableHttpResponse it = (CloseableHttpResponse)closeable;
            boolean bl2 = false;
            CloseableHttpResponse closeableHttpResponse = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpResponse, (String)"it");
            StatusLine statusLine = closeableHttpResponse.getStatusLine();
            Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"it.statusLine");
            if (statusLine.getStatusCode() < 300) {
                EntityUtils.consume((HttpEntity)it.getEntity());
                object = closure.apply("OK", it.getStatusLine().toString());
            } else {
                String body;
                boolean bl3;
                int n;
                Closeable closeable2;
                boolean bl4;
                Charset charset;
                InputStream inputStream;
                StatusLine statusLine2 = it.getStatusLine();
                Intrinsics.checkExpressionValueIsNotNull((Object)statusLine2, (String)"it.statusLine");
                if (statusLine2.getStatusCode() == 409) {
                    HttpEntity httpEntity = it.getEntity();
                    Intrinsics.checkExpressionValueIsNotNull((Object)httpEntity, (String)"it.entity");
                    InputStream inputStream2 = httpEntity.getContent();
                    Intrinsics.checkExpressionValueIsNotNull((Object)inputStream2, (String)"it.entity.content");
                    inputStream = inputStream2;
                    charset = Charsets.UTF_8;
                    bl4 = false;
                    closeable2 = inputStream;
                    n = 0;
                    closeable2 = new InputStreamReader((InputStream)closeable2, charset);
                    n = 8192;
                    bl3 = false;
                    body = TextStreamsKt.readText((Reader)(closeable2 instanceof BufferedReader ? (BufferedReader)closeable2 : new BufferedReader((Reader)closeable2, n)));
                    StringBuilder stringBuilder = new StringBuilder();
                    StatusLine statusLine3 = it.getStatusLine();
                    Intrinsics.checkExpressionValueIsNotNull((Object)statusLine3, (String)"it.statusLine");
                    StringBuilder stringBuilder2 = stringBuilder.append(statusLine3.getStatusCode()).append(' ');
                    StatusLine statusLine4 = it.getStatusLine();
                    Intrinsics.checkExpressionValueIsNotNull((Object)statusLine4, (String)"it.statusLine");
                    object = closure.apply("FAILED", stringBuilder2.append(statusLine4.getReasonPhrase()).append(" - ").append(body).toString());
                } else {
                    HttpEntity httpEntity = it.getEntity();
                    Intrinsics.checkExpressionValueIsNotNull((Object)httpEntity, (String)"it.entity");
                    InputStream inputStream3 = httpEntity.getContent();
                    Intrinsics.checkExpressionValueIsNotNull((Object)inputStream3, (String)"it.entity.content");
                    inputStream = inputStream3;
                    charset = Charsets.UTF_8;
                    bl4 = false;
                    closeable2 = inputStream;
                    n = 0;
                    closeable2 = new InputStreamReader((InputStream)closeable2, charset);
                    n = 8192;
                    bl3 = false;
                    body = TextStreamsKt.readText((Reader)(closeable2 instanceof BufferedReader ? (BufferedReader)closeable2 : new BufferedReader((Reader)closeable2, n)));
                    object = this.handleFailure((HttpResponse)it, body, closure);
                }
            }
            Object object2 = object;
            return object2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Nullable
    public final Object handleFailure(@NotNull HttpResponse resp, @Nullable String body, @NotNull BiFunction<String, String, Object> closure) {
        Intrinsics.checkParameterIsNotNull((Object)resp, (String)"resp");
        Intrinsics.checkParameterIsNotNull(closure, (String)"closure");
        HttpEntity httpEntity = resp.getEntity();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpEntity, (String)"resp.entity");
        if (httpEntity.getContentType() != null) {
            ContentType contentType;
            ContentType contentType2 = contentType = ContentType.getOrDefault((HttpEntity)resp.getEntity());
            Intrinsics.checkExpressionValueIsNotNull((Object)contentType2, (String)"contentType");
            if (HttpClientUtils.INSTANCE.isJsonResponse(contentType2)) {
                JsonElement jsonBody;
                String error = "";
                if (KotlinLanguageSupportKt.isNotEmpty((String)body) && (jsonBody = new JsonParser().parse(body)) != null && ElementKt.getObj((JsonElement)jsonBody).has("errors")) {
                    if (ElementKt.get((JsonElement)jsonBody, (String)"errors").isJsonArray()) {
                        StringBuilder stringBuilder = new StringBuilder().append(" - ");
                        JsonArray jsonArray = ElementKt.get((JsonElement)jsonBody, (String)"errors").getAsJsonArray();
                        Intrinsics.checkExpressionValueIsNotNull((Object)jsonArray, (String)"jsonBody[\"errors\"].asJsonArray");
                        error = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)((Iterable)jsonArray), (CharSequence)", ", null, null, (int)0, null, (Function1)handleFailure.1.INSTANCE, (int)30, null)).toString();
                    } else if (ElementKt.get((JsonElement)jsonBody, (String)"errors").isJsonObject()) {
                        StringBuilder stringBuilder = new StringBuilder().append(" - ");
                        Set set = ElementKt.get((JsonElement)jsonBody, (String)"errors").getAsJsonObject().entrySet();
                        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"jsonBody[\"errors\"].asJsonObject.entrySet()");
                        error = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)set, (CharSequence)", ", null, null, (int)0, null, (Function1)handleFailure.2.INSTANCE, (int)30, null)).toString();
                    }
                }
                StringBuilder stringBuilder = new StringBuilder();
                StatusLine statusLine = resp.getStatusLine();
                Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"resp.statusLine");
                StringBuilder stringBuilder2 = stringBuilder.append(statusLine.getStatusCode()).append(' ');
                StatusLine statusLine2 = resp.getStatusLine();
                Intrinsics.checkExpressionValueIsNotNull((Object)statusLine2, (String)"resp.statusLine");
                return closure.apply("FAILED", stringBuilder2.append(statusLine2.getReasonPhrase()).append(error).toString());
            }
            StringBuilder stringBuilder = new StringBuilder();
            StatusLine statusLine = resp.getStatusLine();
            Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"resp.statusLine");
            StringBuilder stringBuilder3 = stringBuilder.append(statusLine.getStatusCode()).append(' ');
            StatusLine statusLine3 = resp.getStatusLine();
            Intrinsics.checkExpressionValueIsNotNull((Object)statusLine3, (String)"resp.statusLine");
            return closure.apply("FAILED", stringBuilder3.append(statusLine3.getReasonPhrase()).append(" - ").append(body).toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        StatusLine statusLine = resp.getStatusLine();
        Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"resp.statusLine");
        StringBuilder stringBuilder4 = stringBuilder.append(statusLine.getStatusCode()).append(' ');
        StatusLine statusLine4 = resp.getStatusLine();
        Intrinsics.checkExpressionValueIsNotNull((Object)statusLine4, (String)"resp.statusLine");
        return closure.apply("FAILED", stringBuilder4.append(statusLine4.getReasonPhrase()).append(" - ").append(body).toString());
    }

    @Override
    @Nullable
    public String linkUrl(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        JsonElement jsonElement = this.pathInfo;
        if (jsonElement == null) {
            Intrinsics.throwNpe();
        }
        if (ElementKt.getObj((JsonElement)jsonElement).has(LINKS)) {
            JsonElement linkData;
            JsonElement links;
            JsonElement jsonElement2 = this.pathInfo;
            if (jsonElement2 == null) {
                Intrinsics.throwNpe();
            }
            if ((links = ElementKt.get((JsonElement)jsonElement2, (String)LINKS)).isJsonObject() && ElementKt.getObj((JsonElement)links).has(name) && (linkData = ElementKt.get((JsonElement)links, (String)name)).isJsonObject() && ElementKt.getObj((JsonElement)linkData).has("href")) {
                return String.valueOf(Companion.fromJson(ElementKt.get((JsonElement)linkData, (String)"href")));
            }
        }
        return null;
    }

    @Override
    public void forAll(@NotNull String linkName, @NotNull Consumer<Map<String, Object>> closure) {
        JsonElement links;
        Intrinsics.checkParameterIsNotNull((Object)linkName, (String)"linkName");
        Intrinsics.checkParameterIsNotNull(closure, (String)"closure");
        this.initPathInfo();
        JsonElement jsonElement = this.pathInfo;
        if (jsonElement == null) {
            Intrinsics.throwNpe();
        }
        if ((links = ElementKt.get((JsonElement)jsonElement, (String)LINKS)).isJsonObject() && ElementKt.getObj((JsonElement)links).has(linkName)) {
            JsonElement matchingLink = ElementKt.get((JsonElement)links, (String)linkName);
            if (matchingLink.isJsonArray()) {
                JsonArray jsonArray = matchingLink.getAsJsonArray();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonArray, (String)"matchingLink.asJsonArray");
                Iterable $this$forEach$iv = (Iterable)jsonArray;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    JsonElement it = (JsonElement)element$iv;
                    boolean bl = false;
                    JsonElement jsonElement2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement2, (String)"it");
                    JsonObject jsonObject = jsonElement2.getAsJsonObject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"it.asJsonObject");
                    closure.accept(Companion.asMap(jsonObject));
                }
            } else {
                JsonObject jsonObject = matchingLink.getAsJsonObject();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"matchingLink.asJsonObject");
                closure.accept(Companion.asMap(jsonObject));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Result<Boolean, Exception> putJson(@NotNull String link, @NotNull Map<String, ? extends Object> options, @NotNull String json) {
        Result result;
        Intrinsics.checkParameterIsNotNull((Object)link, (String)"link");
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Pair<String, Boolean> href = this.hrefForLink(link, options);
        HttpPut httpPut = (HttpPut)this.initialiseRequest((HttpMessage)new HttpPut(HttpClientUtils.INSTANCE.buildUrl(this.baseUrl, (String)href.getFirst(), (Boolean)href.getSecond())));
        httpPut.addHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
        httpPut.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
        Result.Companion this_$iv = Result.Companion;
        boolean $i$f$of = false;
        try {
            Boolean bl;
            boolean bl2;
            boolean bl3 = false;
            CloseableHttpClient closeableHttpClient = this.httpClient;
            if (closeableHttpClient == null) {
                Intrinsics.throwNpe();
            }
            Closeable closeable = (Closeable)closeableHttpClient.execute((HttpUriRequest)httpPut, (HttpContext)this.httpContext);
            boolean bl4 = false;
            Throwable throwable = null;
            try {
                boolean bl5;
                CloseableHttpResponse it = (CloseableHttpResponse)closeable;
                boolean bl6 = false;
                CloseableHttpResponse closeableHttpResponse = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpResponse, (String)"it");
                StatusLine statusLine = closeableHttpResponse.getStatusLine();
                Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"it.statusLine");
                if (statusLine.getStatusCode() < 300) {
                    bl5 = true;
                } else {
                    Companion.getLogger().error((Function0)new Function0<String>(it){
                        final /* synthetic */ CloseableHttpResponse $it;

                        @NotNull
                        public final String invoke() {
                            StringBuilder stringBuilder = new StringBuilder().append("PUT JSON request failed with status ");
                            CloseableHttpResponse closeableHttpResponse = this.$it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpResponse, (String)"it");
                            return stringBuilder.append(closeableHttpResponse.getStatusLine()).toString();
                        }
                        {
                            this.$it = closeableHttpResponse;
                            super(0);
                        }
                    });
                    bl5 = false;
                }
                bl2 = bl5;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Boolean bl7 = bl = Boolean.valueOf(bl2);
            result = (Result)new Ok((Object)bl7);
        }
        catch (Exception ex$iv) {
            result = (Result)new Err((Object)ex$iv);
        }
        return result;
    }

    @NotNull
    public final String getBaseUrl() {
        return this.baseUrl;
    }

    @NotNull
    public final Map<String, Object> getOptions() {
        return this.options;
    }

    public final void setOptions(@NotNull Map<String, ? extends Object> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"<set-?>");
        this.options = map;
    }

    @JvmOverloads
    public HalClient(@NotNull String baseUrl, @NotNull Map<String, ? extends Object> options) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        this.baseUrl = baseUrl;
        this.options = options;
        HalClient halClient = this;
        boolean bl = false;
        halClient.defaultHeaders = map = (Map)new LinkedHashMap();
        this.maxPublishRetries = 5;
        this.publishRetryInterval = 3000;
        if (this.options.containsKey("halClient")) {
            Object object = this.options.get("halClient");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
            }
            Map halClient2 = (Map)object;
            Integer n = halClient2.getOrDefault("maxPublishRetries", this.maxPublishRetries);
            if (n == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
            }
            this.maxPublishRetries = n;
            Integer n2 = halClient2.getOrDefault("publishRetryInterval", this.publishRetryInterval);
            if (n2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
            }
            this.publishRetryInterval = n2;
        }
    }

    public /* synthetic */ HalClient(String string, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            boolean bl = false;
            map = MapsKt.emptyMap();
        }
        this(string, map);
    }

    @JvmOverloads
    public HalClient(@NotNull String baseUrl) {
        this(baseUrl, null, 2, null);
    }

    static {
        Companion = new Companion(null);
        URL_TEMPLATE_REGEX = new Regex("\\{(\\w+)\\}");
    }

    @JvmStatic
    @NotNull
    public static final Map<String, Object> asMap(@NotNull JsonObject jsonObject) {
        return Companion.asMap(jsonObject);
    }

    @JvmStatic
    @Nullable
    public static final Object fromJson(@NotNull JsonElement jsonValue) {
        return Companion.fromJson(jsonValue);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u000b\u001a\u0018\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00040\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lau/com/dius/pact/core/pactbroker/HalClient$Companion;", "Lmu/KLogging;", "()V", "LINKS", "", "PREEMPTIVE_AUTHENTICATION", "ROOT", "URL_TEMPLATE_REGEX", "Lkotlin/text/Regex;", "getURL_TEMPLATE_REGEX", "()Lkotlin/text/Regex;", "asMap", "", "kotlin.jvm.PlatformType", "", "jsonObject", "Lcom/google/gson/JsonObject;", "fromJson", "jsonValue", "Lcom/google/gson/JsonElement;", "pact-jvm-core-pact-broker"})
    public static final class Companion
    extends KLogging {
        @NotNull
        public final Regex getURL_TEMPLATE_REGEX() {
            return URL_TEMPLATE_REGEX;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Map<String, Object> asMap(@NotNull JsonObject jsonObject) {
            void $this$associateTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)jsonObject, (String)"jsonObject");
            Set set = jsonObject.entrySet();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"jsonObject.entrySet()");
            Iterable $this$associate$iv = set;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv;
                boolean bl = false;
                Object k = entry.getKey();
                Object v = entry.getValue();
                Intrinsics.checkExpressionValueIsNotNull(v, (String)"entry.value");
                Pair pair = TuplesKt.to(k, (Object)Companion.fromJson((JsonElement)v));
                boolean bl2 = false;
                map.put(pair.getFirst(), pair.getSecond());
            }
            return destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @Nullable
        public final Object fromJson(@NotNull JsonElement jsonValue) {
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)jsonValue, (String)"jsonValue");
            if (jsonValue.isJsonObject()) {
                JsonObject jsonObject = jsonValue.getAsJsonObject();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"jsonValue.asJsonObject");
                object = this.asMap(jsonObject);
            } else if (jsonValue.isJsonArray()) {
                void $this$mapTo$iv$iv;
                JsonArray jsonArray = jsonValue.getAsJsonArray();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonArray, (String)"jsonValue.asJsonArray");
                Iterable $this$map$iv = (Iterable)jsonArray;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JsonElement jsonElement = (JsonElement)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    void v3 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
                    Object object2 = Companion.fromJson((JsonElement)v3);
                    collection.add(object2);
                }
                object = (List)destination$iv$iv;
            } else if (jsonValue.isJsonNull()) {
                object = null;
            } else {
                JsonPrimitive primitive = jsonValue.getAsJsonPrimitive();
                JsonPrimitive jsonPrimitive = primitive;
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonPrimitive, (String)"primitive");
                object = jsonPrimitive.isBoolean() ? Boolean.valueOf(primitive.getAsBoolean()) : (primitive.isNumber() ? primitive.getAsBigDecimal() : primitive.getAsString());
            }
            return object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

