/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.model;

import au.com.dius.pact.model.BrokerUrlSource;
import au.com.dius.pact.model.InvalidHttpResponseException;
import au.com.dius.pact.model.PactReaderKt;
import au.com.dius.pact.model.PactSource;
import au.com.dius.pact.model.UrlPactSource;
import au.com.dius.pact.pactbroker.PactResponse;
import au.com.dius.pact.provider.broker.PactBrokerClient;
import au.com.dius.pact.provider.broker.com.github.kittinunf.result.Result;
import au.com.dius.pact.util.HttpClientUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import groovy.json.JsonSlurper;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001aF\u0010\u0005\u001a\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\b\u0012\u00060\nj\u0002`\u000b0\u00062\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\t\u001a8\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00130\u00072\u0006\u0010\u0011\u001a\u00020\t2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00100\u000f2\b\u0010\f\u001a\u0004\u0018\u00010\r\u001a\"\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00022\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00100\u000f\"&\u0010\u0000\u001a\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"ACCEPT_JSON", "", "", "logger", "Lmu/KLogger;", "fetchJsonResource", "Lau/com/dius/pact/provider/broker/com/github/kittinunf/result/Result;", "Lkotlin/Pair;", "Lcom/google/gson/JsonElement;", "Lau/com/dius/pact/model/UrlPactSource;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "http", "Lorg/apache/http/impl/client/CloseableHttpClient;", "options", "", "", "source", "loadPactFromUrl", "Lau/com/dius/pact/model/PactSource;", "newHttpClient", "baseUrl", "pact-jvm-model"})
public final class PactReaderKt {
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    private static final Map<String, Map<String, String>> ACCEPT_JSON = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"requestProperties", (Object)MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"Accept", (Object)"application/json")}))});

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final Pair<Object, PactSource> loadPactFromUrl(@NotNull UrlPactSource source, @NotNull Map<String, ? extends Object> options, @Nullable CloseableHttpClient http) {
        Result<Pair<JsonElement, UrlPactSource>, Exception> jsonResource;
        Result<Pair<JsonElement, UrlPactSource>, Exception> result;
        Pair pair;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        UrlPactSource urlPactSource = source;
        if (urlPactSource instanceof BrokerUrlSource) {
            PactBrokerClient brokerClient = new PactBrokerClient(((BrokerUrlSource)source).getPactBrokerUrl(), options);
            PactResponse pactResponse = brokerClient.fetchPact(source.getUrl());
            pair = TuplesKt.to((Object)pactResponse.getPactFile(), (Object)BrokerUrlSource.copy$default((BrokerUrlSource)source, null, null, pactResponse.getLinks(), options, 3, null));
            return pair;
        }
        if (!options.containsKey("authentication")) {
            pair = TuplesKt.to((Object)new JsonSlurper().parse(new URL(source.getUrl()), ACCEPT_JSON), (Object)source);
            return pair;
        }
        CloseableHttpClient closeableHttpClient = http;
        if (closeableHttpClient == null) {
            Intrinsics.throwNpe();
        }
        if ((result = (jsonResource = PactReaderKt.fetchJsonResource(closeableHttpClient, options, source))) instanceof Result.Success) {
            pair = (Pair)((Result.Success)jsonResource).getValue();
            return pair;
        }
        if (!(result instanceof Result.Failure)) throw new NoWhenBranchMatchedException();
        throw (Throwable)((Result.Failure)jsonResource).getError();
    }

    @NotNull
    public static final Result<Pair<JsonElement, UrlPactSource>, Exception> fetchJsonResource(@NotNull CloseableHttpClient http, @NotNull Map<String, ? extends Object> options, @NotNull UrlPactSource source) {
        Intrinsics.checkParameterIsNotNull((Object)http, (String)"http");
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        return Result.Companion.of((Function0)new Function0<Pair<? extends JsonElement, ? extends UrlPactSource>>(source, http){
            final /* synthetic */ UrlPactSource $source;
            final /* synthetic */ CloseableHttpClient $http;

            @NotNull
            public final Pair<JsonElement, UrlPactSource> invoke() {
                CloseableHttpResponse response;
                HttpGet httpGet = new HttpGet(HttpClientUtils.INSTANCE.buildUrl("", this.$source.getUrl(), true));
                httpGet.addHeader("Content-Type", "application/json");
                httpGet.addHeader("Accept", "application/hal+json, application/json");
                CloseableHttpResponse closeableHttpResponse = response = this.$http.execute((HttpUriRequest)httpGet);
                Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpResponse, (String)"response");
                StatusLine statusLine = closeableHttpResponse.getStatusLine();
                Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"response.statusLine");
                if (statusLine.getStatusCode() < 300) {
                    ContentType contentType;
                    ContentType contentType2 = contentType = ContentType.getOrDefault((HttpEntity)response.getEntity());
                    Intrinsics.checkExpressionValueIsNotNull((Object)contentType2, (String)"contentType");
                    if (HttpClientUtils.INSTANCE.isJsonResponse(contentType2)) {
                        return TuplesKt.to((Object)new JsonParser().parse(EntityUtils.toString((HttpEntity)response.getEntity())), (Object)this.$source);
                    }
                    throw (Throwable)new InvalidHttpResponseException("Expected a JSON response, but got '" + contentType + '\'');
                }
                StatusLine statusLine2 = response.getStatusLine();
                Intrinsics.checkExpressionValueIsNotNull((Object)statusLine2, (String)"response.statusLine");
                switch (statusLine2.getStatusCode()) {
                    case 404: {
                        throw (Throwable)new InvalidHttpResponseException("No JSON document found at source '" + this.$source + '\'');
                    }
                }
                throw (Throwable)new InvalidHttpResponseException("Request to source '" + this.$source + "' failed with response " + '\'' + response.getStatusLine() + '\'');
            }
            {
                this.$source = urlPactSource;
                this.$http = closeableHttpClient;
                super(0);
            }
        });
    }

    @NotNull
    public static final CloseableHttpClient newHttpClient(@NotNull String baseUrl, @NotNull Map<String, ? extends Object> options) {
        Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        HttpClientBuilder builder = HttpClients.custom().useSystemProperties();
        if (options.get("authentication") instanceof List) {
            String scheme;
            String string;
            Object object = options.get("authentication");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<*>");
            }
            List authentication = (List)object;
            String string2 = string = String.valueOf(CollectionsKt.first((List)authentication));
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            string = scheme = string3;
            switch (string.hashCode()) {
                case 93508654: {
                    if (string.equals("basic")) {
                        if (authentication.size() > 2) {
                            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                            URI uri = new URI(baseUrl);
                            credsProvider.setCredentials(new AuthScope(uri.getHost(), uri.getPort()), (Credentials)new UsernamePasswordCredentials(String.valueOf(authentication.get(1)), String.valueOf(authentication.get(2))));
                            builder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
                            break;
                        }
                        logger.warn((Function0)newHttpClient.1.INSTANCE);
                        break;
                    }
                }
                default: {
                    logger.warn((Function0)new Function0<String>(scheme){
                        final /* synthetic */ String $scheme;

                        @NotNull
                        public final String invoke() {
                            return "Only supports basic authentication, got '" + this.$scheme + "', ignoring.";
                        }
                        {
                            this.$scheme = string;
                            super(0);
                        }
                    });
                    break;
                }
            }
        } else if (options.containsKey("authentication")) {
            logger.warn((Function0)new Function0<String>(options){
                final /* synthetic */ Map $options;

                @NotNull
                public final String invoke() {
                    return "Authentication options needs to be a list of values, got '" + this.$options.get("authentication") + "', ignoring.";
                }
                {
                    this.$options = map;
                    super(0);
                }
            });
        }
        CloseableHttpClient closeableHttpClient = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpClient, (String)"builder.build()");
        return closeableHttpClient;
    }
}

