/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junit.target;

import au.com.dius.pact.model.Interaction;
import au.com.dius.pact.provider.ConsumerInfo;
import au.com.dius.pact.provider.PactVerification;
import au.com.dius.pact.provider.ProviderInfo;
import au.com.dius.pact.provider.ProviderVerifier;
import au.com.dius.pact.provider.junit.Provider;
import au.com.dius.pact.provider.junit.target.BaseTarget;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.codehaus.groovy.runtime.MethodClosure;

public class AmqpTarget
extends BaseTarget {
    private List<String> packagesToScan = Collections.emptyList();

    public AmqpTarget() {
    }

    public AmqpTarget(List<String> packagesToScan) {
        this.packagesToScan = packagesToScan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testInteraction(String consumerName, Interaction interaction) {
        ProviderInfo provider = this.getProviderInfo();
        ConsumerInfo consumer = new ConsumerInfo(consumerName);
        ProviderVerifier verifier = this.setupVerifier(interaction, provider, consumer);
        HashMap<String, Object> failures = new HashMap<String, Object>();
        verifier.verifyResponseByInvokingProviderMethods(provider, consumer, (Object)interaction, interaction.getDescription(), failures);
        try {
            if (!failures.isEmpty()) {
                verifier.displayFailures(failures);
                throw this.getAssertionError(failures);
            }
        }
        finally {
            verifier.finialiseReports();
        }
    }

    @Override
    ProviderVerifier setupVerifier(Interaction interaction, ProviderInfo provider, ConsumerInfo consumer) {
        ProviderVerifier verifier = new ProviderVerifier();
        verifier.setProjectClasspath((Object)new MethodClosure((Object)this, "getClassPathUrls"));
        this.setupReporters(verifier, provider.getName(), interaction.getDescription());
        verifier.initialiseReporters(provider);
        verifier.reportVerificationForConsumer(consumer, provider);
        if (interaction.getProviderState() != null) {
            verifier.reportStateForInteraction(interaction.getProviderState(), provider, consumer, true);
        }
        verifier.reportInteractionDescription((Object)interaction);
        return verifier;
    }

    private URL[] getClassPathUrls() {
        return ((URLClassLoader)ClassLoader.getSystemClassLoader()).getURLs();
    }

    @Override
    ProviderInfo getProviderInfo() {
        Provider provider = (Provider)this.testClass.getAnnotation(Provider.class);
        ProviderInfo providerInfo = new ProviderInfo(provider.value());
        providerInfo.setVerificationType(PactVerification.ANNOTATED_METHOD);
        providerInfo.setPackagesToScan(this.packagesToScan);
        return providerInfo;
    }
}

