/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junit.loader;

import au.com.dius.pact.model.Pact;
import au.com.dius.pact.model.PactReader;
import au.com.dius.pact.provider.ConsumerInfo;
import au.com.dius.pact.provider.broker.PactBrokerClient;
import au.com.dius.pact.provider.junit.loader.NoPactsFoundException;
import au.com.dius.pact.provider.junit.loader.PactBroker;
import au.com.dius.pact.provider.junit.loader.PactBrokerAuth;
import au.com.dius.pact.provider.junit.loader.PactLoader;
import au.com.dius.pact.provider.junit.sysprops.PactRunnerExpressionParser;
import au.com.dius.pact.provider.junit.sysprops.PactRunnerTagListExpressionParser;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PactBrokerLoader
implements PactLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(PactBrokerLoader.class);
    private static final String LATEST = "latest";
    private final String pactBrokerHost;
    private final String pactBrokerPort;
    private final String pactBrokerProtocol;
    private final List<String> pactBrokerTags;
    private boolean failIfNoPactsFound;
    private PactBrokerAuth authentication;

    public PactBrokerLoader(String pactBrokerHost, String pactBrokerPort, String pactBrokerProtocol) {
        this(pactBrokerHost, pactBrokerPort, pactBrokerProtocol, Collections.singletonList(LATEST));
    }

    public PactBrokerLoader(String pactBrokerHost, String pactBrokerPort, String pactBrokerProtocol, List<String> tags) {
        this.pactBrokerHost = pactBrokerHost;
        this.pactBrokerPort = pactBrokerPort;
        this.pactBrokerProtocol = pactBrokerProtocol;
        this.pactBrokerTags = PactRunnerTagListExpressionParser.parseTagListExpressions(tags);
        this.failIfNoPactsFound = true;
    }

    public PactBrokerLoader(PactBroker pactBroker) {
        this(pactBroker.host(), pactBroker.port(), pactBroker.protocol(), Arrays.asList(pactBroker.tags()));
        this.failIfNoPactsFound = pactBroker.failIfNoPactsFound();
        this.authentication = pactBroker.authentication();
    }

    @Override
    public List<Pact> load(String providerName) throws IOException {
        ArrayList<Pact> pacts = new ArrayList<Pact>();
        if (this.pactBrokerTags == null || this.pactBrokerTags.isEmpty() || this.pactBrokerTags.size() == 1 && this.pactBrokerTags.contains(LATEST)) {
            pacts.addAll(this.loadPactsForProvider(providerName, null));
        } else {
            for (String tag : this.pactBrokerTags) {
                pacts.addAll(this.loadPactsForProvider(providerName, tag));
            }
        }
        return pacts;
    }

    private List<Pact> loadPactsForProvider(String providerName, String tag) throws IOException {
        LOGGER.debug("Loading pacts from pact broker for provider " + providerName + " and tag " + tag);
        URIBuilder uriBuilder = new URIBuilder().setScheme(PactRunnerExpressionParser.parseExpressions(this.pactBrokerProtocol)).setHost(PactRunnerExpressionParser.parseExpressions(this.pactBrokerHost)).setPort(Integer.parseInt(PactRunnerExpressionParser.parseExpressions(this.pactBrokerPort)));
        try {
            PactBrokerClient pactBrokerClient = this.newPactBrokerClient(uriBuilder.build());
            List consumers = StringUtils.isEmpty((CharSequence)tag) ? pactBrokerClient.fetchConsumers(providerName) : pactBrokerClient.fetchConsumersWithTag(providerName, tag);
            if (this.failIfNoPactsFound && consumers.isEmpty()) {
                throw new NoPactsFoundException("No consumer pacts were found for provider '" + providerName + "' and tag '" + tag + "'. (URL " + pactBrokerClient.getUrlForProvider(providerName, tag) + ")");
            }
            return consumers.stream().map(consumer -> this.loadPact((ConsumerInfo)consumer, pactBrokerClient.getOptions())).collect(Collectors.toList());
        }
        catch (URISyntaxException e) {
            throw new IOException("Was not able load pacts from broker as the broker URL was invalid", e);
        }
    }

    Pact loadPact(ConsumerInfo consumer, Map options) {
        return PactReader.loadPact((Map)options, (Object)consumer.getPactFile());
    }

    PactBrokerClient newPactBrokerClient(URI url) throws URISyntaxException {
        HashMap<String, List<String>> options = new HashMap<String, List<String>>();
        if (this.authentication != null && !this.authentication.scheme().equalsIgnoreCase("none")) {
            options.put("authentication", Arrays.asList(PactRunnerExpressionParser.parseExpressions(this.authentication.scheme()), PactRunnerExpressionParser.parseExpressions(this.authentication.username()), PactRunnerExpressionParser.parseExpressions(this.authentication.password())));
        }
        return new PactBrokerClient((Object)url, options);
    }

    public boolean isFailIfNoPactsFound() {
        return this.failIfNoPactsFound;
    }

    public void setFailIfNoPactsFound(boolean failIfNoPactsFound) {
        this.failIfNoPactsFound = failIfNoPactsFound;
    }
}

