/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junit.loader;

import au.com.dius.pact.model.Pact;
import au.com.dius.pact.provider.junit.loader.PactLoader;
import au.com.dius.pact.provider.junit.loader.PactUrlLoader;
import au.com.dius.pact.provider.junit.loader.VersionedPactUrl;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class VersionedPactUrlLoader
implements PactLoader {
    private final String[] urls;

    public VersionedPactUrlLoader(String[] urls) {
        this.urls = urls;
    }

    public VersionedPactUrlLoader(VersionedPactUrl pactUrl) {
        this(pactUrl.urls());
    }

    @Override
    public List<Pact> load(String providerName) throws IOException {
        return new PactUrlLoader(VersionedPactUrlLoader.expandVariables(this.urls)).load(providerName);
    }

    @VisibleForTesting
    static String[] expandVariables(String[] urls) throws IOException {
        return Arrays.stream(urls).map(VersionedPactUrlLoader::expandVariables).collect(Collectors.toList()).toArray(new String[urls.length]);
    }

    private static String expandVariables(String urlWithVariables) {
        String urlWithVersions = urlWithVariables;
        if (!VersionedPactUrlLoader.variablesToExpandFound(urlWithVersions)) {
            throw new IllegalArgumentException(urlWithVersions + " contains no variables to expand in the format ${...}. Consider using @PactUrl or providing expandable variables.");
        }
        for (Map.Entry<Object, Object> property : System.getProperties().entrySet()) {
            urlWithVersions = urlWithVersions.replace(String.format("${%s}", property.getKey()), property.getValue().toString());
        }
        if (VersionedPactUrlLoader.variablesToExpandFound(urlWithVersions)) {
            throw new IllegalArgumentException(urlWithVersions + " contains variables that could not be any of the system properties. Define a system property to replace them or remove the variables from the URL.");
        }
        return urlWithVersions;
    }

    private static boolean variablesToExpandFound(String urlWithVersions) {
        return urlWithVersions.matches(".*\\$\\{[a-z\\.]+\\}.*");
    }
}

