/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junit.sysprops;

import au.com.dius.pact.provider.junit.sysprops.SystemPropertyResolver;
import au.com.dius.pact.provider.junit.sysprops.ValueResolver;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PactRunnerTagListExpressionParser {
    public static List<String> parseTagListExpressions(List<String> values) {
        return PactRunnerTagListExpressionParser.parseTagListExpressions(values, new SystemPropertyResolver());
    }

    public static List<String> parseTagListExpressions(List<String> values, ValueResolver valueResolver) {
        return values.stream().flatMap(value -> PactRunnerTagListExpressionParser.substituteIfExpression(value, valueResolver)).collect(Collectors.toList());
    }

    private static Stream<String> substituteIfExpression(String value, ValueResolver valueResolver) {
        if (value.contains("${")) {
            String[] split = valueResolver.resolveValue(value).split(",");
            return Arrays.stream(split).filter(str -> !Strings.isNullOrEmpty((String)str));
        }
        return Stream.of(value);
    }
}

