/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.maven;

import au.com.dius.pact.core.pactbroker.PactBrokerClient;
import au.com.dius.pact.provider.maven.PactBaseMojo;
import au.com.dius.pact.provider.maven.PactPublishMojo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.fusesource.jansi.AnsiConsole;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010\u0010\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00078\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\u00078\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u000b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u000b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lau/com/dius/pact/provider/maven/PactPublishMojo;", "Lau/com/dius/pact/provider/maven/PactBaseMojo;", "()V", "brokerClient", "Lau/com/dius/pact/core/pactbroker/PactBrokerClient;", "excludes", "", "", "pactDirectory", "projectVersion", "skipPactPublish", "", "tags", "trimSnapshot", "execute", "", "pactFileIsExcluded", "exclusions", "", "Lkotlin/text/Regex;", "pactFile", "Ljava/io/File;", "pact-jvm-provider-maven"})
@Mojo(name="publish")
public class PactPublishMojo
extends PactBaseMojo {
    @Parameter(defaultValue="false")
    private boolean skipPactPublish;
    @Parameter(required=true, defaultValue="${project.version}")
    private String projectVersion;
    @Parameter(defaultValue="false")
    private boolean trimSnapshot;
    @Parameter(defaultValue="${project.build.directory}/pacts")
    private String pactDirectory;
    private PactBrokerClient brokerClient;
    @Parameter
    private List<String> tags;
    @Parameter
    private List<String> excludes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void execute() {
        File pactDirectory;
        AnsiConsole.systemInstall();
        if (this.skipPactPublish) {
            String string = "'skipPactPublish' is set to true, skipping uploading of pacts";
            boolean bl = false;
            System.out.println((Object)string);
            return;
        }
        CharSequence charSequence = this.getPactBrokerUrl();
        boolean bl = false;
        boolean bl2 = false;
        if ((charSequence == null || charSequence.length() == 0) && this.brokerClient == null) {
            throw (Throwable)new MojoExecutionException("pactBrokerUrl is required");
        }
        String snapShotDefinitionString = "-SNAPSHOT";
        String emptyString = "";
        if (this.trimSnapshot) {
            String string = this.projectVersion;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"projectVersion");
            }
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)snapShotDefinitionString, (boolean)false, (int)2, null)) {
                String string2 = this.projectVersion;
                if (string2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"projectVersion");
                }
                this.projectVersion = StringsKt.replaceFirst$default((String)string2, (String)snapShotDefinitionString, (String)emptyString, (boolean)false, (int)4, null);
            }
        }
        if (this.brokerClient == null) {
            String string = this.getPactBrokerUrl();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            this.brokerClient = new PactBrokerClient(string, this.brokerClientOptions());
        }
        String string = this.pactDirectory;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pactDirectory");
        }
        if (!(pactDirectory = new File(string)).exists()) {
            String string3 = "Pact directory " + pactDirectory + " does not exist, skipping uploading of pacts";
            boolean bl3 = false;
            System.out.println((Object)string3);
        } else {
            String it;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.excludes;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string4 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                Regex regex = new Regex(it);
                collection.add(regex);
            }
            List excludedList = (List)destination$iv$iv;
            try {
                boolean anyFailed = false;
                Sequence $this$forEach$iv = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)pactDirectory)), (Function1)execute.1.INSTANCE);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    boolean bl5;
                    File pactFile = (File)element$iv;
                    boolean bl6 = false;
                    if (this.pactFileIsExcluded(excludedList, pactFile)) {
                        it = "Not publishing '" + pactFile.getName() + "' as it matches an item in the excluded list";
                        bl5 = false;
                        System.out.println((Object)it);
                        continue;
                    }
                    it = "Publishing '" + pactFile.getName() + "' ... ";
                    bl5 = false;
                    System.out.print((Object)it);
                    PactBrokerClient pactBrokerClient = this.brokerClient;
                    if (pactBrokerClient == null) {
                        Intrinsics.throwNpe();
                    }
                    String string5 = this.projectVersion;
                    if (string5 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"projectVersion");
                    }
                    String result = String.valueOf(pactBrokerClient.uploadPactFile(pactFile, string5, this.tags));
                    bl5 = false;
                    System.out.println((Object)result);
                    if (anyFailed || !StringsKt.startsWith$default((String)result, (String)"FAILED!", (boolean)false, (int)2, null)) continue;
                    anyFailed = true;
                }
                if (anyFailed) {
                    throw (Throwable)new MojoExecutionException("One or more of the pact files were rejected by the pact broker");
                }
            }
            finally {
                AnsiConsole.systemUninstall();
            }
        }
    }

    private final boolean pactFileIsExcluded(List<Regex> exclusions, File pactFile) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = exclusions;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Regex it = (Regex)element$iv;
                    boolean bl2 = false;
                    if (!it.matches((CharSequence)FilesKt.getNameWithoutExtension((File)pactFile))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public PactPublishMojo() {
        List list;
        PactPublishMojo pactPublishMojo = this;
        boolean bl = false;
        pactPublishMojo.tags = list = (List)new ArrayList();
        pactPublishMojo = this;
        bl = false;
        pactPublishMojo.excludes = list = (List)new ArrayList();
    }
}

