/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider;

import au.com.dius.pact.provider.HttpClientFactory;
import au.com.dius.pact.provider.IHttpClientFactory;
import au.com.dius.pact.provider.IProviderInfo;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyShell;
import javax.net.ssl.SSLContext;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lau/com/dius/pact/provider/HttpClientFactory;", "Lau/com/dius/pact/provider/IHttpClientFactory;", "()V", "createInsecure", "Lorg/apache/http/impl/client/CloseableHttpClient;", "createWithTrustStore", "provider", "Lau/com/dius/pact/provider/IProviderInfo;", "newClient", "pact-jvm-provider"})
public final class HttpClientFactory
implements IHttpClientFactory {
    @Override
    @NotNull
    public CloseableHttpClient newClient(@NotNull IProviderInfo provider) {
        CloseableHttpClient closeableHttpClient;
        Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
        if (provider.getCreateClient() != null) {
            if (provider.getCreateClient() instanceof Closure) {
                Object object = provider.getCreateClient();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type groovy.lang.Closure<*>");
                }
                Object object2 = ((Closure)object).call((Object)provider);
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.apache.http.impl.client.CloseableHttpClient");
                }
                closeableHttpClient = (CloseableHttpClient)object2;
            } else {
                Binding binding = new Binding();
                binding.setVariable("provider", (Object)provider);
                GroovyShell shell = new GroovyShell(binding);
                Object object = shell.evaluate(String.valueOf(provider.getCreateClient()));
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.apache.http.impl.client.CloseableHttpClient");
                }
                closeableHttpClient = (CloseableHttpClient)object;
            }
        } else {
            CloseableHttpClient closeableHttpClient2 = provider.getInsecure() ? this.createInsecure() : (provider.getTrustStore() != null && provider.getTrustStorePassword() != null ? this.createWithTrustStore(provider) : HttpClients.createDefault());
            closeableHttpClient = closeableHttpClient2;
            Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpClient2, (String)"if (provider.insecure) {\u2026createDefault()\n        }");
        }
        return closeableHttpClient;
    }

    private final CloseableHttpClient createWithTrustStore(IProviderInfo provider) {
        String string = provider.getTrustStorePassword();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        string = string2;
        bl = false;
        String string3 = string;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = string3.toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        char[] password = cArray;
        CloseableHttpClient closeableHttpClient = HttpClients.custom().setSslcontext(new SSLContextBuilder().loadTrustMaterial(provider.getTrustStore(), password).build()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpClient, (String)"HttpClients\n            \u2026d())\n            .build()");
        return closeableHttpClient;
    }

    private final CloseableHttpClient createInsecure() {
        HttpClientBuilder b = HttpClientBuilder.create();
        TrustStrategy trustStratergy2 = createInsecure.trustStratergy.1.INSTANCE;
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, trustStratergy2).build();
        b.setSslcontext(sslContext);
        AllowAllHostnameVerifier hostnameVerifier = new AllowAllHostnameVerifier();
        SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (X509HostnameVerifier)hostnameVerifier);
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslSocketFactory).build();
        PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        b.setConnectionManager((HttpClientConnectionManager)connMgr);
        CloseableHttpClient closeableHttpClient = b.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpClient, (String)"b.build()");
        return closeableHttpClient;
    }
}

