/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junit.loader;

import au.com.dius.pact.core.model.Consumer;
import au.com.dius.pact.core.model.DefaultPactReader;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.core.model.PactBrokerSource;
import au.com.dius.pact.core.model.PactSource;
import au.com.dius.pact.core.pactbroker.PactBrokerClient;
import au.com.dius.pact.core.support.expressions.ExpressionParser;
import au.com.dius.pact.core.support.expressions.SystemPropertyResolver;
import au.com.dius.pact.core.support.expressions.ValueResolver;
import au.com.dius.pact.provider.ConsumerInfo;
import au.com.dius.pact.provider.junit.loader.NoPactsFoundException;
import au.com.dius.pact.provider.junit.loader.PactBroker;
import au.com.dius.pact.provider.junit.loader.PactBrokerAuth;
import au.com.dius.pact.provider.junit.loader.PactLoader;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PactBrokerLoader
implements PactLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(PactBrokerLoader.class);
    private static final String LATEST = "latest";
    private final String pactBrokerHost;
    private final String pactBrokerPort;
    private final String pactBrokerScheme;
    private final List<String> pactBrokerTags;
    private final List<String> pactBrokerConsumers;
    private boolean failIfNoPactsFound = true;
    private PactBrokerAuth authentication;
    private PactBrokerSource pactSource;
    private Class<? extends ValueResolver> valueResolverClass;
    private ValueResolver valueResolver;

    public PactBrokerLoader(String pactBrokerHost, String pactBrokerPort, String pactBrokerScheme) {
        this(pactBrokerHost, pactBrokerPort, pactBrokerScheme, Collections.singletonList(LATEST), new ArrayList<String>());
    }

    public PactBrokerLoader(String pactBrokerHost, String pactBrokerPort, String pactBrokerScheme, List<String> tags, List<String> consumers) {
        this.pactBrokerHost = pactBrokerHost;
        this.pactBrokerPort = pactBrokerPort;
        this.pactBrokerScheme = pactBrokerScheme;
        this.pactBrokerTags = tags;
        this.pactBrokerConsumers = consumers;
        this.pactSource = new PactBrokerSource(this.pactBrokerHost, this.pactBrokerPort, this.pactBrokerScheme);
    }

    public PactBrokerLoader(PactBroker pactBroker) {
        this(pactBroker.host(), pactBroker.port(), pactBroker.scheme(), Arrays.asList(pactBroker.tags()), Arrays.asList(pactBroker.consumers()));
        this.authentication = pactBroker.authentication();
        this.valueResolverClass = pactBroker.valueResolver();
    }

    @Override
    public List<Pact> load(String providerName) throws IOException {
        ArrayList<Pact> pacts = new ArrayList<Pact>();
        ValueResolver resolver = this.setupValueResolver();
        if (this.pactBrokerTags == null || this.pactBrokerTags.isEmpty()) {
            pacts.addAll(this.loadPactsForProvider(providerName, null, resolver));
        } else {
            for (String tag2 : this.pactBrokerTags.stream().flatMap(tag -> ExpressionParser.parseListExpression((String)tag, (ValueResolver)resolver).stream()).collect(Collectors.toList())) {
                try {
                    pacts.addAll(this.loadPactsForProvider(providerName, tag2, resolver));
                }
                catch (NoPactsFoundException noPactsFoundException) {}
            }
        }
        return pacts;
    }

    private ValueResolver setupValueResolver() {
        SystemPropertyResolver resolver = new SystemPropertyResolver();
        if (this.valueResolver != null) {
            resolver = this.valueResolver;
        } else if (this.valueResolverClass != null) {
            try {
                resolver = this.valueResolverClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOGGER.warn("Failed to instantiate the value resolver, using the default", (Throwable)e);
            }
        }
        return resolver;
    }

    @Override
    public PactSource getPactSource() {
        return this.pactSource;
    }

    @Override
    public void setValueResolver(ValueResolver valueResolver) {
        this.valueResolver = valueResolver;
    }

    private List<Pact> loadPactsForProvider(String providerName, String tag, ValueResolver resolver) throws IOException {
        LOGGER.debug("Loading pacts from pact broker for provider " + providerName + " and tag " + tag);
        String scheme = ExpressionParser.parseExpression((String)this.pactBrokerScheme, (ValueResolver)resolver);
        String host = ExpressionParser.parseExpression((String)this.pactBrokerHost, (ValueResolver)resolver);
        String port = ExpressionParser.parseExpression((String)this.pactBrokerPort, (ValueResolver)resolver);
        if (StringUtils.isEmpty((CharSequence)host)) {
            throw new IllegalArgumentException(String.format("Invalid pact broker host specified ('%s'). Please provide a valid host or specify the system property 'pactbroker.host'.", this.pactBrokerHost));
        }
        if (StringUtils.isNotEmpty((CharSequence)port) && !port.matches("^[0-9]+")) {
            throw new IllegalArgumentException(String.format("Invalid pact broker port specified ('%s'). Please provide a valid port number or specify the system property 'pactbroker.port'.", this.pactBrokerPort));
        }
        URIBuilder uriBuilder = new URIBuilder().setScheme(scheme).setHost(host);
        if (StringUtils.isNotEmpty((CharSequence)port)) {
            uriBuilder.setPort(Integer.parseInt(port));
        }
        try {
            PactBrokerClient pactBrokerClient = this.newPactBrokerClient(uriBuilder.build(), resolver);
            List consumers = StringUtils.isEmpty((CharSequence)tag) || tag.equals(LATEST) ? pactBrokerClient.fetchConsumers(providerName).stream().map(ConsumerInfo::from).collect(Collectors.toList()) : pactBrokerClient.fetchConsumersWithTag(providerName, tag).stream().map(ConsumerInfo::from).collect(Collectors.toList());
            if (this.failIfNoPactsFound && consumers.isEmpty()) {
                throw new NoPactsFoundException("No consumer pacts were found for provider '" + providerName + "' and tag '" + tag + "'. (URL " + this.getUrlForProvider(providerName, tag, pactBrokerClient) + ")");
            }
            if (!this.pactBrokerConsumers.isEmpty()) {
                List consumerInclusions = this.pactBrokerConsumers.stream().flatMap(consumer -> ExpressionParser.parseListExpression((String)consumer, (ValueResolver)resolver).stream()).collect(Collectors.toList());
                consumers = consumers.stream().filter(c -> consumerInclusions.isEmpty() || consumerInclusions.contains(c.getName())).collect(Collectors.toList());
            }
            return consumers.stream().map(consumer -> this.loadPact((ConsumerInfo)consumer, pactBrokerClient.getOptions())).collect(Collectors.toList());
        }
        catch (URISyntaxException e) {
            throw new IOException("Was not able load pacts from broker as the broker URL was invalid", e);
        }
    }

    private String getUrlForProvider(String providerName, String tag, PactBrokerClient pactBrokerClient) {
        try {
            return pactBrokerClient.getUrlForProvider(providerName, tag);
        }
        catch (Exception e) {
            LOGGER.debug("Failed to get provider URL from the pact broker", (Throwable)e);
            return "Unknown";
        }
    }

    Pact loadPact(ConsumerInfo consumer, Map options) {
        Pact pact2 = DefaultPactReader.INSTANCE.loadPact(consumer.getPactSource(), options);
        Map pacts = this.pactSource.getPacts();
        Consumer pactConsumer = consumer.toPactConsumer();
        List pactList = pacts.getOrDefault(pactConsumer, new ArrayList());
        pactList.add(pact2);
        pacts.put(pactConsumer, pactList);
        return pact2;
    }

    PactBrokerClient newPactBrokerClient(URI url, ValueResolver resolver) {
        HashMap<String, List<String>> options = new HashMap<String, List<String>>();
        if (this.authentication != null && !this.authentication.scheme().equalsIgnoreCase("none")) {
            options.put("authentication", Arrays.asList(ExpressionParser.parseExpression((String)this.authentication.scheme(), (ValueResolver)resolver), ExpressionParser.parseExpression((String)this.authentication.username(), (ValueResolver)resolver), ExpressionParser.parseExpression((String)this.authentication.password(), (ValueResolver)resolver)));
        }
        return new PactBrokerClient(url.toString(), options);
    }

    public boolean isFailIfNoPactsFound() {
        return this.failIfNoPactsFound;
    }

    public void setFailIfNoPactsFound(boolean failIfNoPactsFound) {
        this.failIfNoPactsFound = failIfNoPactsFound;
    }
}

