/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider;

import au.com.dius.pact.com.github.michaelbull.result.Err;
import au.com.dius.pact.com.github.michaelbull.result.Result;
import au.com.dius.pact.model.BrokerUrlSource;
import au.com.dius.pact.model.Interaction;
import au.com.dius.pact.model.Pact;
import au.com.dius.pact.model.PactSource;
import au.com.dius.pact.pactbroker.PactBrokerClientBase;
import au.com.dius.pact.pactbroker.TestResult;
import au.com.dius.pact.provider.DefaultVerificationReporter;
import au.com.dius.pact.provider.VerificationReporter;
import au.com.dius.pact.provider.broker.PactBrokerClient;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003JB\u0010\u0004\u001a\u00020\u0005\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00060\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J2\u0010\u0014\u001a\u00020\u00052\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\tH\u0016J2\u0010\u0014\u001a\u00020\u00052\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00112\u0006\u0010\f\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\u0016"}, d2={"Lau/com/dius/pact/provider/DefaultVerificationReporter;", "Lau/com/dius/pact/provider/VerificationReporter;", "Lmu/KLogging;", "()V", "publishResult", "", "I", "Lau/com/dius/pact/model/Interaction;", "brokerClient", "Lau/com/dius/pact/provider/broker/PactBrokerClient;", "source", "Lau/com/dius/pact/model/BrokerUrlSource;", "result", "Lau/com/dius/pact/pactbroker/TestResult;", "version", "", "pact", "Lau/com/dius/pact/model/Pact;", "publishingResultsDisabled", "", "reportResults", "client", "pact-jvm-provider_2.12"})
public final class DefaultVerificationReporter
extends KLogging
implements VerificationReporter {
    public static final DefaultVerificationReporter INSTANCE;

    @Override
    public void reportResults(@NotNull Pact<? extends Interaction> pact, boolean result2, @NotNull String version, @Nullable PactBrokerClient client) {
        Intrinsics.checkParameterIsNotNull(pact, (String)"pact");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        this.reportResults(pact, TestResult.Companion.fromBoolean(result2), version, client);
    }

    @Override
    public void reportResults(@NotNull Pact<? extends Interaction> pact, @NotNull TestResult result2, @NotNull String version, @Nullable PactBrokerClient client) {
        Intrinsics.checkParameterIsNotNull(pact, (String)"pact");
        Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        PactSource source = pact.getSource();
        if (source instanceof BrokerUrlSource) {
            PactBrokerClient pactBrokerClient = client;
            if (pactBrokerClient == null) {
                pactBrokerClient = new PactBrokerClient(((BrokerUrlSource)source).getPactBrokerUrl(), ((BrokerUrlSource)source).getOptions());
            }
            PactBrokerClient brokerClient = pactBrokerClient;
            this.publishResult(brokerClient, (BrokerUrlSource)source, result2, version, pact);
        } else {
            this.getLogger().info((Function0)new Function0<String>(source){
                final /* synthetic */ PactSource $source;

                @NotNull
                public final String invoke() {
                    return "Skipping publishing verification results for source " + this.$source;
                }
                {
                    this.$source = pactSource;
                    super(0);
                }
            });
        }
    }

    private final <I extends Interaction> void publishResult(PactBrokerClient brokerClient, BrokerUrlSource source, TestResult result2, String version, Pact<? extends I> pact) {
        Result publishResult2 = PactBrokerClientBase.publishVerificationResults$default((PactBrokerClientBase)brokerClient, (Map)source.getAttributes(), (TestResult)result2, (String)version, null, (int)8, null);
        if (publishResult2 instanceof Err) {
            this.getLogger().error((Function0)new Function0<String>(publishResult2){
                final /* synthetic */ Result $publishResult;

                @NotNull
                public final String invoke() {
                    return "Failed to publish verification results - " + ((Exception)((Err)this.$publishResult).getError()).getLocalizedMessage();
                }
                {
                    this.$publishResult = result2;
                    super(0);
                }
            });
            this.getLogger().debug((Throwable)((Err)publishResult2).getError(), (Function0)publishResult.2.INSTANCE);
        } else {
            this.getLogger().info((Function0)new Function0<String>(result2, pact){
                final /* synthetic */ TestResult $result;
                final /* synthetic */ Pact $pact;

                @NotNull
                public final String invoke() {
                    return "Published verification result of '" + this.$result + "' for consumer '" + this.$pact.getConsumer() + '\'';
                }
                {
                    this.$result = testResult;
                    this.$pact = pact;
                    super(0);
                }
            });
        }
    }

    @Override
    public boolean publishingResultsDisabled() {
        String string;
        String string2 = System.getProperty("pact.verifier.publishResults");
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase();
            string = string5;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
        } else {
            string = null;
        }
        return Intrinsics.areEqual(string, (Object)"true") ^ true;
    }

    private DefaultVerificationReporter() {
    }

    static {
        DefaultVerificationReporter defaultVerificationReporter;
        INSTANCE = defaultVerificationReporter = new DefaultVerificationReporter();
    }
}

