/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider;

import au.com.dius.pact.model.FileSource;
import au.com.dius.pact.model.Interaction;
import au.com.dius.pact.provider.ConsumerInfo;
import au.com.dius.pact.provider.IConsumerInfo;
import au.com.dius.pact.provider.IProviderInfo;
import au.com.dius.pact.provider.PactVerification;
import au.com.dius.pact.provider.PactVerifierException;
import au.com.dius.pact.provider.ProviderUtils;
import groovy.json.JsonSlurper;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.BooleanUtils;
import org.fusesource.jansi.AnsiConsole;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J7\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u00052\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\b\"\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0007J\u0010\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001J^\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u0017\u001a\u00020\r2\b\b\u0002\u0010\u0018\u001a\u00020\u00192\u000e\b\u0002\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010H\u0007J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0011H\u0007J\u0014\u0010\u001e\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020 0\u001fJ\u0010\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u0006H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0011H\u0007\u00a8\u0006#"}, d2={"Lau/com/dius/pact/provider/ProviderUtils;", "", "()V", "extractFromMap", "json", "", "", "s", "", "(Ljava/util/Map;[Ljava/lang/String;)Ljava/lang/Object;", "getProviderVersion", "projectVersion", "isS3Url", "", "pactFile", "loadPactFiles", "", "Lau/com/dius/pact/provider/IConsumerInfo;", "provider", "Lau/com/dius/pact/provider/IProviderInfo;", "pactFileDir", "Ljava/io/File;", "stateChange", "stateChangeUsesBody", "verificationType", "Lau/com/dius/pact/provider/PactVerification;", "packagesToScan", "pactFileAuthentication", "providerInfo", "consumer", "pactFileExists", "Lau/com/dius/pact/model/FileSource;", "Lau/com/dius/pact/model/Interaction;", "trimSnapshot", "providerVersion", "pact-jvm-provider_2.12"})
public final class ProviderUtils {
    public static final ProviderUtils INSTANCE;

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<IConsumerInfo> loadPactFiles(@NotNull IProviderInfo provider, @NotNull File pactFileDir, @Nullable Object stateChange2, boolean stateChangeUsesBody, @NotNull PactVerification verificationType, @NotNull List<String> packagesToScan, @NotNull List<String> pactFileAuthentication) {
        Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
        Intrinsics.checkParameterIsNotNull((Object)pactFileDir, (String)"pactFileDir");
        Intrinsics.checkParameterIsNotNull((Object)((Object)verificationType), (String)"verificationType");
        Intrinsics.checkParameterIsNotNull(packagesToScan, (String)"packagesToScan");
        Intrinsics.checkParameterIsNotNull(pactFileAuthentication, (String)"pactFileAuthentication");
        if (!pactFileDir.exists()) {
            throw (Throwable)new PactVerifierException("Pact file directory (" + pactFileDir + ") does not exist", null, 2, null);
        }
        if (!pactFileDir.isDirectory()) {
            throw (Throwable)new PactVerifierException("Pact file directory (" + pactFileDir + ") is not a directory", null, 2, null);
        }
        if (!pactFileDir.canRead()) {
            throw (Throwable)new PactVerifierException("Pact file directory (" + pactFileDir + ") is not readable", null, 2, null);
        }
        AnsiConsole.out().println("Loading pact files for provider " + provider.getName() + " from " + pactFileDir);
        boolean bl = false;
        List consumers = new ArrayList();
        for (File f : pactFileDir.listFiles(loadPactFiles.1.INSTANCE)) {
            Object object = new JsonSlurper().parse(f);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
            }
            Map pactJson = (Map)object;
            Object providerName = INSTANCE.extractFromMap(pactJson, "provider", "name");
            if (Intrinsics.areEqual((Object)providerName, (Object)provider.getName())) {
                String string = String.valueOf(INSTANCE.extractFromMap(pactJson, "consumer", "name"));
                File file = f;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"f");
                consumers.add(new ConsumerInfo(string, stateChange2, stateChangeUsesBody, packagesToScan, verificationType, new FileSource(file, null, 2, null), pactFileAuthentication));
                continue;
            }
            AnsiConsole.out().println("Skipping " + f + " as the provider names don't match provider.name: " + provider.getName() + " vs pactJson.provider.name: " + providerName);
        }
        AnsiConsole.out().println("Found " + consumers.size() + " pact files");
        return consumers;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static /* synthetic */ List loadPactFiles$default(IProviderInfo iProviderInfo, File file, Object object, boolean bl, PactVerification pactVerification, List list, List list2, int n, Object object2) {
        if ((n & 4) != 0) {
            object = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            pactVerification = PactVerification.REQUEST_RESPONSE;
        }
        if ((n & 0x20) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x40) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return ProviderUtils.loadPactFiles(iProviderInfo, file, object, bl, pactVerification, list, list2);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<IConsumerInfo> loadPactFiles(@NotNull IProviderInfo provider, @NotNull File pactFileDir, @Nullable Object stateChange2, boolean stateChangeUsesBody, @NotNull PactVerification verificationType, @NotNull List<String> packagesToScan) {
        return ProviderUtils.loadPactFiles$default(provider, pactFileDir, stateChange2, stateChangeUsesBody, verificationType, packagesToScan, null, 64, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<IConsumerInfo> loadPactFiles(@NotNull IProviderInfo provider, @NotNull File pactFileDir, @Nullable Object stateChange2, boolean stateChangeUsesBody, @NotNull PactVerification verificationType) {
        return ProviderUtils.loadPactFiles$default(provider, pactFileDir, stateChange2, stateChangeUsesBody, verificationType, null, null, 96, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<IConsumerInfo> loadPactFiles(@NotNull IProviderInfo provider, @NotNull File pactFileDir, @Nullable Object stateChange2, boolean stateChangeUsesBody) {
        return ProviderUtils.loadPactFiles$default(provider, pactFileDir, stateChange2, stateChangeUsesBody, null, null, null, 112, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<IConsumerInfo> loadPactFiles(@NotNull IProviderInfo provider, @NotNull File pactFileDir, @Nullable Object stateChange2) {
        return ProviderUtils.loadPactFiles$default(provider, pactFileDir, stateChange2, false, null, null, null, 120, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<IConsumerInfo> loadPactFiles(@NotNull IProviderInfo provider, @NotNull File pactFileDir) {
        return ProviderUtils.loadPactFiles$default(provider, pactFileDir, null, false, null, null, null, 124, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Object extractFromMap(Map<String, ? extends Object> json, String ... s) {
        Object object;
        if (s.length == 1) {
            object = json.get(ArraysKt.first((Object[])s));
        } else if (json.containsKey(ArraysKt.first((Object[])s))) {
            Object map2 = json.get(ArraysKt.first((Object[])s));
            if (map2 instanceof Map) {
                void $this$toTypedArray$iv;
                Collection collection = ArraysKt.drop((Object[])s, (int)1);
                Map map3 = (Map)map2;
                ProviderUtils providerUtils = this;
                boolean $i$f$toTypedArray = false;
                void v1 = $this$toTypedArray$iv;
                if (v1 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                void thisCollection$iv = v1;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String[] stringArray2 = stringArray;
                object = providerUtils.extractFromMap(map3, Arrays.copyOf(stringArray2, stringArray2.length));
            } else {
                object = null;
            }
        } else {
            object = null;
        }
        return object;
    }

    public final boolean pactFileExists(@NotNull FileSource<Interaction> pactFile) {
        Intrinsics.checkParameterIsNotNull(pactFile, (String)"pactFile");
        return pactFile.getFile().exists();
    }

    @JvmStatic
    @NotNull
    public static final PactVerification verificationType(@NotNull IProviderInfo provider, @NotNull IConsumerInfo consumer) {
        PactVerification pactVerification;
        Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
        Intrinsics.checkParameterIsNotNull((Object)consumer, (String)"consumer");
        PactVerification pactVerification2 = consumer.getVerificationType();
        if (pactVerification2 == null) {
            pactVerification2 = pactVerification = provider.getVerificationType();
        }
        if (pactVerification2 == null) {
            pactVerification = PactVerification.REQUEST_RESPONSE;
        }
        return pactVerification;
    }

    @JvmStatic
    @NotNull
    public static final List<String> packagesToScan(@NotNull IProviderInfo providerInfo, @NotNull IConsumerInfo consumer) {
        Intrinsics.checkParameterIsNotNull((Object)providerInfo, (String)"providerInfo");
        Intrinsics.checkParameterIsNotNull((Object)consumer, (String)"consumer");
        Collection collection = consumer.getPackagesToScan();
        boolean bl = false;
        return !collection.isEmpty() ? consumer.getPackagesToScan() : providerInfo.getPackagesToScan();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isS3Url(@Nullable Object pactFile) {
        if (!(pactFile instanceof String)) return false;
        String string = (String)pactFile;
        boolean bl = false;
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        if (!StringsKt.startsWith$default((String)string2, (String)"s3://", (boolean)false, (int)2, null)) return false;
        return true;
    }

    @JvmStatic
    @NotNull
    public static final String getProviderVersion(@NotNull String projectVersion) {
        Intrinsics.checkParameterIsNotNull((Object)projectVersion, (String)"projectVersion");
        String trimSnapshotProperty = System.getProperty("pact.provider.version.trimSnapshot");
        boolean isTrimSnapshot = trimSnapshotProperty == null || StringsKt.isBlank((CharSequence)trimSnapshotProperty) ? false : BooleanUtils.toBoolean((String)trimSnapshotProperty);
        return isTrimSnapshot ? INSTANCE.trimSnapshot(projectVersion) : projectVersion;
    }

    private final String trimSnapshot(String providerVersion) {
        String SNAPSHOT_STRING = "-SNAPSHOT";
        if (StringsKt.contains$default((CharSequence)providerVersion, (CharSequence)SNAPSHOT_STRING, (boolean)false, (int)2, null)) {
            return StringsKt.replaceFirst$default((String)providerVersion, (String)SNAPSHOT_STRING, (String)"", (boolean)false, (int)4, null);
        }
        return providerVersion;
    }

    private ProviderUtils() {
    }

    static {
        ProviderUtils providerUtils;
        INSTANCE = providerUtils = new ProviderUtils();
    }
}

