/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.spring.spring6;

import au.com.dius.pact.core.model.IRequest;
import au.com.dius.pact.core.model.Interaction;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.core.model.PactSource;
import au.com.dius.pact.core.model.SynchronousRequestResponse;
import au.com.dius.pact.core.model.generators.GeneratorTestMode;
import au.com.dius.pact.provider.IProviderVerifier;
import au.com.dius.pact.provider.ProviderInfo;
import au.com.dius.pact.provider.ProviderResponse;
import au.com.dius.pact.provider.spring.spring6.WebFluxBasedTestTarget;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.web.reactive.function.server.RouterFunction;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J:\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0012H\u0016R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lau/com/dius/pact/provider/spring/spring6/WebFluxSpring6Target;", "Lau/com/dius/pact/provider/spring/spring6/WebFluxBasedTestTarget;", "routerFunction", "Lorg/springframework/web/reactive/function/server/RouterFunction;", "(Lorg/springframework/web/reactive/function/server/RouterFunction;)V", "userConfig", "", "", "", "getUserConfig", "()Ljava/util/Map;", "prepareRequest", "Lkotlin/Pair;", "pact", "Lau/com/dius/pact/core/model/Pact;", "interaction", "Lau/com/dius/pact/core/model/Interaction;", "context", "", "spring6"})
public final class WebFluxSpring6Target
implements WebFluxBasedTestTarget {
    @NotNull
    private final RouterFunction<?> routerFunction;
    @NotNull
    private final Map<String, Object> userConfig;

    public WebFluxSpring6Target(@NotNull RouterFunction<?> routerFunction) {
        Intrinsics.checkNotNullParameter(routerFunction, (String)"routerFunction");
        this.routerFunction = routerFunction;
        this.userConfig = MapsKt.emptyMap();
    }

    @NotNull
    public Map<String, Object> getUserConfig() {
        return this.userConfig;
    }

    @Nullable
    public Pair<Object, Object> prepareRequest(@NotNull Pact pact, @NotNull Interaction interaction, @NotNull Map<String, Object> context) {
        Intrinsics.checkNotNullParameter((Object)pact, (String)"pact");
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        if (interaction instanceof SynchronousRequestResponse) {
            IRequest request = ((SynchronousRequestResponse)interaction).getRequest().generatedRequest(context, GeneratorTestMode.Provider);
            WebTestClient webClient = WebTestClient.bindToRouterFunction(this.routerFunction).build();
            Intrinsics.checkNotNullExpressionValue((Object)webClient, (String)"webClient");
            return TuplesKt.to(this.toWebFluxRequestBuilder(webClient, request), (Object)webClient);
        }
        throw new UnsupportedOperationException("Only request/response interactions can be used with a WebFlux test target");
    }

    @Override
    @NotNull
    public ProviderInfo getProviderInfo(@NotNull String serviceName, @Nullable PactSource pactSource) {
        return WebFluxBasedTestTarget.DefaultImpls.getProviderInfo(this, serviceName, pactSource);
    }

    @Override
    public boolean isHttpTarget() {
        return WebFluxBasedTestTarget.DefaultImpls.isHttpTarget(this);
    }

    @Override
    @NotNull
    public ProviderResponse executeInteraction(@Nullable Object client, @Nullable Object request) {
        return WebFluxBasedTestTarget.DefaultImpls.executeInteraction(this, client, request);
    }

    @Override
    public void prepareVerifier(@NotNull IProviderVerifier verifier, @NotNull Object testInstance, @NotNull Pact pact) {
        WebFluxBasedTestTarget.DefaultImpls.prepareVerifier(this, verifier, testInstance, pact);
    }

    @Override
    @NotNull
    public WebTestClient.RequestHeadersSpec<?> toWebFluxRequestBuilder(@NotNull WebTestClient webClient, @NotNull IRequest request) {
        return WebFluxBasedTestTarget.DefaultImpls.toWebFluxRequestBuilder(this, webClient, request);
    }

    @Override
    @NotNull
    public String requestUriString(@NotNull IRequest request) {
        return WebFluxBasedTestTarget.DefaultImpls.requestUriString(this, request);
    }
}

