package aQute.bnd.service.reporter;

import java.util.List;
import java.util.Map;

import org.osgi.annotation.versioning.ProviderType;

import aQute.bnd.osgi.Resource;

/**
 * This plugin can export a report generated by the
 * {@link ReportGeneratorService} service. The exported report can be serialized
 * into a specific format and optionally be transformed by a template engine.
 * <p>
 * The service can be extended by implementing the
 * {@link aQute.bnd.service.reporter.ReportSerializerPlugin} and the
 * {@link aQute.bnd.service.reporter.ReportTransformerPlugin} interfaces
 * respectively to support additional serialization format and additional
 * template engine.
 */
@ProviderType
public interface ReportExporterService {

	/**
	 * @param source the targeted source object to report, may be {@code null}
	 * @return the list of report destination file paths which can be extracted,
	 *         never {@code null}
	 */
	public List<String> getAvailableReportsOf(Object source);

	/**
	 * Export the reports of the specified source object.
	 * 
	 * @param source the source object to report, may be {@code null}
	 * @return a map whose key are the user defined destination file path and
	 *         value are the resulting report resource, never {@code null}
	 */
	public Map<String, Resource> exportReportsOf(Object source);
}
