/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.maven.indexer.plugin;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.zip.GZIPOutputStream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.indexer.ResourceAnalyzer;
import org.osgi.service.indexer.impl.KnownBundleAnalyzer;
import org.osgi.service.indexer.impl.RepoIndex;
import org.osgi.service.indexer.impl.URLResolver;

@Mojo(name="local-index", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class LocalIndexerMojo
extends AbstractMojo {
    @Parameter(property="bnd.indexer.input.dir", required=true)
    private File inputDir;
    @Parameter(property="bnd.indexer.output.file", defaultValue="${project.build.directory}/index.xml")
    private File outputFile;
    @Parameter(property="bnd.indexer.base.file", required=false)
    private File baseFile;
    @Parameter(property="bnd.indexer.include.gzip", defaultValue="true", readonly=true)
    private boolean includeGzip;
    @Parameter(defaultValue="false", readonly=true)
    private boolean skip;
    private boolean fail;

    public void execute() throws MojoExecutionException, MojoFailureException {
        FileOutputStream output;
        Filter filter;
        if (this.skip) {
            this.getLog().debug((CharSequence)"skip project as configured");
            return;
        }
        if (this.baseFile == null) {
            this.baseFile = this.outputFile.getParentFile();
        }
        this.getLog().debug((CharSequence)("Indexing dependencies in folder: " + this.inputDir.getAbsolutePath()));
        this.getLog().debug((CharSequence)("Outputting index to: " + this.outputFile.getAbsolutePath()));
        this.getLog().debug((CharSequence)("Producing additional gzip index: " + this.includeGzip));
        this.getLog().debug((CharSequence)("URI paths will be relative to: " + this.baseFile));
        HashSet<File> toIndex = new HashSet<File>();
        toIndex.addAll(Arrays.asList(this.inputDir.listFiles()));
        RepoIndex indexer = new RepoIndex();
        try {
            filter = FrameworkUtil.createFilter((String)"(name=*.jar)");
        }
        catch (InvalidSyntaxException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        indexer.addAnalyzer((ResourceAnalyzer)new KnownBundleAnalyzer(), filter);
        indexer.addURLResolver((URLResolver)new BaseFileURLResolver());
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("pretty", "true");
        try {
            this.outputFile.getParentFile().mkdirs();
            output = new FileOutputStream(this.outputFile);
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        try {
            indexer.index(toIndex, (OutputStream)output, config);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        if (this.fail) {
            throw new MojoExecutionException("One or more URI lookups failed");
        }
        if (this.includeGzip) {
            File gzipOutputFile = new File(this.outputFile.getPath() + ".gz");
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.outputFile));
                 GZIPOutputStream gos = new GZIPOutputStream(new FileOutputStream(gzipOutputFile));){
                int read;
                byte[] bytes = new byte[4096];
                while ((read = ((InputStream)is).read(bytes)) != -1) {
                    ((OutputStream)gos).write(bytes, 0, read);
                }
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Unable to create the gzipped output file");
            }
        }
    }

    class BaseFileURLResolver
    implements URLResolver {
        BaseFileURLResolver() {
        }

        public URI resolver(File file) throws Exception {
            try {
                LocalIndexerMojo.this.getLog().debug((CharSequence)("Resolving " + file.getAbsolutePath() + " relative to " + LocalIndexerMojo.this.baseFile.getAbsolutePath()));
                Path relativePath = LocalIndexerMojo.this.baseFile.getAbsoluteFile().toPath().relativize(file.getAbsoluteFile().toPath());
                LocalIndexerMojo.this.getLog().debug((CharSequence)("Relative Path is: " + relativePath));
                URI relativeURI = URI.create(relativePath.toString().replace(File.separatorChar, '/'));
                LocalIndexerMojo.this.getLog().debug((CharSequence)("Relative URI is: " + relativeURI));
                return relativeURI;
            }
            catch (Exception e) {
                LocalIndexerMojo.this.getLog().error((Throwable)e);
                LocalIndexerMojo.this.fail = true;
                throw e;
            }
        }
    }
}

