/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.boleto;

import br.com.caelum.stella.boleto.Banco;
import br.com.caelum.stella.boleto.Datas;
import br.com.caelum.stella.boleto.Emissor;
import br.com.caelum.stella.boleto.Sacado;
import br.com.caelum.stella.boleto.exception.CriacaoBoletoException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;

public class Boleto {
    private BigDecimal valorBoleto;
    private BigDecimal quantidadeMoeda;
    private BigDecimal valorMoeda;
    private String especieMoeda;
    private int codigoEspecieMoeda;
    private String especieDocumento;
    private String numeroDocumento;
    private boolean aceite;
    private Banco banco;
    private Datas datas;
    private Sacado sacado;
    private Emissor emissor;
    private List<String> instrucoes = Collections.emptyList();
    private List<String> descricoes = Collections.emptyList();
    private List<String> locaisDePagamento = Collections.emptyList();

    private Boleto() {
    }

    public static Boleto novoBoleto() {
        return new Boleto().comEspecieMoeda("R$").comCodigoEspecieMoeda(9).comAceite(false).comEspecieDocumento("DV");
    }

    public boolean getAceite() {
        return this.aceite;
    }

    public Boleto comAceite(boolean aceite) {
        this.aceite = aceite;
        return this;
    }

    public Datas getDatas() {
        return this.datas;
    }

    public Boleto comDatas(Datas datas) {
        this.datas = datas;
        return this;
    }

    public String getEspecieDocumento() {
        return this.especieDocumento;
    }

    public Boleto comEspecieDocumento(String especieDocumento) {
        this.especieDocumento = especieDocumento;
        return this;
    }

    public String getNumeroDoDocumento() {
        return this.numeroDocumento;
    }

    public Boleto comNumeroDoDocumento(String numeroDocumento) {
        this.numeroDocumento = numeroDocumento;
        return this;
    }

    public BigDecimal getQuantidadeDeMoeda() {
        return this.quantidadeMoeda;
    }

    public Boleto comQuantidadeMoeda(BigDecimal quantidadeMoeda) {
        this.quantidadeMoeda = quantidadeMoeda;
        return this;
    }

    public BigDecimal getValorBoleto() {
        return this.valorBoleto;
    }

    public Boleto comValorBoleto(double valor) {
        return this.comValorBoleto(Double.toString(valor));
    }

    public Boleto comValorBoleto(String valor) {
        return this.comValorBoleto(new BigDecimal(valor));
    }

    public Boleto comValorBoleto(BigDecimal valor) {
        this.valorBoleto = valor;
        return this;
    }

    public String getEspecieMoeda() {
        return this.especieMoeda;
    }

    private Boleto comEspecieMoeda(String especieMoeda) {
        this.especieMoeda = especieMoeda;
        return this;
    }

    public int getCodigoEspecieMoeda() {
        return this.codigoEspecieMoeda;
    }

    private Boleto comCodigoEspecieMoeda(int codigoEspecieMoeda) {
        this.codigoEspecieMoeda = codigoEspecieMoeda;
        return this;
    }

    public BigDecimal getValorMoeda() {
        return this.valorMoeda;
    }

    public Boleto comValorMoeda(BigDecimal valorMoeda) {
        this.valorMoeda = valorMoeda;
        return this;
    }

    public Banco getBanco() {
        return this.banco;
    }

    public Boleto comBanco(Banco banco) {
        this.banco = banco;
        return this;
    }

    public Sacado getSacado() {
        return this.sacado;
    }

    public Boleto comSacado(Sacado sacado) {
        this.sacado = sacado;
        return this;
    }

    public Emissor getEmissor() {
        return this.emissor;
    }

    public Boleto comEmissor(Emissor emissor) {
        this.emissor = emissor;
        return this;
    }

    public List<String> getInstrucoes() {
        return this.instrucoes;
    }

    public Boleto comInstrucoes(String ... instrucoes) {
        if (instrucoes.length > 5) {
            throw new IllegalArgumentException("maximo de 5 instrucoes permitidas");
        }
        this.instrucoes = Arrays.asList(instrucoes);
        return this;
    }

    public List<String> getDescricoes() {
        return this.descricoes;
    }

    public Boleto comDescricoes(String ... descricoes) {
        if (descricoes.length > 5) {
            throw new IllegalArgumentException("maximo de 5 descricoes permitidas");
        }
        this.descricoes = Arrays.asList(descricoes);
        return this;
    }

    public List<String> getLocaisDePagamento() {
        return this.locaisDePagamento;
    }

    public Boleto comLocaisDePagamento(String ... locaisDePagamento) {
        if (locaisDePagamento.length > 2) {
            throw new IllegalArgumentException("maximo de 2 locais de pagamento permitidos");
        }
        this.locaisDePagamento = Arrays.asList(locaisDePagamento);
        return this;
    }

    public String getFatorVencimento() {
        Calendar dataBase = Calendar.getInstance();
        dataBase.set(5, 7);
        dataBase.set(2, 9);
        dataBase.set(1, 1997);
        dataBase.set(11, 0);
        dataBase.set(12, 0);
        dataBase.set(13, 0);
        dataBase.set(14, 0);
        Calendar vencimentoSemHoras = Calendar.getInstance();
        vencimentoSemHoras.set(5, this.datas.getVencimento().get(5));
        vencimentoSemHoras.set(2, this.datas.getVencimento().get(2));
        vencimentoSemHoras.set(1, this.datas.getVencimento().get(1));
        vencimentoSemHoras.set(11, 0);
        vencimentoSemHoras.set(12, 0);
        vencimentoSemHoras.set(13, 0);
        vencimentoSemHoras.set(14, 0);
        long diferencasEmMiliSegundos = vencimentoSemHoras.getTimeInMillis() - dataBase.getTimeInMillis();
        long diferencasEmDias = diferencasEmMiliSegundos / 86400000L;
        if (diferencasEmDias > 9999L) {
            throw new CriacaoBoletoException("Data fora do formato aceito!");
        }
        return String.valueOf((int)diferencasEmDias);
    }

    public String getValorFormatado() {
        return String.format("%011.2f", this.valorBoleto).replaceAll("[^0-9]", "");
    }

    public String getNumeroDoDocumentoFormatado() {
        return String.format("%04d", new Integer(this.numeroDocumento));
    }

    public String getAgenciaECodigoCedente() {
        return this.banco.getAgenciaECodigoCedente(this.emissor);
    }

    public String getNossoNumeroECodDocumento() {
        return this.banco.getNossoNumeroECodDocumento(this.emissor);
    }
}

