/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.boleto;

import java.util.Calendar;
import java.util.GregorianCalendar;

public class Datas {
    private Calendar documento;
    private Calendar processamento;
    private Calendar vencimento;
    private static final Calendar MINIMUM_DATE = new GregorianCalendar(1997, 10, 7);
    private static final Calendar MAXIMUM_DATE = new GregorianCalendar(2024, 1, 1);

    private Datas() {
    }

    public static Datas novasDatas() {
        Calendar data = Calendar.getInstance();
        return new Datas().comDocumento(data).comProcessamento(data);
    }

    public Calendar getDocumento() {
        return this.documento;
    }

    public Datas comDocumento(Calendar documento) {
        if (documento.getTime().before(MINIMUM_DATE.getTime())) {
            throw new IllegalArgumentException("O ano do documento deve ser maior do que 1997.");
        }
        if (documento.getTime().after(MAXIMUM_DATE.getTime())) {
            throw new IllegalArgumentException("O ano do documento deve ser menor do que 2024.");
        }
        this.documento = documento;
        return this;
    }

    public Datas comDocumento(int dia, int mes, int ano) {
        return this.comDocumento(this.dataPara(dia, mes, ano));
    }

    public Calendar getProcessamento() {
        return this.processamento;
    }

    public Datas comProcessamento(Calendar processamento) {
        if (processamento.getTime().before(MINIMUM_DATE.getTime())) {
            throw new IllegalArgumentException("O ano do processamento deve ser maior do que 1997.");
        }
        if (processamento.getTime().after(MAXIMUM_DATE.getTime())) {
            throw new IllegalArgumentException("O ano do processamento deve ser menor do que 2024.");
        }
        this.processamento = processamento;
        return this;
    }

    public Datas comProcessamento(int dia, int mes, int ano) {
        return this.comProcessamento(this.dataPara(dia, mes, ano));
    }

    public Calendar getVencimento() {
        return this.vencimento;
    }

    public Datas comVencimento(Calendar vencimento) {
        if (vencimento.getTime().before(MINIMUM_DATE.getTime())) {
            throw new IllegalArgumentException("O ano do vencimento deve ser maior do que 1997.");
        }
        if (vencimento.getTime().after(MAXIMUM_DATE.getTime())) {
            throw new IllegalArgumentException("O ano do vencimento deve ser menor do que 2024.");
        }
        this.vencimento = vencimento;
        return this;
    }

    public Datas comVencimento(int dia, int mes, int ano) {
        return this.comVencimento(this.dataPara(dia, mes, ano));
    }

    private Calendar dataPara(int dia, int mes, int ano) {
        Calendar c = Calendar.getInstance();
        c.set(ano, mes - 1, dia);
        return c;
    }
}

