/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.boleto.bancos;

import br.com.caelum.stella.boleto.Banco;
import br.com.caelum.stella.boleto.bancos.BancoDoBrasil;
import br.com.caelum.stella.boleto.bancos.Bradesco;
import br.com.caelum.stella.boleto.bancos.Caixa;
import br.com.caelum.stella.boleto.bancos.HSBC;
import br.com.caelum.stella.boleto.bancos.Itau;
import br.com.caelum.stella.boleto.bancos.Safra;
import br.com.caelum.stella.boleto.bancos.Santander;
import br.com.caelum.stella.boleto.exception.BancoNaoSuportadoException;

public enum Bancos {
    BANCO_DO_BRASIL("001", "Banco do Brasil"){

        @Override
        public Banco getBanco() {
            return new BancoDoBrasil();
        }
    }
    ,
    BRADESCO("237", "Bradesco"){

        @Override
        public Banco getBanco() {
            return new Bradesco();
        }
    }
    ,
    CAIXA("104", "Caixa"){

        @Override
        public Banco getBanco() {
            return new Caixa();
        }
    }
    ,
    HSBC("399", "HSBC"){

        @Override
        public Banco getBanco() {
            return new HSBC();
        }
    }
    ,
    ITAU("341", "Ita\u00fa"){

        @Override
        public Banco getBanco() {
            return new Itau();
        }
    }
    ,
    SANTANDER("033", "Santander"){

        @Override
        public Banco getBanco() {
            return new Santander();
        }
    }
    ,
    SAFRA("422", "Safra"){

        @Override
        public Banco getBanco() {
            return new Safra();
        }
    };

    private final String numeroDoBanco;
    private final String nomeDoBanco;

    public String getNumeroDoBanco() {
        return this.numeroDoBanco;
    }

    public String getNomeDoBanco() {
        return this.nomeDoBanco;
    }

    private Bancos(String numeroDoBanco, String nomeDoBanco) {
        this.numeroDoBanco = numeroDoBanco;
        this.nomeDoBanco = nomeDoBanco;
    }

    public abstract Banco getBanco();

    public static Banco getPorNumero(String numero) {
        for (Bancos b : Bancos.values()) {
            if (!b.getNumeroDoBanco().equals(numero)) continue;
            return b.getBanco();
        }
        throw new BancoNaoSuportadoException(numero);
    }
}

