/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.boleto.bancos;

import br.com.caelum.stella.boleto.Banco;
import br.com.caelum.stella.boleto.Boleto;
import br.com.caelum.stella.boleto.Emissor;
import br.com.caelum.stella.boleto.bancos.AbstractBanco;
import br.com.caelum.stella.boleto.bancos.CodigoDeBarrasBuilder;
import java.net.URL;

public class Caixa
extends AbstractBanco
implements Banco {
    private static final String NUMERO_CAIXA = "104";
    private static final String DIGITO_CAIXA = "0";

    @Override
    public String geraCodigoDeBarrasPara(Boleto boleto) {
        Emissor emissor = boleto.getEmissor();
        int carteiraDoEmissor = emissor.getCarteira();
        StringBuilder campoLivre = new StringBuilder();
        if (carteiraDoEmissor == 1) {
            campoLivre.append(carteiraDoEmissor);
            campoLivre.append(String.format("%06d", emissor.getContaCorrente()));
            campoLivre.append(this.getNossoNumeroDoEmissorFormatado(emissor));
        } else if (carteiraDoEmissor == 2) {
            String nossoNumeroCompleto = this.getNossoNumeroDoEmissorFormatado(emissor);
            campoLivre.append(String.format("%06d", emissor.getContaCorrente()));
            campoLivre.append(emissor.getDigitoContaCorrente());
            campoLivre.append(nossoNumeroCompleto.substring(2, 5));
            campoLivre.append(nossoNumeroCompleto.substring(0, 1));
            campoLivre.append(nossoNumeroCompleto.substring(5, 8));
            campoLivre.append(nossoNumeroCompleto.substring(1, 2));
            campoLivre.append(nossoNumeroCompleto.substring(8));
            campoLivre.append(this.geradorDeDigito.geraDigitoMod11(campoLivre.toString()));
        } else {
            throw new IllegalArgumentException("A carteira digitada n\u00e3o \u00e9 suportada");
        }
        return new CodigoDeBarrasBuilder(boleto).comCampoLivre(campoLivre);
    }

    @Override
    public String getNumeroFormatadoComDigito() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getNumeroFormatado()).append("-");
        return builder.append(DIGITO_CAIXA).toString();
    }

    @Override
    public String getCarteiraDoEmissorFormatado(Emissor emissor) {
        return String.format("%02d", emissor.getCarteira());
    }

    @Override
    public String getContaCorrenteDoEmissorFormatado(Emissor emissor) {
        return String.format("%05d", emissor.getContaCorrente());
    }

    public String getCodigoFornecidoPelaAgenciaFormatado(Emissor emissor) {
        return String.format("%08d", emissor.getCodigoFornecidoPelaAgencia());
    }

    public String getCodigoOperacaoFormatado(Emissor emissor) {
        return String.format("%03d", emissor.getCodigoOperacao());
    }

    @Override
    public URL getImage() {
        String arquivo = "/br/com/caelum/stella/boleto/img/%s.png";
        String imagem = String.format(arquivo, this.getNumeroFormatado());
        return this.getClass().getResource(imagem);
    }

    @Override
    public String getNossoNumeroDoEmissorFormatado(Emissor emissor) {
        return String.format("%017d", emissor.getNossoNumero());
    }

    @Override
    public String getNumeroFormatado() {
        return NUMERO_CAIXA;
    }

    @Override
    public String getNossoNumeroECodDocumento(Emissor emissor) {
        String nn = this.getNossoNumeroDoEmissorFormatado(emissor);
        StringBuilder builder = new StringBuilder(nn);
        if (emissor.getDigitoNossoNumero() != null && !emissor.getDigitoNossoNumero().isEmpty()) {
            builder.append("-").append(emissor.getDigitoNossoNumero());
        }
        return builder.toString();
    }
}

