/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.boleto.bancos;

import br.com.caelum.stella.boleto.Banco;
import br.com.caelum.stella.boleto.Boleto;
import br.com.caelum.stella.boleto.Emissor;
import br.com.caelum.stella.boleto.bancos.AbstractBanco;
import br.com.caelum.stella.boleto.bancos.CodigoDeBarrasBuilder;
import java.net.URL;
import java.util.Calendar;

public class HSBC
extends AbstractBanco
implements Banco {
    private static final String NUMERO_HSBC = "399";
    private static final String DIGITO_HSBC = "9";
    private static final String CODIGO_APLICATIVO = "2";

    @Override
    public String getNumeroFormatadoComDigito() {
        return "399-9";
    }

    @Override
    public String geraCodigoDeBarrasPara(Boleto boleto) {
        StringBuilder campoLivre = new StringBuilder();
        int codigoAgencia = boleto.getEmissor().getCodigoFornecidoPelaAgencia();
        campoLivre.append(String.format("%07d", codigoAgencia));
        campoLivre.append(this.getNossoNumeroDoEmissorFormatado(boleto.getEmissor()));
        campoLivre.append(this.getDataFormatoJuliano(boleto.getDatas().getVencimento(), 4));
        campoLivre.append(CODIGO_APLICATIVO);
        return new CodigoDeBarrasBuilder(boleto).comCampoLivre(campoLivre);
    }

    public String getDataFormatoJuliano(Calendar vencimento, int tipo) {
        String result;
        Calendar dataLimite = Calendar.getInstance();
        dataLimite.set(5, 1);
        dataLimite.set(2, 6);
        dataLimite.set(1, 1997);
        if (vencimento.before(dataLimite)) {
            result = "0000";
        } else {
            int diaDoAno = vencimento.get(6);
            int digitoDoAno = vencimento.get(1) % 10;
            result = String.format("%03d%d", diaDoAno, digitoDoAno);
        }
        return result;
    }

    @Override
    public String getCarteiraDoEmissorFormatado(Emissor emissor) {
        return "CNR";
    }

    @Override
    public String getContaCorrenteDoEmissorFormatado(Emissor emissor) {
        return String.format("%07d", emissor.getContaCorrente());
    }

    @Override
    public URL getImage() {
        String arquivo = "/br/com/caelum/stella/boleto/img/%s.png";
        String imagem = String.format(arquivo, this.getNumeroFormatado());
        return this.getClass().getResource(imagem);
    }

    @Override
    public String getNossoNumeroDoEmissorFormatado(Emissor emissor) {
        return String.format("%016d", emissor.getNossoNumero()).substring(0, 13);
    }

    @Override
    public String getNumeroFormatado() {
        return NUMERO_HSBC;
    }

    @Override
    public String getAgenciaECodigoCedente(Emissor emissor) {
        return String.format("%07d", emissor.getCodigoFornecidoPelaAgencia());
    }

    @Override
    public String getNossoNumeroECodDocumento(Emissor emissor) {
        return String.format("%016d", emissor.getNossoNumero());
    }
}

