/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.boleto.bancos.gerador;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DigitoPara {
    private List<Integer> numero;
    private List<Integer> multiplicadores = new ArrayList<Integer>();
    private boolean complementar;
    private List<Integer> aSubstituir;
    private String substituto;

    public DigitoPara(String trecho) {
        char[] digitos;
        this.comMultiplicadoresDeAte(2, 9);
        this.aSubstituir = Collections.emptyList();
        this.numero = new ArrayList<Integer>();
        for (char digito : digitos = trecho.toCharArray()) {
            this.numero.add(Character.getNumericValue(digito));
        }
        Collections.reverse(this.numero);
    }

    public DigitoPara comMultiplicadoresDeAte(int inicio, int fim) {
        this.multiplicadores.clear();
        for (int i = inicio; i <= fim; ++i) {
            this.multiplicadores.add(i);
        }
        return this;
    }

    public DigitoPara comMultiplicadores(Integer ... multiplicadoresEmOrdem) {
        this.multiplicadores = Arrays.asList(multiplicadoresEmOrdem);
        return this;
    }

    public DigitoPara complementarAoModulo() {
        this.complementar = true;
        return this;
    }

    public DigitoPara trocandoPorSeEncontrar(String substituto, Integer ... i) {
        this.substituto = substituto;
        this.aSubstituir = Arrays.asList(i);
        return this;
    }

    public String mod(int modulo) {
        int soma = 0;
        int multiplicadorDaVez = 0;
        for (int algarismo : this.numero) {
            soma += algarismo * this.multiplicadores.get(multiplicadorDaVez);
            multiplicadorDaVez = this.proximoMultiplicador(multiplicadorDaVez);
        }
        int resultado = soma % modulo;
        if (this.complementar) {
            resultado = modulo - resultado;
        }
        return this.aSubstituir.contains(resultado) ? this.substituto : String.valueOf(resultado);
    }

    private int proximoMultiplicador(int multiplicadorDaVez) {
        if (++multiplicadorDaVez == this.multiplicadores.size()) {
            multiplicadorDaVez = 0;
        }
        return multiplicadorDaVez;
    }
}

