/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.boleto.transformer;

import br.com.caelum.stella.boleto.Boleto;
import br.com.caelum.stella.boleto.exception.GeracaoBoletoException;
import br.com.caelum.stella.boleto.transformer.BoletoTransformer;
import br.com.caelum.stella.boleto.transformer.BoletoWriter;
import br.com.caelum.stella.boleto.transformer.HTMLBoletoWriter;
import br.com.caelum.stella.boleto.transformer.PDFBoletoWriter;
import br.com.caelum.stella.boleto.transformer.PNGBoletoWriter;
import br.com.caelum.stella.boleto.transformer.StreamHelper;
import java.io.File;
import java.io.InputStream;

public class GeradorDeBoleto {
    private final Boleto[] boletos;

    public GeradorDeBoleto(Boleto ... boletos) {
        this.boletos = boletos;
    }

    public void geraPDF(String arquivo) {
        File file = new File(arquivo);
        this.geraPDF(file);
    }

    public void geraPDF(File arquivo) {
        new StreamHelper().escreveArquivo(arquivo, this.geraStream(new PDFBoletoWriter()));
    }

    public void geraPNG(String arquivo) {
        File file = new File(arquivo);
        this.geraPNG(file);
    }

    public void geraPNG(File arquivo) {
        new StreamHelper().escreveArquivo(arquivo, this.geraStream(new PNGBoletoWriter()));
    }

    public byte[] geraPDF() {
        return new StreamHelper().geraBytes(this.geraStream(new PDFBoletoWriter()));
    }

    public byte[] geraPNG() {
        return new StreamHelper().geraBytes(this.geraStream(new PNGBoletoWriter()));
    }

    public byte[] geraHTML() {
        return new StreamHelper().geraBytes(this.geraStream(new HTMLBoletoWriter()));
    }

    public void geraHTML(File arquivo) {
        new StreamHelper().escreveArquivo(arquivo, this.geraStream(new HTMLBoletoWriter()));
    }

    public void geraHTML(String arquivo) {
        File file = new File(arquivo);
        this.geraHTML(file);
    }

    public InputStream geraHTMLStream() {
        return this.geraStream(new HTMLBoletoWriter());
    }

    public InputStream geraPDFStream() {
        return this.geraStream(new PDFBoletoWriter());
    }

    public InputStream geraPNGStream() {
        return this.geraStream(new PNGBoletoWriter());
    }

    public InputStream geraStream(BoletoWriter writer) {
        try {
            BoletoTransformer transformer = new BoletoTransformer(writer);
            return transformer.transform(this.boletos);
        }
        catch (Exception e) {
            throw new GeracaoBoletoException("Erro na gera\u00e7\u00e3o do boleto", e);
        }
    }
}

