/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.boleto.transformer;

import br.com.caelum.stella.boleto.Banco;
import br.com.caelum.stella.boleto.Boleto;
import br.com.caelum.stella.boleto.Datas;
import br.com.caelum.stella.boleto.Emissor;
import br.com.caelum.stella.boleto.Sacado;
import br.com.caelum.stella.boleto.bancos.GeradorDeLinhaDigitavel;
import br.com.caelum.stella.boleto.exception.CriacaoBoletoException;
import br.com.caelum.stella.boleto.exception.GeracaoBoletoException;
import br.com.caelum.stella.boleto.transformer.BoletoWriter;
import br.com.caelum.stella.boleto.transformer.FormatadorDeBoleto;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

public class HTMLBoletoWriter
implements BoletoWriter {
    private final String urlServletBoleto;
    private Template template;
    private final Collection<BoletoTemplateWrapper> boletos;
    private final VelocityEngine velocityEngine;

    public HTMLBoletoWriter(String urlServletBoleto) {
        this.urlServletBoleto = urlServletBoleto;
        this.boletos = new ArrayList<BoletoTemplateWrapper>();
        this.velocityEngine = new VelocityEngine();
        Properties config = new Properties();
        config.setProperty("file.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        try {
            this.velocityEngine.init(config);
            this.template = this.velocityEngine.getTemplate("/br/com/caelum/stella/boleto/template_html.vm");
        }
        catch (Exception e) {
            throw new GeracaoBoletoException("N\u00e3o foi possivel iniciar a configura\u00e7\u00e3o do Velocity", e);
        }
    }

    public HTMLBoletoWriter() {
        this("stella-boleto");
    }

    @Override
    public void write(Boleto boleto) {
        BoletoTemplateWrapper wrapper = new BoletoTemplateWrapper(boleto);
        this.boletos.add(wrapper);
    }

    @Override
    public boolean newPage() {
        return true;
    }

    @Override
    public InputStream toInputStream() {
        StringWriter writer = new StringWriter();
        VelocityContext context = new VelocityContext();
        context.put("boletos", this.boletos);
        context.put("urlServletBoleto", (Object)this.urlServletBoleto);
        try {
            this.template.merge((Context)context, (Writer)writer);
        }
        catch (ResourceNotFoundException e) {
            throw new CriacaoBoletoException("Erro na cria\u00e7\u00e3o do boleto", (Exception)((Object)e));
        }
        catch (ParseErrorException e) {
            throw new CriacaoBoletoException("Erro na cria\u00e7\u00e3o do boleto", (Exception)((Object)e));
        }
        catch (MethodInvocationException e) {
            throw new CriacaoBoletoException("Erro na cria\u00e7\u00e3o do boleto", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new CriacaoBoletoException("Erro na cria\u00e7\u00e3o do boleto", e);
        }
        return new ByteArrayInputStream(writer.toString().getBytes());
    }

    public class BoletoTemplateWrapper {
        private final GeradorDeLinhaDigitavel linhaDigitavelGenerator;
        private final Boleto boleto;
        private final String linhaDigitavel;
        private final String codigoDeBarras;

        private BoletoTemplateWrapper(Boleto boleto) {
            this.boleto = boleto;
            this.linhaDigitavelGenerator = new GeradorDeLinhaDigitavel();
            this.codigoDeBarras = this.boleto.getBanco().geraCodigoDeBarrasPara(this.boleto);
            this.linhaDigitavel = this.linhaDigitavelGenerator.geraLinhaDigitavelPara(this.codigoDeBarras);
        }

        public char aceite() {
            return this.getAceite() ? (char)'S' : 'N';
        }

        public String formataData(Calendar data) {
            return FormatadorDeBoleto.formataData(data);
        }

        public String formataValor() {
            return FormatadorDeBoleto.formataValor(this.boleto.getValorBoleto().doubleValue());
        }

        public String nossoNumero() {
            return this.getBanco().getNossoNumeroDoEmissorFormatado(this.boleto.getEmissor());
        }

        public String carteira() {
            return this.getBanco().getCarteiraDoEmissorFormatado(this.boleto.getEmissor());
        }

        public String contaCorrente() {
            return this.getBanco().getContaCorrenteDoEmissorFormatado(this.boleto.getEmissor());
        }

        public String linhaDigitavel() {
            return this.linhaDigitavel;
        }

        public String codigoDeBarras() {
            return this.codigoDeBarras;
        }

        public boolean getAceite() {
            return this.boleto.getAceite();
        }

        public Banco getBanco() {
            return this.boleto.getBanco();
        }

        public int getCodEspecieMoeda() {
            return this.boleto.getCodigoEspecieMoeda();
        }

        public Datas getDatas() {
            return this.boleto.getDatas();
        }

        public List<String> getDescricoes() {
            return this.boleto.getDescricoes();
        }

        public Emissor getEmissor() {
            return this.boleto.getEmissor();
        }

        public String getEspecieDocumento() {
            return this.boleto.getEspecieDocumento();
        }

        public String getEspecieMoeda() {
            return this.boleto.getEspecieMoeda();
        }

        public String getFatorVencimento() {
            return this.boleto.getFatorVencimento();
        }

        public List<String> getInstrucoes() {
            return this.boleto.getInstrucoes();
        }

        public List<String> getLocaisDePagamento() {
            return this.boleto.getLocaisDePagamento();
        }

        public String getNoDocumento() {
            return this.boleto.getNumeroDoDocumento();
        }

        public String getNoDocumentoFormatado() {
            return this.boleto.getNumeroDoDocumentoFormatado();
        }

        public BigDecimal getQtdMoeda() {
            return this.boleto.getQuantidadeDeMoeda();
        }

        public Sacado getSacado() {
            return this.boleto.getSacado();
        }

        public BigDecimal getValorBoleto() {
            return this.boleto.getValorBoleto();
        }

        public String getValorFormatado() {
            return this.boleto.getValorFormatado();
        }

        public BigDecimal getValorMoeda() {
            return this.boleto.getValorMoeda();
        }

        public String nomeArquivoCodigoDeBarras() {
            return this.codigoDeBarras + "_" + this.boleto.getBanco().getNumeroFormatado() + ".png";
        }

        public String getAgenciaECodigoCedente() {
            return this.boleto.getAgenciaECodigoCedente();
        }
    }
}

