/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.boleto.transformer;

import br.com.caelum.stella.boleto.Boleto;
import br.com.caelum.stella.boleto.exception.GeracaoBoletoException;
import br.com.caelum.stella.boleto.transformer.BoletoWriter;
import br.com.caelum.stella.boleto.transformer.PNGPDFTransformerHelper;
import br.com.caelum.stella.boleto.transformer.TextWriter;
import com.itextpdf.text.BadElementException;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PDFBoletoWriter
implements BoletoWriter,
TextWriter {
    private static final int NORMAL_SIZE = 8;
    private static final int BIG_SIZE = 10;
    private InputStream stream;
    private final ByteArrayOutputStream bytes = new ByteArrayOutputStream();
    private final Document document;
    private PdfWriter writer;
    private BaseFont fonteSimples;
    private BaseFont fonteBold;
    private final PdfContentByte contentByte;
    private final int scale = 1;
    private final PNGPDFTransformerHelper writerHelper;

    public PDFBoletoWriter(Rectangle rectangle) {
        this.document = new Document(rectangle);
        try {
            this.writer = PdfWriter.getInstance((Document)this.document, (OutputStream)this.bytes);
            this.fonteSimples = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)true);
            this.fonteBold = BaseFont.createFont((String)"Helvetica-Bold", (String)"Cp1252", (boolean)true);
        }
        catch (DocumentException e) {
            throw new GeracaoBoletoException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new GeracaoBoletoException(e);
        }
        this.document.open();
        this.contentByte = this.writer.getDirectContent();
        this.document.newPage();
        this.writerHelper = new PNGPDFTransformerHelper(this);
    }

    public PDFBoletoWriter() {
        this(PageSize.A4);
    }

    @Override
    public InputStream toInputStream() {
        if (this.stream == null) {
            this.document.close();
            this.stream = new ByteArrayInputStream(this.bytes.toByteArray());
        }
        return this.stream;
    }

    @Override
    public void write(float x, float y, String text) {
        this.write(x, y, text, this.fonteSimples, 8);
    }

    @Override
    public void writeBold(float x, float y, String text) {
        this.write(x, y, text, this.fonteBold, 10);
    }

    private void write(float x, float y, String text, BaseFont font, int size) {
        this.checkIfDocIsClosed();
        this.contentByte.beginText();
        this.contentByte.setFontAndSize(font, (float)size);
        float leftMargin = this.document.leftMargin();
        this.contentByte.setTextMatrix(leftMargin + x, y);
        this.contentByte.showText(text);
        this.contentByte.endText();
    }

    private void checkIfDocIsClosed() {
        if (this.stream != null) {
            throw new IllegalStateException("boleto ja gerado, voce nao pode mais escrever na imagem");
        }
    }

    @Override
    public void writeImage(float x, float y, BufferedImage image, float width, float height) throws IOException {
        this.checkIfDocIsClosed();
        try {
            com.itextpdf.text.Image pdfImage = com.itextpdf.text.Image.getInstance((Image)image, null);
            pdfImage.setAbsolutePosition(0.0f, 0.0f);
            pdfImage.scaleToFit(width, height);
            PdfTemplate template = this.contentByte.createTemplate((float)image.getWidth(), (float)image.getHeight());
            template.addImage(pdfImage);
            float leftMargin = this.document.leftMargin();
            this.contentByte.addTemplate(template, leftMargin + x, y);
        }
        catch (BadElementException e) {
            throw new GeracaoBoletoException((Exception)((Object)e));
        }
        catch (DocumentException e) {
            throw new GeracaoBoletoException((Exception)((Object)e));
        }
    }

    @Override
    public boolean newPage() {
        return this.document.newPage();
    }

    @Override
    public void write(Boleto boleto) {
        this.writerHelper.transform(boleto);
    }
}

