/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.boleto.transformer;

import br.com.caelum.stella.boleto.Boleto;
import br.com.caelum.stella.boleto.exception.GeracaoBoletoException;
import br.com.caelum.stella.boleto.transformer.BoletoWriter;
import br.com.caelum.stella.boleto.transformer.PNGPDFTransformerHelper;
import br.com.caelum.stella.boleto.transformer.TextWriter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class PNGBoletoWriter
implements BoletoWriter,
TextWriter {
    private static final int NORMAL_SIZE = 36;
    private static final int BIG_SIZE = 45;
    private final Font fonteSimples;
    private final Font fonteBold;
    private final BufferedImage PNGimage;
    private InputStream stream;
    private final Graphics2D graphics;
    private final PNGPDFTransformerHelper writerHelper;

    public PNGBoletoWriter() {
        this(2144.0, 1900.0);
    }

    public PNGBoletoWriter(double w, double h) {
        this.PNGimage = new BufferedImage((int)w, (int)h, 1);
        this.graphics = this.PNGimage.createGraphics();
        this.graphics.setColor(Color.white);
        this.graphics.fillRect(0, 0, (int)w, (int)h);
        this.graphics.drawImage((Image)this.PNGimage, 0, 0, null);
        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.graphics.setColor(Color.BLACK);
        this.fonteBold = new Font("Helvetica-Bold", 1, 45);
        this.fonteSimples = new Font("Helvetica", 0, 36);
        this.writerHelper = new PNGPDFTransformerHelper(this);
    }

    @Override
    public InputStream toInputStream() {
        if (this.stream == null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)this.PNGimage, "PNG", baos);
            }
            catch (IOException e) {
                throw new GeracaoBoletoException(e);
            }
            this.stream = new ByteArrayInputStream(baos.toByteArray());
        }
        return this.stream;
    }

    @Override
    public void write(float x, float y, String text) {
        this.checkIfDocIsClosed();
        this.graphics.setFont(this.fonteSimples);
        this.graphics.drawString(text, this.scaleX(x), this.scaleY(y));
    }

    @Override
    public void writeBold(float x, float y, String text) {
        this.checkIfDocIsClosed();
        this.graphics.setFont(this.fonteBold);
        this.graphics.drawString(text, this.scaleX(x), this.scaleY(y));
    }

    @Override
    public void writeImage(float x, float y, BufferedImage image, float width, float height) throws IOException {
        this.checkIfDocIsClosed();
        this.graphics.drawImage(image, (int)x, (int)((float)this.PNGimage.getHeight() - height * 4.16f - y * 4.16f), (int)(width * 4.16f), (int)(height * 4.16f), null);
    }

    private void checkIfDocIsClosed() {
        if (this.stream != null) {
            throw new IllegalStateException("boleto ja gerado, voce nao pode mais escrever na imagem");
        }
    }

    private float scaleX(float x) {
        return x * 4.16f;
    }

    private float scaleY(float y) {
        y = (float)this.PNGimage.getHeight() - y;
        return y * 4.16f - 6005.0f;
    }

    @Override
    public boolean newPage() {
        throw new IllegalStateException("Nao \u00e9 possivel criar uma nova pagina em um arquivo png.");
    }

    @Override
    public void write(Boleto boleto) {
        this.writerHelper.transform(boleto);
    }
}

