/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.boleto.transformer;

import br.com.caelum.stella.boleto.Boleto;
import br.com.caelum.stella.boleto.bancos.GeradorDeLinhaDigitavel;
import br.com.caelum.stella.boleto.exception.CriacaoBoletoException;
import br.com.caelum.stella.boleto.exception.GeracaoBoletoException;
import br.com.caelum.stella.boleto.transformer.BufferedImageGenerator;
import br.com.caelum.stella.boleto.transformer.FormatadorDeBoleto;
import br.com.caelum.stella.boleto.transformer.GeradorDeImagemDoCodigoDeBarras;
import br.com.caelum.stella.boleto.transformer.TextWriter;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.Calendar;
import javax.imageio.ImageIO;

class PNGPDFTransformerHelper {
    public static final float IMAGEM_BOLETO_WIDTH = 2144.0f;
    public static final float IMAGEM_BOLETO_HEIGHT = 1604.0f;
    public static final double BOLETO_TEMPLATE_SCALE = 0.5;
    private TextWriter writer;
    private URL imagemTitulo;

    public PNGPDFTransformerHelper(TextWriter writer) {
        this.writer = writer;
        this.imagemTitulo = PNGPDFTransformerHelper.class.getResource("/br/com/caelum/stella/boleto/img/template.png");
    }

    public TextWriter transform(Boleto boleto) {
        this.geraTemplateComOFundoDoBoleto(boleto);
        this.imprimeReciboDeSacado(boleto);
        this.imprimeLinhaDigitavelEmNegrito(boleto);
        this.imprimeLocaisDePagamentoEVencimento(boleto);
        this.imprimeDadosDoCedente(boleto);
        this.imprimeDadosDoDocumento(boleto);
        this.imprimeDadosDoBoletoInclusiveValor(boleto);
        this.imprimeInstrucoesDePagamento(boleto);
        this.imprimeUnidadeCedente(boleto);
        this.imprimeDadosDoSacado(boleto);
        this.geraEImprimeCodigoDeBarras(boleto);
        return this.writer;
    }

    private BufferedImage toBufferedImage(Image image, int type) {
        return BufferedImageGenerator.generateBufferedImageFor(image, type);
    }

    private BufferedImage imageFor(URL file) throws IOException {
        return ImageIO.read(file);
    }

    private String formatDate(Calendar date) {
        return FormatadorDeBoleto.formataData(date);
    }

    private void geraTemplateComOFundoDoBoleto(Boleto boleto) {
        try {
            this.writer.writeImage(0.0f, 55.0f, this.imageFor(this.imagemTitulo), 514.22f, 385.109f);
            this.writer.writeImage(0.0f, 319.0f, this.imageFor(boleto.getBanco().getImage()), 100.0f, 23.0f);
        }
        catch (IOException e) {
            throw new GeracaoBoletoException("Erro na leitura das imagens do boleto", e);
        }
        for (int i = 0; i < boleto.getDescricoes().size(); ++i) {
            this.writer.writeBold(5.0f, 735 - i * 15, boleto.getDescricoes().get(i));
        }
    }

    private void imprimeReciboDeSacado(Boleto boleto) {
        float LINHA1 = 434.0f;
        float LINHA_ENDERECO_CEDENTE = 423.0f;
        float LINHA2 = 400.0f;
        float LINHA3 = 378.0f;
        this.writer.write(50.0f, 434.0f, boleto.getEmissor().getCedente());
        this.writer.write(50.0f, 423.0f, this.nullToEmpty(boleto.getEmissor().getEndereco()));
        this.writer.write(5.0f, 400.0f, boleto.getSacado().getNome());
        this.writer.write(290.0f, 400.0f, this.formatDate(boleto.getDatas().getVencimento()));
        this.writer.write(377.0f, 400.0f, FormatadorDeBoleto.formataValor(boleto.getValorBoleto().doubleValue()));
        this.writer.write(5.0f, 378.0f, boleto.getAgenciaECodigoCedente());
        this.writer.write(146.0f, 378.0f, boleto.getNossoNumeroECodDocumento());
    }

    private void imprimeLinhaDigitavelEmNegrito(Boleto boleto) {
        float LINHA4 = 319.0f;
        this.writer.writeBold(125.0f, 319.0f, boleto.getBanco().getNumeroFormatadoComDigito());
        GeradorDeLinhaDigitavel linhaDigitavelGenerator = new GeradorDeLinhaDigitavel();
        String codigoDeBarras = boleto.getBanco().geraCodigoDeBarrasPara(boleto);
        this.writer.writeBold(175.0f, 319.0f, linhaDigitavelGenerator.geraLinhaDigitavelPara(codigoDeBarras));
    }

    private void imprimeLocaisDePagamentoEVencimento(Boleto boleto) {
        float LINHA5 = 291.0f;
        for (int i = 0; i < boleto.getLocaisDePagamento().size(); ++i) {
            this.writer.write(5.0f, 291.0f - (float)((i - 1) * 10), boleto.getLocaisDePagamento().get(i));
        }
        this.writer.write(425.0f, 291.0f, this.formatDate(boleto.getDatas().getVencimento()));
    }

    private void imprimeDadosDoCedente(Boleto boleto) {
        float LINHA6 = 271.0f;
        this.writer.write(5.0f, 271.0f, boleto.getEmissor().getCedente());
        this.writer.write(420.0f, 271.0f, boleto.getAgenciaECodigoCedente());
    }

    private void imprimeDadosDoDocumento(Boleto boleto) {
        float LINHA7 = 250.0f;
        this.writer.write(5.0f, 250.0f, this.formatDate(boleto.getDatas().getDocumento()));
        this.writer.write(70.0f, 250.0f, boleto.getNumeroDoDocumento().equals("") ? boleto.getBanco().getNossoNumeroDoEmissorFormatado(boleto.getEmissor()) : boleto.getNumeroDoDocumentoFormatado());
        this.writer.write(180.0f, 250.0f, boleto.getEspecieDocumento());
        this.writer.write(250.0f, 250.0f, boleto.getAceite() ? "S" : "N");
        this.writer.write(300.0f, 250.0f, this.formatDate(boleto.getDatas().getProcessamento()));
        this.writer.write(410.0f, 250.0f, boleto.getNossoNumeroECodDocumento());
    }

    private void imprimeDadosDoBoletoInclusiveValor(Boleto boleto) {
        float LINHA8 = 227.0f;
        this.writer.write(122.0f, 227.0f, boleto.getBanco().getCarteiraDoEmissorFormatado(boleto.getEmissor()));
        this.writer.write(190.0f, 227.0f, boleto.getEspecieMoeda());
        this.writer.write(430.0f, 227.0f, FormatadorDeBoleto.formataValor(boleto.getValorBoleto().doubleValue()));
    }

    private void imprimeInstrucoesDePagamento(Boleto boleto) {
        float LINHA9 = 205.0f;
        for (int i = 0; i < boleto.getInstrucoes().size(); ++i) {
            this.writer.write(5.0f, 205.0f - (float)(i * 10), boleto.getInstrucoes().get(i));
        }
    }

    private void imprimeUnidadeCedente(Boleto boleto) {
        float LINHA10 = 132.0f;
        float LINHA_ENDERECO = 122.0f;
        this.writer.write(5.0f, 132.0f, boleto.getEmissor().getCedente());
        this.writer.write(5.0f, 122.0f, this.nullToEmpty(boleto.getEmissor().getEndereco()));
    }

    private void imprimeDadosDoSacado(Boleto boleto) {
        float LINHA11 = 97.0f;
        float LINHA12 = 87.0f;
        float LINHA13 = 77.0f;
        this.writer.write(50.0f, 97.0f, (boleto.getSacado().getNome() != null ? boleto.getSacado().getNome() : "") + " " + (boleto.getSacado().getCpf() != null ? boleto.getSacado().getCpf() : ""));
        this.writer.write(50.0f, 87.0f, boleto.getSacado().getEndereco() != null ? boleto.getSacado().getEndereco() : "");
        this.writer.write(50.0f, 77.0f, (boleto.getSacado().getCep() != null ? boleto.getSacado().getCep() : "") + " " + (boleto.getSacado().getBairro() != null ? boleto.getSacado().getBairro() : "") + " - " + (boleto.getSacado().getCidade() != null ? boleto.getSacado().getCidade() : "") + " " + (boleto.getSacado().getUf() != null ? boleto.getSacado().getUf() : ""));
    }

    private void geraEImprimeCodigoDeBarras(Boleto boleto) {
        Image imagemDoCodigoDeBarras = GeradorDeImagemDoCodigoDeBarras.geraImagemDoCodigoDeBarrasPara(boleto.getBanco().geraCodigoDeBarrasPara(boleto), 39.0f);
        try {
            this.writer.writeImage(5.0f, 10.0f, this.toBufferedImage(imagemDoCodigoDeBarras, 2), 280.0f, imagemDoCodigoDeBarras.getHeight(null));
        }
        catch (IOException e) {
            throw new CriacaoBoletoException("Erro na gera\u00e7\u00e3o do c\u00f3digo de barras", e);
        }
    }

    private String nullToEmpty(String str) {
        return str == null ? "" : str;
    }
}

