/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.boleto.transformer;

import br.com.caelum.stella.boleto.exception.GeracaoBoletoException;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class StreamHelper {
    public void escreveArquivo(File file, InputStream is) {
        ReadableByteChannel inputChannel = null;
        WritableByteChannel outputChannel = null;
        try {
            inputChannel = Channels.newChannel(is);
            outputChannel = Channels.newChannel(new FileOutputStream(file));
            ByteBuffer buffer = ByteBuffer.allocate(1024);
            while (inputChannel.read(buffer) != -1) {
                buffer.flip();
                outputChannel.write(buffer);
                buffer.clear();
            }
            this.fecharSilenciosamente(outputChannel);
            this.fecharSilenciosamente(inputChannel);
        }
        catch (Exception e) {
            try {
                throw new GeracaoBoletoException("Erro ao escrever arquivo do boleto", e);
            }
            catch (Throwable throwable) {
                this.fecharSilenciosamente(outputChannel);
                this.fecharSilenciosamente(inputChannel);
                throw throwable;
            }
        }
    }

    private void fecharSilenciosamente(Closeable c) {
        try {
            c.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte[] geraBytes(InputStream is) {
        try {
            byte[] b = new byte[is.available()];
            is.read(b);
            byte[] byArray = b;
            return byArray;
        }
        catch (Exception e) {
            throw new GeracaoBoletoException("Erro na gera\u00e7\u00e3o do boleto", e);
        }
        finally {
            this.fecharSilenciosamente(is);
        }
    }
}

