/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.parser;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeDeclaredChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeChildChoiceDefinition;
import ca.uhn.fhir.context.RuntimeChildContainedResources;
import ca.uhn.fhir.context.RuntimeChildNarrativeDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.model.api.IIdentifiableElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.ISupportsUndeclaredExtensions;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.api.Tag;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.parser.IParserErrorHandler;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.UrlUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseElement;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseHasModifierExtensions;
import org.hl7.fhir.instance.model.api.IBaseMetaType;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseParser
implements IParser {
    private static final Logger ourLog = LoggerFactory.getLogger(BaseParser.class);
    private ContainedResources myContainedResources;
    private boolean myEncodeElementsAppliesToChildResourcesOnly;
    private FhirContext myContext;
    private Set<String> myDontEncodeElements;
    private boolean myDontEncodeElementsIncludesStars;
    private Set<String> myEncodeElements;
    private Set<String> myEncodeElementsAppliesToResourceTypes;
    private boolean myEncodeElementsIncludesStars;
    private IIdType myEncodeForceResourceId;
    private IParserErrorHandler myErrorHandler;
    private boolean myOmitResourceId;
    private List<Class<? extends IBaseResource>> myPreferTypes;
    private String myServerBaseUrl;
    private Boolean myStripVersionsFromReferences;
    private Boolean myOverrideResourceIdWithBundleEntryFullUrl;
    private boolean mySummaryMode;
    private boolean mySuppressNarratives;
    private Set<String> myDontStripVersionsFromReferencesAtPaths;

    public BaseParser(FhirContext theContext, IParserErrorHandler theParserErrorHandler) {
        this.myContext = theContext;
        this.myErrorHandler = theParserErrorHandler;
    }

    protected Iterable<CompositeChildElement> compositeChildIterator(IBase theCompositeElement, final boolean theContainedResource, final boolean theSubResource, final CompositeChildElement theParent) {
        BaseRuntimeElementCompositeDefinition elementDef = (BaseRuntimeElementCompositeDefinition)this.myContext.getElementDefinition(theCompositeElement.getClass());
        final List<BaseRuntimeChildDefinition> children = elementDef.getChildrenAndExtension();
        return new Iterable<CompositeChildElement>(){

            @Override
            public Iterator<CompositeChildElement> iterator() {
                return new Iterator<CompositeChildElement>(){
                    private Iterator<? extends BaseRuntimeChildDefinition> myChildrenIter;
                    private Boolean myHasNext = null;
                    private CompositeChildElement myNext;
                    {
                        this.myChildrenIter = children.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.myHasNext != null) {
                            return this.myHasNext;
                        }
                        this.myNext = null;
                        do {
                            if (!this.myChildrenIter.hasNext()) {
                                this.myHasNext = Boolean.FALSE;
                                return false;
                            }
                            this.myNext = new CompositeChildElement(theParent, this.myChildrenIter.next(), theSubResource);
                            if (this.myNext.getDef().getElementName().equals("id")) {
                                this.myNext = null;
                                continue;
                            }
                            if (!this.myNext.shouldBeEncoded()) {
                                this.myNext = null;
                                continue;
                            }
                            if (BaseParser.this.isSummaryMode() && !this.myNext.getDef().isSummary()) {
                                this.myNext = null;
                                continue;
                            }
                            if (this.myNext.getDef() instanceof RuntimeChildNarrativeDefinition) {
                                if (BaseParser.this.isSuppressNarratives() || BaseParser.this.isSummaryMode()) {
                                    this.myNext = null;
                                    continue;
                                }
                                if (!theContainedResource) continue;
                                this.myNext = null;
                                continue;
                            }
                            if (!(this.myNext.getDef() instanceof RuntimeChildContainedResources) || !theContainedResource) continue;
                            this.myNext = null;
                        } while (this.myNext == null);
                        this.myHasNext = true;
                        return true;
                    }

                    @Override
                    public CompositeChildElement next() {
                        if (this.myHasNext == null && !this.hasNext()) {
                            throw new IllegalStateException();
                        }
                        CompositeChildElement retVal = this.myNext;
                        this.myNext = null;
                        this.myHasNext = null;
                        return retVal;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private void containResourcesForEncoding(ContainedResources theContained, IBaseResource theResource, IBaseResource theTarget) {
        IBaseResource resource;
        String nextId;
        List<IBaseResource> containedResources;
        if (theTarget instanceof IResource) {
            containedResources = ((IResource)theTarget).getContained().getContainedResources();
            for (IResource iResource : containedResources) {
                nextId = iResource.getId().getValue();
                if (!StringUtils.isNotBlank((CharSequence)nextId)) continue;
                if (!nextId.startsWith("#")) {
                    nextId = '#' + nextId;
                }
                theContained.getExistingIdToContainedResource().put(nextId, iResource);
            }
        } else if (theTarget instanceof IDomainResource) {
            containedResources = ((IDomainResource)theTarget).getContained();
            for (IAnyResource iAnyResource : containedResources) {
                nextId = iAnyResource.getIdElement().getValue();
                if (!StringUtils.isNotBlank((CharSequence)nextId)) continue;
                if (!nextId.startsWith("#")) {
                    nextId = '#' + nextId;
                }
                theContained.getExistingIdToContainedResource().put(nextId, iAnyResource);
            }
        }
        List<IBaseReference> allReferences = this.myContext.newTerser().getAllPopulatedChildElementsOfType(theResource, IBaseReference.class);
        for (IBaseReference iBaseReference : allReferences) {
            IBaseResource potentialTarget;
            resource = iBaseReference.getResource();
            if (resource != null || !iBaseReference.getReferenceElement().isLocal() || !theContained.hasExistingIdToContainedResource() || (potentialTarget = theContained.getExistingIdToContainedResource().remove(iBaseReference.getReferenceElement().getValue())) == null) continue;
            theContained.addContained(iBaseReference.getReferenceElement(), potentialTarget);
            this.containResourcesForEncoding(theContained, potentialTarget, theTarget);
        }
        for (IBaseReference iBaseReference : allReferences) {
            resource = iBaseReference.getResource();
            if (resource == null || !resource.getIdElement().isEmpty() && !resource.getIdElement().isLocal() || theContained.getResourceId(resource) != null) continue;
            theContained.addContained(resource);
            if (resource.getIdElement().isLocal() && theContained.hasExistingIdToContainedResource()) {
                theContained.getExistingIdToContainedResource().remove(resource.getIdElement().getValue());
            }
            this.containResourcesForEncoding(theContained, resource, theTarget);
        }
    }

    protected void containResourcesForEncoding(IBaseResource theResource) {
        ContainedResources contained = new ContainedResources();
        this.containResourcesForEncoding(contained, theResource, theResource);
        contained.assignIdsToContainedResources();
        this.myContainedResources = contained;
    }

    private String determineReferenceText(IBaseReference theRef, CompositeChildElement theCompositeChildElement) {
        IIdType ref = theRef.getReferenceElement();
        if (StringUtils.isBlank((CharSequence)ref.getIdPart())) {
            String reference = ref.getValue();
            if (theRef.getResource() != null) {
                IIdType containedId = this.getContainedResources().getResourceId(theRef.getResource());
                if (containedId != null && !containedId.isEmpty()) {
                    reference = containedId.isLocal() ? containedId.getValue() : "#" + containedId.getValue();
                } else {
                    IIdType refId = theRef.getResource().getIdElement();
                    if (refId != null && refId.hasIdPart()) {
                        if (refId.getValue().startsWith("urn:")) {
                            reference = refId.getValue();
                        } else {
                            if (!refId.hasResourceType()) {
                                refId = refId.withResourceType(this.myContext.getResourceDefinition(theRef.getResource()).getName());
                            }
                            reference = this.isStripVersionsFromReferences(theCompositeChildElement) ? refId.toVersionless().getValue() : refId.getValue();
                        }
                    }
                }
            }
            return reference;
        }
        if (!ref.hasResourceType() && !ref.isLocal() && theRef.getResource() != null) {
            ref = ref.withResourceType(this.myContext.getResourceDefinition(theRef.getResource()).getName());
        }
        if (StringUtils.isNotBlank((CharSequence)this.myServerBaseUrl) && StringUtils.equals((CharSequence)this.myServerBaseUrl, (CharSequence)ref.getBaseUrl())) {
            if (this.isStripVersionsFromReferences(theCompositeChildElement)) {
                return ref.toUnqualifiedVersionless().getValue();
            }
            return ref.toUnqualified().getValue();
        }
        if (this.isStripVersionsFromReferences(theCompositeChildElement)) {
            return ref.toVersionless().getValue();
        }
        return ref.getValue();
    }

    protected abstract void doEncodeResourceToWriter(IBaseResource var1, Writer var2) throws IOException, DataFormatException;

    protected abstract <T extends IBaseResource> T doParseResource(Class<T> var1, Reader var2) throws DataFormatException;

    @Override
    public String encodeResourceToString(IBaseResource theResource) throws DataFormatException {
        StringWriter stringWriter = new StringWriter();
        try {
            this.encodeResourceToWriter(theResource, stringWriter);
        }
        catch (IOException e) {
            throw new Error("Encountered IOException during write to string - This should not happen!");
        }
        return ((Object)stringWriter).toString();
    }

    @Override
    public final void encodeResourceToWriter(IBaseResource theResource, Writer theWriter) throws IOException, DataFormatException {
        Validate.notNull((Object)theResource, (String)"theResource can not be null", (Object[])new Object[0]);
        Validate.notNull((Object)theWriter, (String)"theWriter can not be null", (Object[])new Object[0]);
        if (theResource.getStructureFhirVersionEnum() != this.myContext.getVersion().getVersion()) {
            throw new IllegalArgumentException("This parser is for FHIR version " + (Object)((Object)this.myContext.getVersion().getVersion()) + " - Can not encode a structure for version " + (Object)((Object)theResource.getStructureFhirVersionEnum()));
        }
        this.doEncodeResourceToWriter(theResource, theWriter);
    }

    private void filterCodingsWithNoCodeOrSystem(List<? extends IBaseCoding> tagList) {
        for (int i = 0; i < tagList.size(); ++i) {
            if (!StringUtils.isBlank((CharSequence)tagList.get(i).getCode()) || !StringUtils.isBlank((CharSequence)tagList.get(i).getSystem())) continue;
            tagList.remove(i);
            --i;
        }
    }

    protected IIdType fixContainedResourceId(String theValue) {
        IIdType retVal = (IIdType)this.myContext.getElementDefinition("id").newInstance();
        if (StringUtils.isNotBlank((CharSequence)theValue) && theValue.charAt(0) == '#') {
            retVal.setValue(theValue.substring(1));
        } else {
            retVal.setValue(theValue);
        }
        return retVal;
    }

    ChildNameAndDef getChildNameAndDef(BaseRuntimeChildDefinition theChild, IBase theValue) {
        Class<?> type = theValue.getClass();
        String childName = theChild.getChildNameByDatatype(type);
        BaseRuntimeElementDefinition<?> childDef = theChild.getChildElementDefinitionByDatatype(type);
        if (childDef == null) {
            BaseRuntimeElementDefinition<?> elementDef = this.myContext.getElementDefinition(type);
            if (elementDef.getName().equals("code")) {
                Class<?> type2 = this.myContext.getElementDefinition("code").getImplementingClass();
                childDef = theChild.getChildElementDefinitionByDatatype(type2);
                childName = theChild.getChildNameByDatatype(type2);
            }
            if (childDef == null) {
                Class<?> nextSuperType = theValue.getClass();
                while (IBase.class.isAssignableFrom(nextSuperType) && childDef == null) {
                    if (!Modifier.isAbstract(nextSuperType.getModifiers())) {
                        BaseRuntimeElementDefinition<?> def = this.myContext.getElementDefinition(nextSuperType);
                        Class<?> nextChildType = def.getImplementingClass();
                        childDef = theChild.getChildElementDefinitionByDatatype(nextChildType);
                        childName = theChild.getChildNameByDatatype(nextChildType);
                    }
                    nextSuperType = nextSuperType.getSuperclass();
                }
            }
            if (childDef == null) {
                this.throwExceptionForUnknownChildType(theChild, type);
            }
        }
        return new ChildNameAndDef(childName, childDef);
    }

    protected String getCompositeElementId(IBase theElement) {
        String elementId = null;
        if (!(theElement instanceof IBaseResource)) {
            if (theElement instanceof IBaseElement) {
                elementId = ((IBaseElement)((Object)theElement)).getId();
            } else if (theElement instanceof IIdentifiableElement) {
                elementId = ((IIdentifiableElement)theElement).getElementSpecificId();
            }
        }
        return elementId;
    }

    ContainedResources getContainedResources() {
        return this.myContainedResources;
    }

    @Override
    public Set<String> getDontStripVersionsFromReferencesAtPaths() {
        return this.myDontStripVersionsFromReferencesAtPaths;
    }

    @Override
    public Set<String> getEncodeElements() {
        return this.myEncodeElements;
    }

    @Override
    public void setEncodeElements(Set<String> theEncodeElements) {
        this.myEncodeElementsIncludesStars = false;
        if (theEncodeElements == null || theEncodeElements.isEmpty()) {
            this.myEncodeElements = null;
        } else {
            this.myEncodeElements = theEncodeElements;
            for (String next : theEncodeElements) {
                if (!next.startsWith("*.")) continue;
                this.myEncodeElementsIncludesStars = true;
            }
        }
    }

    @Override
    public Set<String> getEncodeElementsAppliesToResourceTypes() {
        return this.myEncodeElementsAppliesToResourceTypes;
    }

    @Override
    public void setEncodeElementsAppliesToResourceTypes(Set<String> theEncodeElementsAppliesToResourceTypes) {
        this.myEncodeElementsAppliesToResourceTypes = theEncodeElementsAppliesToResourceTypes == null || theEncodeElementsAppliesToResourceTypes.isEmpty() ? null : theEncodeElementsAppliesToResourceTypes;
    }

    @Override
    public IIdType getEncodeForceResourceId() {
        return this.myEncodeForceResourceId;
    }

    @Override
    public BaseParser setEncodeForceResourceId(IIdType theEncodeForceResourceId) {
        this.myEncodeForceResourceId = theEncodeForceResourceId;
        return this;
    }

    protected IParserErrorHandler getErrorHandler() {
        return this.myErrorHandler;
    }

    protected List<Map.Entry<ResourceMetadataKeyEnum<?>, Object>> getExtensionMetadataKeys(IResource resource) {
        ArrayList extensionMetadataKeys = new ArrayList();
        for (Map.Entry entry : resource.getResourceMetadata().entrySet()) {
            if (!(entry.getKey() instanceof ResourceMetadataKeyEnum.ExtensionResourceMetadataKey)) continue;
            extensionMetadataKeys.add(entry);
        }
        return extensionMetadataKeys;
    }

    protected String getExtensionUrl(String extensionUrl) {
        String url = extensionUrl;
        if (StringUtils.isNotBlank((CharSequence)extensionUrl) && StringUtils.isNotBlank((CharSequence)this.myServerBaseUrl)) {
            url = !UrlUtil.isValid(extensionUrl) && extensionUrl.startsWith("/") ? this.myServerBaseUrl + extensionUrl : extensionUrl;
        }
        return url;
    }

    protected TagList getMetaTagsForEncoding(IResource theIResource) {
        TagList tags = ResourceMetadataKeyEnum.TAG_LIST.get(theIResource);
        if (this.shouldAddSubsettedTag()) {
            tags = new TagList(tags);
            tags.add(new Tag(this.getSubsettedCodeSystem(), "SUBSETTED", this.subsetDescription()));
        }
        return tags;
    }

    @Override
    public Boolean getOverrideResourceIdWithBundleEntryFullUrl() {
        return this.myOverrideResourceIdWithBundleEntryFullUrl;
    }

    @Override
    public List<Class<? extends IBaseResource>> getPreferTypes() {
        return this.myPreferTypes;
    }

    @Override
    public void setPreferTypes(List<Class<? extends IBaseResource>> thePreferTypes) {
        if (thePreferTypes != null) {
            ArrayList<Class<? extends IBaseResource>> types = new ArrayList<Class<? extends IBaseResource>>();
            for (Class<? extends IBaseResource> next : thePreferTypes) {
                if (Modifier.isAbstract(next.getModifiers())) continue;
                types.add(next);
            }
            this.myPreferTypes = Collections.unmodifiableList(types);
        } else {
            this.myPreferTypes = thePreferTypes;
        }
    }

    protected <T extends IPrimitiveType<String>> List<T> getProfileTagsForEncoding(IBaseResource theResource, List<T> theProfiles) {
        switch (this.myContext.getAddProfileTagWhenEncoding()) {
            case NEVER: {
                return theProfiles;
            }
            case ONLY_FOR_CUSTOM: {
                RuntimeResourceDefinition resDef = this.myContext.getResourceDefinition(theResource);
                if (!resDef.isStandardType()) break;
                return theProfiles;
            }
        }
        RuntimeResourceDefinition nextDef = this.myContext.getResourceDefinition(theResource);
        String profile = nextDef.getResourceProfile(this.myServerBaseUrl);
        if (StringUtils.isNotBlank((CharSequence)profile)) {
            for (IPrimitiveType next : theProfiles) {
                if (!profile.equals(next.getValue())) continue;
                return theProfiles;
            }
            ArrayList<T> newList = new ArrayList<T>(theProfiles);
            BaseRuntimeElementDefinition<?> idElement = this.myContext.getElementDefinition("id");
            IPrimitiveType newId = (IPrimitiveType)idElement.newInstance();
            newId.setValue(profile);
            newList.add(newId);
            return newList;
        }
        return theProfiles;
    }

    protected String getServerBaseUrl() {
        return this.myServerBaseUrl;
    }

    @Override
    public Boolean getStripVersionsFromReferences() {
        return this.myStripVersionsFromReferences;
    }

    @Deprecated
    public boolean getSuppressNarratives() {
        return this.mySuppressNarratives;
    }

    protected boolean isChildContained(BaseRuntimeElementDefinition<?> childDef, boolean theIncludedResource) {
        return (childDef.getChildType() == BaseRuntimeElementDefinition.ChildTypeEnum.CONTAINED_RESOURCES || childDef.getChildType() == BaseRuntimeElementDefinition.ChildTypeEnum.CONTAINED_RESOURCE_LIST) && !this.getContainedResources().isEmpty() && !theIncludedResource;
    }

    @Override
    public boolean isEncodeElementsAppliesToChildResourcesOnly() {
        return this.myEncodeElementsAppliesToChildResourcesOnly;
    }

    @Override
    public void setEncodeElementsAppliesToChildResourcesOnly(boolean theEncodeElementsAppliesToChildResourcesOnly) {
        this.myEncodeElementsAppliesToChildResourcesOnly = theEncodeElementsAppliesToChildResourcesOnly;
    }

    @Override
    public boolean isOmitResourceId() {
        return this.myOmitResourceId;
    }

    private boolean isOverrideResourceIdWithBundleEntryFullUrl() {
        Boolean overrideResourceIdWithBundleEntryFullUrl = this.myOverrideResourceIdWithBundleEntryFullUrl;
        if (overrideResourceIdWithBundleEntryFullUrl != null) {
            return overrideResourceIdWithBundleEntryFullUrl;
        }
        return this.myContext.getParserOptions().isOverrideResourceIdWithBundleEntryFullUrl();
    }

    private boolean isStripVersionsFromReferences(CompositeChildElement theCompositeChildElement) {
        Boolean stripVersionsFromReferences = this.myStripVersionsFromReferences;
        if (stripVersionsFromReferences != null) {
            return stripVersionsFromReferences;
        }
        if (!this.myContext.getParserOptions().isStripVersionsFromReferences()) {
            return false;
        }
        Set<String> dontStripVersionsFromReferencesAtPaths = this.myDontStripVersionsFromReferencesAtPaths;
        if (dontStripVersionsFromReferencesAtPaths != null && !dontStripVersionsFromReferencesAtPaths.isEmpty() && theCompositeChildElement.anyPathMatches(dontStripVersionsFromReferencesAtPaths)) {
            return false;
        }
        dontStripVersionsFromReferencesAtPaths = this.myContext.getParserOptions().getDontStripVersionsFromReferencesAtPaths();
        return dontStripVersionsFromReferencesAtPaths.isEmpty() || !theCompositeChildElement.anyPathMatches(dontStripVersionsFromReferencesAtPaths);
    }

    @Override
    public boolean isSummaryMode() {
        return this.mySummaryMode;
    }

    public boolean isSuppressNarratives() {
        return this.mySuppressNarratives;
    }

    @Override
    public <T extends IBaseResource> T parseResource(Class<T> theResourceType, Reader theReader) throws DataFormatException {
        T retVal;
        RuntimeResourceDefinition def;
        if (theResourceType != null) {
            this.myContext.getResourceDefinition(theResourceType);
        }
        if ("Bundle".equals((def = this.myContext.getResourceDefinition((IBaseResource)(retVal = this.doParseResource(theResourceType, theReader)))).getName())) {
            BaseRuntimeChildDefinition entryChild = def.getChildByName("entry");
            BaseRuntimeElementCompositeDefinition entryDef = (BaseRuntimeElementCompositeDefinition)entryChild.getChildByName("entry");
            List<IBase> entries = entryChild.getAccessor().getValues(retVal);
            if (entries != null) {
                for (IBase nextEntry : entries) {
                    List<IBase> entryResources;
                    IPrimitiveType value;
                    List<IBase> fullUrl;
                    BaseRuntimeChildDefinition fullUrlChild = entryDef.getChildByName("fullUrl");
                    if (fullUrlChild == null || !this.isOverrideResourceIdWithBundleEntryFullUrl() || (fullUrl = fullUrlChild.getAccessor().getValues(nextEntry)) == null || fullUrl.isEmpty() || (value = (IPrimitiveType)fullUrl.get(0)).isEmpty() || (entryResources = entryDef.getChildByName("resource").getAccessor().getValues(nextEntry)) == null || entryResources.size() <= 0) continue;
                    IBaseResource res = (IBaseResource)entryResources.get(0);
                    String versionId = res.getIdElement().getVersionIdPart();
                    res.setId(value.getValueAsString());
                    if (!StringUtils.isNotBlank((CharSequence)versionId) || res.getIdElement().hasVersionIdPart()) continue;
                    res.setId(res.getIdElement().withVersion(versionId));
                }
            }
        }
        return retVal;
    }

    @Override
    public <T extends IBaseResource> T parseResource(Class<T> theResourceType, String theMessageString) {
        StringReader reader = new StringReader(theMessageString);
        return this.parseResource(theResourceType, reader);
    }

    @Override
    public IBaseResource parseResource(Reader theReader) throws ConfigurationException, DataFormatException {
        return this.parseResource(null, theReader);
    }

    @Override
    public IBaseResource parseResource(String theMessageString) throws ConfigurationException, DataFormatException {
        return this.parseResource(null, theMessageString);
    }

    protected List<? extends IBase> preProcessValues(BaseRuntimeChildDefinition theMetaChildUncast, IBaseResource theResource, List<? extends IBase> theValues, CompositeChildElement theCompositeChildElement) {
        if (this.myContext.getVersion().getVersion().isRi()) {
            BaseRuntimeElementDefinition<?> metaChild;
            if (theValues.isEmpty() && theMetaChildUncast.getElementName().equals("meta") && IBaseMetaType.class.isAssignableFrom((metaChild = theMetaChildUncast.getChildByName("meta")).getImplementingClass())) {
                IBaseMetaType newType = (IBaseMetaType)metaChild.newInstance();
                theValues = Collections.singletonList(newType);
            }
            if (theValues.size() == 1 && theValues.get(0) instanceof IBaseMetaType) {
                IBaseMetaType metaValue = (IBaseMetaType)theValues.get(0);
                try {
                    metaValue = (IBaseMetaType)metaValue.getClass().getMethod("copy", new Class[0]).invoke((Object)metaValue, new Object[0]);
                }
                catch (Exception e) {
                    throw new InternalErrorException("Failed to duplicate meta", (Throwable)e);
                }
                if (StringUtils.isBlank((CharSequence)metaValue.getVersionId()) && theResource.getIdElement().hasVersionIdPart()) {
                    metaValue.setVersionId(theResource.getIdElement().getVersionIdPart());
                }
                this.filterCodingsWithNoCodeOrSystem(metaValue.getTag());
                this.filterCodingsWithNoCodeOrSystem(metaValue.getSecurity());
                List<? extends IPrimitiveType<String>> newProfileList = this.getProfileTagsForEncoding(theResource, metaValue.getProfile());
                List<? extends IPrimitiveType<String>> oldProfileList = metaValue.getProfile();
                if (oldProfileList != newProfileList) {
                    oldProfileList.clear();
                    for (IPrimitiveType<String> iPrimitiveType : newProfileList) {
                        if (!StringUtils.isNotBlank((CharSequence)iPrimitiveType.getValue())) continue;
                        metaValue.addProfile(iPrimitiveType.getValue());
                    }
                }
                if (this.shouldAddSubsettedTag()) {
                    IBaseCoding coding = metaValue.addTag();
                    coding.setCode("SUBSETTED");
                    coding.setSystem(this.getSubsettedCodeSystem());
                    coding.setDisplay(this.subsetDescription());
                }
                return Collections.singletonList(metaValue);
            }
        }
        List<? extends IBase> retVal = theValues;
        for (int i = 0; i < retVal.size(); ++i) {
            IBaseReference nextRef;
            String string;
            IBase next = retVal.get(i);
            if (!(next instanceof IBaseReference) || StringUtils.equals((CharSequence)(string = this.determineReferenceText(nextRef = (IBaseReference)next, theCompositeChildElement)), (CharSequence)nextRef.getReferenceElement().getValue())) continue;
            if (retVal == theValues) {
                retVal = new ArrayList<IBase>(theValues);
            }
            IBaseReference newRef = (IBaseReference)this.myContext.getElementDefinition(nextRef.getClass()).newInstance();
            this.myContext.newTerser().cloneInto(nextRef, newRef, true);
            newRef.setReference(string);
            retVal.set(i, newRef);
        }
        return retVal;
    }

    private String getSubsettedCodeSystem() {
        if (this.myContext.getVersion().getVersion().isEqualOrNewerThan(FhirVersionEnum.R4)) {
            return "http://terminology.hl7.org/CodeSystem/v3-ObservationValue";
        }
        return "http://hl7.org/fhir/v3/ObservationValue";
    }

    @Override
    public void setDontEncodeElements(Set<String> theDontEncodeElements) {
        this.myDontEncodeElementsIncludesStars = false;
        if (theDontEncodeElements == null || theDontEncodeElements.isEmpty()) {
            this.myDontEncodeElements = null;
        } else {
            this.myDontEncodeElements = theDontEncodeElements;
            for (String next : theDontEncodeElements) {
                if (!next.startsWith("*.")) continue;
                this.myDontEncodeElementsIncludesStars = true;
            }
        }
    }

    @Override
    public IParser setDontStripVersionsFromReferencesAtPaths(String ... thePaths) {
        if (thePaths == null) {
            this.setDontStripVersionsFromReferencesAtPaths((Collection<String>)null);
        } else {
            this.setDontStripVersionsFromReferencesAtPaths(Arrays.asList(thePaths));
        }
        return this;
    }

    @Override
    public IParser setDontStripVersionsFromReferencesAtPaths(Collection<String> thePaths) {
        this.myDontStripVersionsFromReferencesAtPaths = thePaths == null ? Collections.emptySet() : (thePaths instanceof HashSet ? (Set<Object>)((HashSet)thePaths).clone() : new HashSet<String>(thePaths));
        return this;
    }

    @Override
    public IParser setOmitResourceId(boolean theOmitResourceId) {
        this.myOmitResourceId = theOmitResourceId;
        return this;
    }

    @Override
    public IParser setOverrideResourceIdWithBundleEntryFullUrl(Boolean theOverrideResourceIdWithBundleEntryFullUrl) {
        this.myOverrideResourceIdWithBundleEntryFullUrl = theOverrideResourceIdWithBundleEntryFullUrl;
        return this;
    }

    @Override
    public IParser setParserErrorHandler(IParserErrorHandler theErrorHandler) {
        Validate.notNull((Object)theErrorHandler, (String)"theErrorHandler must not be null", (Object[])new Object[0]);
        this.myErrorHandler = theErrorHandler;
        return this;
    }

    @Override
    public IParser setServerBaseUrl(String theUrl) {
        this.myServerBaseUrl = StringUtils.isNotBlank((CharSequence)theUrl) ? theUrl : null;
        return this;
    }

    @Override
    public IParser setStripVersionsFromReferences(Boolean theStripVersionsFromReferences) {
        this.myStripVersionsFromReferences = theStripVersionsFromReferences;
        return this;
    }

    @Override
    public IParser setSummaryMode(boolean theSummaryMode) {
        this.mySummaryMode = theSummaryMode;
        return this;
    }

    @Override
    public IParser setSuppressNarratives(boolean theSuppressNarratives) {
        this.mySuppressNarratives = theSuppressNarratives;
        return this;
    }

    protected boolean shouldAddSubsettedTag() {
        return this.isSummaryMode() || this.isSuppressNarratives() || this.getEncodeElements() != null;
    }

    protected boolean shouldEncodeResourceId(IBaseResource theResource, boolean theSubResource) {
        boolean retVal = true;
        if (this.isOmitResourceId()) {
            retVal = false;
        } else if (this.myDontEncodeElements != null) {
            String resourceName = this.myContext.getResourceDefinition(theResource).getName();
            if (this.myDontEncodeElements.contains(resourceName + ".id")) {
                retVal = false;
            } else if (this.myDontEncodeElements.contains("*.id")) {
                retVal = false;
            } else if (!theSubResource && this.myDontEncodeElements.contains("id")) {
                retVal = false;
            }
        }
        return retVal;
    }

    protected boolean shouldEncodeResourceMeta(IResource theResource) {
        if (this.myDontEncodeElements != null) {
            String resourceName = this.myContext.getResourceDefinition(theResource).getName();
            if (this.myDontEncodeElements.contains(resourceName + ".meta")) {
                return false;
            }
            return !this.myDontEncodeElements.contains("*.meta");
        }
        return true;
    }

    private String subsetDescription() {
        return "Resource encoded in summary mode";
    }

    protected void throwExceptionForUnknownChildType(BaseRuntimeChildDefinition nextChild, Class<? extends IBase> theType) {
        if (nextChild instanceof BaseRuntimeDeclaredChildDefinition) {
            StringBuilder b = new StringBuilder();
            b.append(nextChild.getElementName());
            b.append(" has type ");
            b.append(theType.getName());
            b.append(" but this is not a valid type for this element");
            if (nextChild instanceof RuntimeChildChoiceDefinition) {
                RuntimeChildChoiceDefinition choice = (RuntimeChildChoiceDefinition)nextChild;
                b.append(" - Expected one of: " + choice.getValidChildTypes());
            }
            throw new DataFormatException(b.toString());
        }
        throw new DataFormatException(nextChild + " has no child of type " + theType);
    }

    protected static <T> List<T> extractMetadataListNotNull(IResource resource, ResourceMetadataKeyEnum<List<T>> key) {
        List<T> securityLabels = key.get(resource);
        if (securityLabels == null) {
            securityLabels = Collections.emptyList();
        }
        return new ArrayList<T>(securityLabels);
    }

    static boolean hasExtensions(IBase theElement) {
        Object res;
        if (theElement instanceof ISupportsUndeclaredExtensions && ((res = (ISupportsUndeclaredExtensions)theElement).getUndeclaredExtensions().size() > 0 || res.getUndeclaredModifierExtensions().size() > 0)) {
            return true;
        }
        if (theElement instanceof IBaseHasExtensions && (res = (IBaseHasExtensions)((Object)theElement)).hasExtension()) {
            return true;
        }
        if (theElement instanceof IBaseHasModifierExtensions) {
            res = (IBaseHasModifierExtensions)((Object)theElement);
            return res.hasModifierExtension();
        }
        return false;
    }

    static class ContainedResources {
        private long myNextContainedId = 1L;
        private List<IBaseResource> myResourceList;
        private IdentityHashMap<IBaseResource, IIdType> myResourceToIdMap;
        private Map<String, IBaseResource> myExistingIdToContainedResourceMap;

        ContainedResources() {
        }

        public Map<String, IBaseResource> getExistingIdToContainedResource() {
            if (this.myExistingIdToContainedResourceMap == null) {
                this.myExistingIdToContainedResourceMap = new HashMap<String, IBaseResource>();
            }
            return this.myExistingIdToContainedResourceMap;
        }

        public void addContained(IBaseResource theResource) {
            if (this.getResourceToIdMap().containsKey(theResource)) {
                return;
            }
            IIdType newId = theResource.getIdElement().isLocal() ? theResource.getIdElement() : null;
            this.getResourceToIdMap().put(theResource, newId);
            this.getResourceList().add(theResource);
        }

        public void addContained(IIdType theId, IBaseResource theResource) {
            if (!this.getResourceToIdMap().containsKey(theResource)) {
                this.getResourceToIdMap().put(theResource, theId);
                this.getResourceList().add(theResource);
            }
        }

        public List<IBaseResource> getContainedResources() {
            if (this.getResourceToIdMap() == null) {
                return Collections.emptyList();
            }
            return this.getResourceList();
        }

        public IIdType getResourceId(IBaseResource theNext) {
            if (this.getResourceToIdMap() == null) {
                return null;
            }
            return this.getResourceToIdMap().get(theNext);
        }

        private List<IBaseResource> getResourceList() {
            if (this.myResourceList == null) {
                this.myResourceList = new ArrayList<IBaseResource>();
            }
            return this.myResourceList;
        }

        private IdentityHashMap<IBaseResource, IIdType> getResourceToIdMap() {
            if (this.myResourceToIdMap == null) {
                this.myResourceToIdMap = new IdentityHashMap();
            }
            return this.myResourceToIdMap;
        }

        public boolean isEmpty() {
            if (this.myResourceToIdMap == null) {
                return true;
            }
            return this.myResourceToIdMap.isEmpty();
        }

        public boolean hasExistingIdToContainedResource() {
            return this.myExistingIdToContainedResourceMap != null;
        }

        public void assignIdsToContainedResources() {
            if (this.getResourceList() != null) {
                HashSet<String> ids = new HashSet<String>();
                for (IBaseResource nextResource : this.getResourceList()) {
                    if (this.getResourceToIdMap().get(nextResource) == null) continue;
                    ids.add(this.getResourceToIdMap().get(nextResource).getValue());
                }
                for (IBaseResource nextResource : this.getResourceList()) {
                    while (this.getResourceToIdMap().get(nextResource) == null) {
                        String nextCandidate = "#" + this.myNextContainedId;
                        ++this.myNextContainedId;
                        if (!ids.add(nextCandidate)) continue;
                        this.getResourceToIdMap().put(nextResource, new IdDt(nextCandidate));
                    }
                }
            }
        }
    }

    protected class CompositeChildElement {
        private final BaseRuntimeChildDefinition myDef;
        private final CompositeChildElement myParent;
        private final RuntimeResourceDefinition myResDef;
        private final boolean mySubResource;

        public CompositeChildElement(CompositeChildElement theParent, BaseRuntimeChildDefinition theDef, boolean theSubResource) {
            StringBuilder path;
            this.myDef = theDef;
            this.myParent = theParent;
            this.myResDef = null;
            this.mySubResource = theSubResource;
            if (ourLog.isTraceEnabled() && theParent != null && (path = theParent.buildPath()) != null) {
                path.append('.');
                path.append(this.myDef.getElementName());
                ourLog.trace(" * Next path: {}", (Object)path.toString());
            }
        }

        public CompositeChildElement(RuntimeResourceDefinition theResDef, boolean theSubResource) {
            this.myResDef = theResDef;
            this.myDef = null;
            this.myParent = null;
            this.mySubResource = theSubResource;
        }

        private void addParent(CompositeChildElement theParent, StringBuilder theB) {
            if (theParent != null) {
                if (theParent.myResDef != null) {
                    theB.append(theParent.myResDef.getName());
                    return;
                }
                if (theParent.myParent != null) {
                    this.addParent(theParent.myParent, theB);
                }
                if (theParent.myDef != null) {
                    if (theB.length() > 0) {
                        theB.append('.');
                    }
                    theB.append(theParent.myDef.getElementName());
                }
            }
        }

        public boolean anyPathMatches(Set<String> thePaths) {
            StringBuilder b = new StringBuilder();
            this.addParent(this, b);
            String path = b.toString();
            return thePaths.contains(path);
        }

        private StringBuilder buildPath() {
            if (this.myResDef != null) {
                StringBuilder b = new StringBuilder();
                b.append(this.myResDef.getName());
                return b;
            }
            if (this.myParent != null) {
                StringBuilder b = this.myParent.buildPath();
                if (b != null && this.myDef != null) {
                    b.append('.');
                    b.append(this.myDef.getElementName());
                }
                return b;
            }
            return null;
        }

        private boolean checkIfParentShouldBeEncodedAndBuildPath(StringBuilder thePathBuilder, boolean theStarPass) {
            Set encodeElements = BaseParser.this.myEncodeElements;
            if (encodeElements != null && !encodeElements.isEmpty() && BaseParser.this.isEncodeElementsAppliesToChildResourcesOnly() && !this.mySubResource) {
                encodeElements = null;
            }
            return this.checkIfPathMatchesForEncoding(thePathBuilder, theStarPass, BaseParser.this.myEncodeElementsAppliesToResourceTypes, encodeElements, true);
        }

        private boolean checkIfParentShouldNotBeEncodedAndBuildPath(StringBuilder thePathBuilder, boolean theStarPass) {
            return this.checkIfPathMatchesForEncoding(thePathBuilder, theStarPass, null, BaseParser.this.myDontEncodeElements, false);
        }

        private boolean checkIfPathMatchesForEncoding(StringBuilder thePathBuilder, boolean theStarPass, Set<String> theResourceTypes, Set<String> theElements, boolean theCheckingForWhitelist) {
            if (this.myResDef != null) {
                if (theResourceTypes != null && !theResourceTypes.contains(this.myResDef.getName())) {
                    return true;
                }
                if (theStarPass) {
                    thePathBuilder.append('*');
                } else {
                    thePathBuilder.append(this.myResDef.getName());
                }
                if (theElements == null) {
                    return true;
                }
                return theElements.contains(thePathBuilder.toString());
            }
            if (this.myParent != null) {
                boolean parentCheck = theCheckingForWhitelist ? this.myParent.checkIfParentShouldBeEncodedAndBuildPath(thePathBuilder, theStarPass) : this.myParent.checkIfParentShouldNotBeEncodedAndBuildPath(thePathBuilder, theStarPass);
                if (parentCheck) {
                    return true;
                }
                if (this.myDef != null) {
                    if (this.myDef.getMin() > 0 && theElements.contains("*.(mandatory)")) {
                        return true;
                    }
                    thePathBuilder.append('.');
                    thePathBuilder.append(this.myDef.getElementName());
                    String currentPath = thePathBuilder.toString();
                    boolean retVal = theElements.contains(currentPath);
                    int dotIdx = currentPath.indexOf(46);
                    if (!retVal && dotIdx != -1 && theElements.contains(currentPath.substring(dotIdx + 1)) && !this.myParent.isSubResource()) {
                        return true;
                    }
                    return retVal;
                }
            }
            return false;
        }

        public BaseRuntimeChildDefinition getDef() {
            return this.myDef;
        }

        public CompositeChildElement getParent() {
            return this.myParent;
        }

        public RuntimeResourceDefinition getResDef() {
            return this.myResDef;
        }

        private boolean isSubResource() {
            return this.mySubResource;
        }

        public boolean shouldBeEncoded() {
            boolean retVal = true;
            if (BaseParser.this.myEncodeElements != null && !(retVal = this.checkIfParentShouldBeEncodedAndBuildPath(new StringBuilder(), false)) && BaseParser.this.myEncodeElementsIncludesStars) {
                retVal = this.checkIfParentShouldBeEncodedAndBuildPath(new StringBuilder(), true);
            }
            if (retVal && BaseParser.this.myDontEncodeElements != null) {
                boolean bl = retVal = !this.checkIfParentShouldNotBeEncodedAndBuildPath(new StringBuilder(), false);
                if (retVal && BaseParser.this.myDontEncodeElementsIncludesStars) {
                    retVal = !this.checkIfParentShouldNotBeEncodedAndBuildPath(new StringBuilder(), true);
                }
            }
            return retVal;
        }
    }

    class ChildNameAndDef {
        private final BaseRuntimeElementDefinition<?> myChildDef;
        private final String myChildName;

        public ChildNameAndDef(String theChildName, BaseRuntimeElementDefinition<?> theChildDef) {
            this.myChildName = theChildName;
            this.myChildDef = theChildDef;
        }

        public BaseRuntimeElementDefinition<?> getChildDef() {
            return this.myChildDef;
        }

        public String getChildName() {
            return this.myChildName;
        }
    }
}

