/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param;

import java.util.Set;

public class QualifierDetails {
    private String myColonQualifier;
    private String myDotQualifier;
    private String myParamName;
    private String myWholeQualifier;

    public boolean passes(Set<String> theQualifierWhitelist, Set<String> theQualifierBlacklist) {
        if (theQualifierWhitelist != null && !theQualifierWhitelist.contains(".*") && (this.myDotQualifier != null ? !theQualifierWhitelist.contains(this.myDotQualifier) : !theQualifierWhitelist.contains("."))) {
            return false;
        }
        if (theQualifierBlacklist != null) {
            if (this.myDotQualifier != null && theQualifierBlacklist.contains(this.myDotQualifier)) {
                return false;
            }
            if (this.myColonQualifier != null && theQualifierBlacklist.contains(this.myColonQualifier)) {
                return false;
            }
        }
        return true;
    }

    public void setParamName(String theParamName) {
        this.myParamName = theParamName;
    }

    public String getParamName() {
        return this.myParamName;
    }

    public void setColonQualifier(String theColonQualifier) {
        this.myColonQualifier = theColonQualifier;
    }

    public void setDotQualifier(String theDotQualifier) {
        this.myDotQualifier = theDotQualifier;
    }

    public String getWholeQualifier() {
        return this.myWholeQualifier;
    }

    public void setWholeQualifier(String theWholeQualifier) {
        this.myWholeQualifier = theWholeQualifier;
    }

    public static QualifierDetails extractQualifiersFromParameterName(String theParamName) {
        QualifierDetails retVal = new QualifierDetails();
        if (theParamName == null || theParamName.length() == 0) {
            return retVal;
        }
        int dotIdx = -1;
        int colonIdx = -1;
        for (int idx = 0; idx < theParamName.length(); ++idx) {
            char nextChar = theParamName.charAt(idx);
            if (nextChar == '.' && dotIdx == -1) {
                dotIdx = idx;
                continue;
            }
            if (nextChar != ':' || colonIdx != -1) continue;
            colonIdx = idx;
        }
        if (dotIdx != -1 && colonIdx != -1) {
            if (dotIdx < colonIdx) {
                retVal.setDotQualifier(theParamName.substring(dotIdx, colonIdx));
                retVal.setColonQualifier(theParamName.substring(colonIdx));
                retVal.setParamName(theParamName.substring(0, dotIdx));
                retVal.setWholeQualifier(theParamName.substring(dotIdx));
            } else {
                retVal.setColonQualifier(theParamName.substring(colonIdx, dotIdx));
                retVal.setDotQualifier(theParamName.substring(dotIdx));
                retVal.setParamName(theParamName.substring(0, colonIdx));
                retVal.setWholeQualifier(theParamName.substring(colonIdx));
            }
        } else if (dotIdx != -1) {
            retVal.setDotQualifier(theParamName.substring(dotIdx));
            retVal.setParamName(theParamName.substring(0, dotIdx));
            retVal.setWholeQualifier(theParamName.substring(dotIdx));
        } else if (colonIdx != -1) {
            retVal.setColonQualifier(theParamName.substring(colonIdx));
            retVal.setParamName(theParamName.substring(0, colonIdx));
            retVal.setWholeQualifier(theParamName.substring(colonIdx));
        } else {
            retVal.setParamName(theParamName);
            retVal.setColonQualifier(null);
            retVal.setDotQualifier(null);
            retVal.setWholeQualifier(null);
        }
        return retVal;
    }
}

