/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.narrative;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.narrative2.NarrativeTemplateManifest;
import ca.uhn.fhir.narrative2.ThymeleafNarrativeGenerator;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.io.IOException;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseResource;

public abstract class BaseThymeleafNarrativeGenerator
extends ThymeleafNarrativeGenerator {
    private boolean myInitialized;

    protected BaseThymeleafNarrativeGenerator() {
    }

    @Override
    public boolean populateResourceNarrative(FhirContext theFhirContext, IBaseResource theResource) {
        if (!this.myInitialized) {
            this.initialize();
        }
        super.populateResourceNarrative(theFhirContext, theResource);
        return false;
    }

    protected abstract List<String> getPropertyFile();

    private synchronized void initialize() {
        if (this.myInitialized) {
            return;
        }
        List<String> propFileName = this.getPropertyFile();
        try {
            NarrativeTemplateManifest manifest = NarrativeTemplateManifest.forManifestFileLocation(propFileName);
            this.setManifest(manifest);
        }
        catch (IOException e) {
            throw new InternalErrorException(e);
        }
        this.myInitialized = true;
    }
}

