/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context.support;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.util.BundleUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProfileValidationSupport
implements IValidationSupport {
    private static final String URL_PREFIX_STRUCTURE_DEFINITION = "http://hl7.org/fhir/StructureDefinition/";
    private static final String URL_PREFIX_STRUCTURE_DEFINITION_BASE = "http://hl7.org/fhir/";
    private static final Logger ourLog = LoggerFactory.getLogger(DefaultProfileValidationSupport.class);
    private final FhirContext myCtx;
    private Map<String, IBaseResource> myCodeSystems;
    private Map<String, IBaseResource> myStructureDefinitions;
    private Map<String, IBaseResource> myValueSets;
    private List<String> myTerminologyResources;
    private List<String> myStructureDefinitionResources;

    public DefaultProfileValidationSupport(FhirContext theFhirContext) {
        this.myCtx = theFhirContext;
    }

    private void initializeResourceLists() {
        if (this.myTerminologyResources != null && this.myStructureDefinitionResources != null) {
            return;
        }
        ArrayList<String> terminologyResources = new ArrayList<String>();
        ArrayList<String> structureDefinitionResources = new ArrayList<String>();
        switch (this.getFhirContext().getVersion().getVersion()) {
            case DSTU2: 
            case DSTU2_HL7ORG: {
                terminologyResources.add("/org/hl7/fhir/instance/model/valueset/valuesets.xml");
                terminologyResources.add("/org/hl7/fhir/instance/model/valueset/v2-tables.xml");
                terminologyResources.add("/org/hl7/fhir/instance/model/valueset/v3-codesystems.xml");
                Properties profileNameProperties = new Properties();
                try {
                    profileNameProperties.load(DefaultProfileValidationSupport.class.getResourceAsStream("/org/hl7/fhir/instance/model/profile/profiles.properties"));
                    for (Object nextKey : profileNameProperties.keySet()) {
                        structureDefinitionResources.add("/org/hl7/fhir/instance/model/profile/" + nextKey);
                    }
                    break;
                }
                catch (IOException e) {
                    throw new ConfigurationException(e);
                }
            }
            case DSTU2_1: {
                terminologyResources.add("/org/hl7/fhir/dstu2016may/model/valueset/valuesets.xml");
                terminologyResources.add("/org/hl7/fhir/dstu2016may/model/valueset/v2-tables.xml");
                terminologyResources.add("/org/hl7/fhir/dstu2016may/model/valueset/v3-codesystems.xml");
                structureDefinitionResources.add("/org/hl7/fhir/dstu2016may/model/profile/profiles-resources.xml");
                structureDefinitionResources.add("/org/hl7/fhir/dstu2016may/model/profile/profiles-types.xml");
                structureDefinitionResources.add("/org/hl7/fhir/dstu2016may/model/profile/profiles-others.xml");
                break;
            }
            case DSTU3: {
                terminologyResources.add("/org/hl7/fhir/dstu3/model/valueset/valuesets.xml");
                terminologyResources.add("/org/hl7/fhir/dstu3/model/valueset/v2-tables.xml");
                terminologyResources.add("/org/hl7/fhir/dstu3/model/valueset/v3-codesystems.xml");
                structureDefinitionResources.add("/org/hl7/fhir/dstu3/model/profile/profiles-resources.xml");
                structureDefinitionResources.add("/org/hl7/fhir/dstu3/model/profile/profiles-types.xml");
                structureDefinitionResources.add("/org/hl7/fhir/dstu3/model/profile/profiles-others.xml");
                structureDefinitionResources.add("/org/hl7/fhir/dstu3/model/extension/extension-definitions.xml");
                break;
            }
            case R4: {
                terminologyResources.add("/org/hl7/fhir/r4/model/valueset/valuesets.xml");
                terminologyResources.add("/org/hl7/fhir/r4/model/valueset/v2-tables.xml");
                terminologyResources.add("/org/hl7/fhir/r4/model/valueset/v3-codesystems.xml");
                structureDefinitionResources.add("/org/hl7/fhir/r4/model/profile/profiles-resources.xml");
                structureDefinitionResources.add("/org/hl7/fhir/r4/model/profile/profiles-types.xml");
                structureDefinitionResources.add("/org/hl7/fhir/r4/model/profile/profiles-others.xml");
                structureDefinitionResources.add("/org/hl7/fhir/r4/model/extension/extension-definitions.xml");
                break;
            }
            case R5: {
                structureDefinitionResources.add("/org/hl7/fhir/r5/model/profile/profiles-resources.xml");
                structureDefinitionResources.add("/org/hl7/fhir/r5/model/profile/profiles-types.xml");
                structureDefinitionResources.add("/org/hl7/fhir/r5/model/profile/profiles-others.xml");
                structureDefinitionResources.add("/org/hl7/fhir/r5/model/extension/extension-definitions.xml");
                terminologyResources.add("/org/hl7/fhir/r5/model/valueset/valuesets.xml");
                terminologyResources.add("/org/hl7/fhir/r5/model/valueset/v2-tables.xml");
                terminologyResources.add("/org/hl7/fhir/r5/model/valueset/v3-codesystems.xml");
            }
        }
        this.myTerminologyResources = terminologyResources;
        this.myStructureDefinitionResources = structureDefinitionResources;
    }

    @Override
    public List<IBaseResource> fetchAllConformanceResources() {
        ArrayList<IBaseResource> retVal = new ArrayList<IBaseResource>();
        retVal.addAll(this.myCodeSystems.values());
        retVal.addAll(this.myStructureDefinitions.values());
        retVal.addAll(this.myValueSets.values());
        return retVal;
    }

    @Override
    public <T extends IBaseResource> List<T> fetchAllStructureDefinitions() {
        return DefaultProfileValidationSupport.toList(this.provideStructureDefinitionMap());
    }

    @Override
    @Nullable
    public <T extends IBaseResource> List<T> fetchAllNonBaseStructureDefinitions() {
        return null;
    }

    @Override
    public IBaseResource fetchCodeSystem(String theSystem) {
        return this.fetchCodeSystemOrValueSet(theSystem, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IBaseResource fetchCodeSystemOrValueSet(String theSystem, boolean codeSystem) {
        DefaultProfileValidationSupport defaultProfileValidationSupport = this;
        synchronized (defaultProfileValidationSupport) {
            String version;
            String system;
            Map<String, IBaseResource> codeSystems = this.myCodeSystems;
            Map<String, IBaseResource> valueSets = this.myValueSets;
            if (codeSystems == null || valueSets == null) {
                codeSystems = new HashMap<String, IBaseResource>();
                valueSets = new HashMap<String, IBaseResource>();
                this.initializeResourceLists();
                for (String next : this.myTerminologyResources) {
                    this.loadCodeSystems(codeSystems, valueSets, next);
                }
                this.myCodeSystems = codeSystems;
                this.myValueSets = valueSets;
            }
            if ((system = theSystem).contains("|") && (version = system.substring(system.indexOf(124) + 1)).matches("^[0-9.]+$")) {
                system = system.substring(0, system.indexOf(124));
            }
            if (codeSystem) {
                return codeSystems.get(system);
            }
            return valueSets.get(system);
        }
    }

    @Override
    public IBaseResource fetchStructureDefinition(String theUrl) {
        String url = theUrl;
        if (!url.startsWith(URL_PREFIX_STRUCTURE_DEFINITION)) {
            if (url.indexOf(47) == -1) {
                url = URL_PREFIX_STRUCTURE_DEFINITION + url;
            } else if (StringUtils.countMatches((CharSequence)url, (char)'/') == 1) {
                url = URL_PREFIX_STRUCTURE_DEFINITION_BASE + url;
            }
        }
        Map<String, IBaseResource> structureDefinitionMap = this.provideStructureDefinitionMap();
        IBaseResource retVal = structureDefinitionMap.get(url);
        return retVal;
    }

    @Override
    public IBaseResource fetchValueSet(String theUrl) {
        IBaseResource retVal = this.fetchCodeSystemOrValueSet(theUrl, false);
        return retVal;
    }

    public void flush() {
        this.myCodeSystems = null;
        this.myStructureDefinitions = null;
    }

    @Override
    public FhirContext getFhirContext() {
        return this.myCtx;
    }

    private Map<String, IBaseResource> provideStructureDefinitionMap() {
        Map<String, IBaseResource> structureDefinitions = this.myStructureDefinitions;
        if (structureDefinitions == null) {
            structureDefinitions = new HashMap<String, IBaseResource>();
            this.initializeResourceLists();
            for (String next : this.myStructureDefinitionResources) {
                this.loadStructureDefinitions(structureDefinitions, next);
            }
            this.myStructureDefinitions = structureDefinitions;
        }
        return structureDefinitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCodeSystems(Map<String, IBaseResource> theCodeSystems, Map<String, IBaseResource> theValueSets, String theClasspath) {
        ourLog.info("Loading CodeSystem/ValueSet from classpath: {}", (Object)theClasspath);
        InputStream inputStream = DefaultProfileValidationSupport.class.getResourceAsStream(theClasspath);
        InputStreamReader reader = null;
        if (inputStream != null) {
            try {
                reader = new InputStreamReader(inputStream, Constants.CHARSET_UTF8);
                List<IBaseResource> resources = this.parseBundle(reader);
                for (IBaseResource next : resources) {
                    RuntimeResourceDefinition nextDef = this.getFhirContext().getResourceDefinition(next);
                    Map<String, IBaseResource> map = null;
                    switch (nextDef.getName()) {
                        case "CodeSystem": {
                            map = theCodeSystems;
                            break;
                        }
                        case "ValueSet": {
                            map = theValueSets;
                        }
                    }
                    if (map == null) continue;
                    String urlValueString = this.getConformanceResourceUrl(next);
                    if (StringUtils.isNotBlank((CharSequence)urlValueString)) {
                        map.put(urlValueString, next);
                    }
                    switch (this.myCtx.getVersion().getVersion()) {
                        case DSTU2: 
                        case DSTU2_HL7ORG: {
                            IPrimitiveType codeSystem = this.myCtx.newTerser().getSingleValueOrNull(next, "ValueSet.codeSystem.system", IPrimitiveType.class);
                            if (codeSystem == null || !StringUtils.isNotBlank((CharSequence)codeSystem.getValueAsString())) break;
                            theCodeSystems.put(codeSystem.getValueAsString(), next);
                            break;
                        }
                    }
                }
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    inputStream.close();
                }
                catch (IOException e) {
                    ourLog.warn("Failure closing stream", (Throwable)e);
                }
            }
        }
        ourLog.warn("Unable to load resource: {}", (Object)theClasspath);
    }

    private void loadStructureDefinitions(Map<String, IBaseResource> theCodeSystems, String theClasspath) {
        block15: {
            ourLog.info("Loading structure definitions from classpath: {}", (Object)theClasspath);
            try (InputStream valuesetText = DefaultProfileValidationSupport.class.getResourceAsStream(theClasspath);){
                if (valuesetText != null) {
                    try (InputStreamReader reader = new InputStreamReader(valuesetText, Constants.CHARSET_UTF8);){
                        List<IBaseResource> resources = this.parseBundle(reader);
                        for (IBaseResource next : resources) {
                            String url;
                            String nextType = this.getFhirContext().getResourceType(next);
                            if (!"StructureDefinition".equals(nextType) || !StringUtils.isNotBlank((CharSequence)(url = this.getConformanceResourceUrl(next)))) continue;
                            theCodeSystems.put(url, next);
                        }
                        break block15;
                    }
                }
                ourLog.warn("Unable to load resource: {}", (Object)theClasspath);
            }
            catch (IOException theE) {
                ourLog.warn("Unable to load resource: {}", (Object)theClasspath);
            }
        }
    }

    private String getConformanceResourceUrl(IBaseResource theResource) {
        return DefaultProfileValidationSupport.getConformanceResourceUrl(this.getFhirContext(), theResource);
    }

    private List<IBaseResource> parseBundle(InputStreamReader theReader) {
        IBaseResource parsedObject = this.getFhirContext().newXmlParser().parseResource(theReader);
        if (parsedObject instanceof IBaseBundle) {
            IBaseBundle bundle = (IBaseBundle)parsedObject;
            return BundleUtil.toListOfResources(this.getFhirContext(), bundle);
        }
        return Collections.singletonList(parsedObject);
    }

    @Nullable
    public static String getConformanceResourceUrl(FhirContext theFhirContext, IBaseResource theResource) {
        String urlValueString = null;
        Optional urlValue = theFhirContext.getResourceDefinition(theResource).getChildByName("url").getAccessor().getFirstValueOrNull(theResource);
        if (urlValue.isPresent()) {
            IPrimitiveType urlValueType = (IPrimitiveType)urlValue.get();
            urlValueString = urlValueType.getValueAsString();
        }
        return urlValueString;
    }

    static <T extends IBaseResource> List<T> toList(Map<String, IBaseResource> theMap) {
        ArrayList<IBaseResource> retVal = new ArrayList<IBaseResource>(theMap.values());
        return Collections.unmodifiableList(retVal);
    }
}

