/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.interceptor.model;

import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.util.JsonUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class RequestPartitionId
implements IModelJson {
    private static final RequestPartitionId ALL_PARTITIONS = new RequestPartitionId();
    private static final ObjectMapper ourObjectMapper = new ObjectMapper().registerModule((Module)new JavaTimeModule());
    @JsonProperty(value="partitionDate")
    private final LocalDate myPartitionDate;
    @JsonProperty(value="allPartitions")
    private final boolean myAllPartitions;
    @JsonProperty(value="partitionIds")
    private final List<Integer> myPartitionIds;
    @JsonProperty(value="partitionNames")
    private final List<String> myPartitionNames;

    private RequestPartitionId(@Nullable String thePartitionName, @Nullable Integer thePartitionId, @Nullable LocalDate thePartitionDate) {
        this.myPartitionIds = RequestPartitionId.toListOrNull(thePartitionId);
        this.myPartitionNames = RequestPartitionId.toListOrNull(thePartitionName);
        this.myPartitionDate = thePartitionDate;
        this.myAllPartitions = false;
    }

    private RequestPartitionId(@Nullable List<String> thePartitionName, @Nullable List<Integer> thePartitionId, @Nullable LocalDate thePartitionDate) {
        this.myPartitionIds = RequestPartitionId.toListOrNull(thePartitionId);
        this.myPartitionNames = RequestPartitionId.toListOrNull(thePartitionName);
        this.myPartitionDate = thePartitionDate;
        this.myAllPartitions = false;
    }

    private RequestPartitionId() {
        this.myPartitionDate = null;
        this.myPartitionNames = null;
        this.myPartitionIds = null;
        this.myAllPartitions = true;
    }

    public RequestPartitionId mergeIds(RequestPartitionId theOther) {
        if (this.isAllPartitions() || theOther.isAllPartitions()) {
            return RequestPartitionId.allPartitions();
        }
        List<Integer> thisPartitionIds = this.getPartitionIds();
        List<Integer> otherPartitionIds = theOther.getPartitionIds();
        List<Integer> newPartitionIds = Stream.concat(thisPartitionIds.stream(), otherPartitionIds.stream()).distinct().collect(Collectors.toList());
        return RequestPartitionId.fromPartitionIds(newPartitionIds);
    }

    public static RequestPartitionId fromJson(String theJson) throws JsonProcessingException {
        return (RequestPartitionId)ourObjectMapper.readValue(theJson, RequestPartitionId.class);
    }

    public boolean isAllPartitions() {
        return this.myAllPartitions;
    }

    public boolean isPartitionCovered(Integer thePartitionId) {
        return this.isAllPartitions() || this.getPartitionIds().contains(thePartitionId);
    }

    @Nullable
    public LocalDate getPartitionDate() {
        return this.myPartitionDate;
    }

    @Nullable
    public List<String> getPartitionNames() {
        return this.myPartitionNames;
    }

    @Nonnull
    public List<Integer> getPartitionIds() {
        Validate.notNull(this.myPartitionIds, (String)"Partition IDs have not been set", (Object[])new Object[0]);
        return this.myPartitionIds;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        if (this.hasPartitionIds()) {
            b.append("ids", this.getPartitionIds());
        }
        if (this.hasPartitionNames()) {
            b.append("names", this.getPartitionNames());
        }
        if (this.myAllPartitions) {
            b.append("allPartitions", this.myAllPartitions);
        }
        return b.build();
    }

    public boolean equals(Object theO) {
        if (this == theO) {
            return true;
        }
        if (theO == null || this.getClass() != theO.getClass()) {
            return false;
        }
        RequestPartitionId that = (RequestPartitionId)theO;
        EqualsBuilder b = new EqualsBuilder();
        b.append(this.myAllPartitions, that.myAllPartitions);
        b.append((Object)this.myPartitionDate, (Object)that.myPartitionDate);
        b.append(this.myPartitionIds, that.myPartitionIds);
        b.append(this.myPartitionNames, that.myPartitionNames);
        return b.isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.myPartitionDate).append(this.myAllPartitions).append(this.myPartitionIds).append(this.myPartitionNames).toHashCode();
    }

    public String toJson() {
        return JsonUtil.serializeOrInvalidRequest(this);
    }

    @Nullable
    public Integer getFirstPartitionIdOrNull() {
        if (this.myPartitionIds != null) {
            return this.myPartitionIds.get(0);
        }
        return null;
    }

    public String getFirstPartitionNameOrNull() {
        if (this.myPartitionNames != null) {
            return this.myPartitionNames.get(0);
        }
        return null;
    }

    public boolean isDefaultPartition() {
        if (this.isAllPartitions()) {
            return false;
        }
        return this.hasPartitionIds() && this.getPartitionIds().size() == 1 && this.getPartitionIds().get(0) == null;
    }

    public boolean hasPartitionId(Integer thePartitionId) {
        Validate.notNull(this.myPartitionIds, (String)"Partition IDs not set", (Object[])new Object[0]);
        return this.myPartitionIds.contains(thePartitionId);
    }

    public boolean hasPartitionIds() {
        return this.myPartitionIds != null;
    }

    public boolean hasPartitionNames() {
        return this.myPartitionNames != null;
    }

    public boolean hasDefaultPartitionId() {
        return this.getPartitionIds().contains(null);
    }

    public List<Integer> getPartitionIdsWithoutDefault() {
        return this.getPartitionIds().stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    private static <T> List<T> toListOrNull(@Nullable Collection<T> theList) {
        if (theList != null) {
            if (theList.size() == 1) {
                return Collections.singletonList(theList.iterator().next());
            }
            return Collections.unmodifiableList(new ArrayList<T>(theList));
        }
        return null;
    }

    @Nullable
    private static <T> List<T> toListOrNull(@Nullable T theObject) {
        if (theObject != null) {
            return Collections.singletonList(theObject);
        }
        return null;
    }

    @SafeVarargs
    @Nullable
    private static <T> List<T> toListOrNull(T ... theObject) {
        if (theObject != null) {
            return Arrays.asList(theObject);
        }
        return null;
    }

    @Nonnull
    public static RequestPartitionId allPartitions() {
        return ALL_PARTITIONS;
    }

    @Nonnull
    public static RequestPartitionId defaultPartition() {
        return RequestPartitionId.fromPartitionIds(Collections.singletonList(null));
    }

    @Nonnull
    public static RequestPartitionId defaultPartition(@Nullable LocalDate thePartitionDate) {
        return RequestPartitionId.fromPartitionIds(Collections.singletonList(null), thePartitionDate);
    }

    @Nonnull
    public static RequestPartitionId fromPartitionId(@Nullable Integer thePartitionId) {
        return RequestPartitionId.fromPartitionIds(Collections.singletonList(thePartitionId));
    }

    @Nonnull
    public static RequestPartitionId fromPartitionId(@Nullable Integer thePartitionId, @Nullable LocalDate thePartitionDate) {
        return new RequestPartitionId(null, Collections.singletonList(thePartitionId), thePartitionDate);
    }

    @Nonnull
    public static RequestPartitionId fromPartitionIds(@Nonnull Collection<Integer> thePartitionIds) {
        return RequestPartitionId.fromPartitionIds(thePartitionIds, null);
    }

    @Nonnull
    public static RequestPartitionId fromPartitionIds(@Nonnull Collection<Integer> thePartitionIds, @Nullable LocalDate thePartitionDate) {
        return new RequestPartitionId(null, RequestPartitionId.toListOrNull(thePartitionIds), thePartitionDate);
    }

    @Nonnull
    public static RequestPartitionId fromPartitionIds(Integer ... thePartitionIds) {
        return new RequestPartitionId(null, RequestPartitionId.toListOrNull(thePartitionIds), null);
    }

    @Nonnull
    public static RequestPartitionId fromPartitionName(@Nullable String thePartitionName) {
        return RequestPartitionId.fromPartitionName(thePartitionName, null);
    }

    @Nonnull
    public static RequestPartitionId fromPartitionName(@Nullable String thePartitionName, @Nullable LocalDate thePartitionDate) {
        return new RequestPartitionId(thePartitionName, null, thePartitionDate);
    }

    @Nonnull
    public static RequestPartitionId fromPartitionNames(@Nullable List<String> thePartitionNames) {
        return new RequestPartitionId(RequestPartitionId.toListOrNull(thePartitionNames), null, null);
    }

    @Nonnull
    public static RequestPartitionId fromPartitionNames(String ... thePartitionNames) {
        return new RequestPartitionId(RequestPartitionId.toListOrNull(thePartitionNames), null, null);
    }

    @Nonnull
    public static RequestPartitionId fromPartitionIdAndName(@Nullable Integer thePartitionId, @Nullable String thePartitionName) {
        return new RequestPartitionId(thePartitionName, thePartitionId, null);
    }

    @Nonnull
    public static RequestPartitionId forPartitionIdAndName(@Nullable Integer thePartitionId, @Nullable String thePartitionName, @Nullable LocalDate thePartitionDate) {
        return new RequestPartitionId(thePartitionName, thePartitionId, thePartitionDate);
    }

    @Nonnull
    public static RequestPartitionId forPartitionIdsAndNames(List<String> thePartitionNames, List<Integer> thePartitionIds, LocalDate thePartitionDate) {
        return new RequestPartitionId(thePartitionNames, thePartitionIds, thePartitionDate);
    }

    public static boolean isDefaultPartition(@Nullable RequestPartitionId thePartitionId) {
        if (thePartitionId == null) {
            return false;
        }
        return thePartitionId.isDefaultPartition();
    }

    public static String stringifyForKey(@Nonnull RequestPartitionId theRequestPartitionId) {
        String retVal = "(all)";
        if (!theRequestPartitionId.isAllPartitions()) {
            assert (theRequestPartitionId.hasPartitionIds());
            retVal = theRequestPartitionId.getPartitionIds().stream().map(t -> ((Serializable)ObjectUtils.defaultIfNull((Object)t, (Object)"null")).toString()).collect(Collectors.joining(" "));
        }
        return retVal;
    }

    public String asJson() throws JsonProcessingException {
        return ourObjectMapper.writeValueAsString((Object)this);
    }
}

