/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.util.FhirTerser;
import jakarta.annotation.Nonnull;
import java.util.Date;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class CompositionBuilder {
    private final FhirContext myCtx;
    private final IBaseResource myComposition;
    private final RuntimeResourceDefinition myCompositionDef;
    private final FhirTerser myTerser;

    public CompositionBuilder(@Nonnull FhirContext theFhirContext) {
        this.myCtx = theFhirContext;
        this.myCompositionDef = this.myCtx.getResourceDefinition("Composition");
        this.myTerser = this.myCtx.newTerser();
        this.myComposition = (IBaseResource)this.myCompositionDef.newInstance();
    }

    public <T extends IBaseResource> T getComposition() {
        return (T)this.myComposition;
    }

    public void addAuthor(IIdType theAuthorId) {
        IBaseReference reference = (IBaseReference)this.myTerser.addElement(this.myComposition, "Composition.author");
        reference.setReference(theAuthorId.getValue());
    }

    public void setStatus(String theStatusCode) {
        this.myTerser.setElement(this.myComposition, "Composition.status", theStatusCode);
    }

    public void setSubject(IIdType theSubject) {
        this.myTerser.setElement(this.myComposition, "Composition.subject.reference", theSubject.getValue());
    }

    public void addTypeCoding(String theSystem, String theCode, String theDisplay) {
        IBaseCoding coding = (IBaseCoding)this.myTerser.addElement(this.myComposition, "Composition.type.coding");
        coding.setCode(theCode);
        coding.setSystem(theSystem);
        coding.setDisplay(theDisplay);
    }

    public void setDate(IPrimitiveType<Date> theDate) {
        this.myTerser.setElement(this.myComposition, "Composition.date", theDate.getValueAsString());
    }

    public void setTitle(String theTitle) {
        this.myTerser.setElement(this.myComposition, "Composition.title", theTitle);
    }

    public void setConfidentiality(String theConfidentiality) {
        this.myTerser.setElement(this.myComposition, "Composition.confidentiality", theConfidentiality);
    }

    public void setId(IIdType theId) {
        this.myComposition.setId(theId.getValue());
    }

    public SectionBuilder addSection() {
        Object section = this.myTerser.addElement(this.myComposition, "Composition.section");
        return new SectionBuilder((IBase)section);
    }

    public class SectionBuilder {
        private final IBase mySection;

        private SectionBuilder(IBase theSection) {
            this.mySection = theSection;
        }

        public void setTitle(String theTitle) {
            CompositionBuilder.this.myTerser.setElement(this.mySection, "title", theTitle);
        }

        public void addCodeCoding(String theSystem, String theCode, String theDisplay) {
            IBaseCoding coding = (IBaseCoding)CompositionBuilder.this.myTerser.addElement(this.mySection, "code.coding");
            coding.setCode(theCode);
            coding.setSystem(theSystem);
            coding.setDisplay(theDisplay);
        }

        public void addEntry(IIdType theReference) {
            IBaseReference entry = (IBaseReference)CompositionBuilder.this.myTerser.addElement(this.mySection, "entry");
            entry.setReference(theReference.getValue());
        }

        public void setText(String theStatus, String theDivHtml) {
            Object text = CompositionBuilder.this.myTerser.addElement(this.mySection, "text");
            CompositionBuilder.this.myTerser.setElement((IBase)text, "status", theStatus);
            CompositionBuilder.this.myTerser.setElement((IBase)text, "div", theDivHtml);
        }
    }
}

