/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.annotation.At;
import ca.uhn.fhir.rest.annotation.ConditionalUrlParam;
import ca.uhn.fhir.rest.annotation.Count;
import ca.uhn.fhir.rest.annotation.Elements;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.IncludeParam;
import ca.uhn.fhir.rest.annotation.Offset;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.annotation.OptionalParam;
import ca.uhn.fhir.rest.annotation.RawParam;
import ca.uhn.fhir.rest.annotation.RequiredParam;
import ca.uhn.fhir.rest.annotation.ResourceParam;
import ca.uhn.fhir.rest.annotation.Since;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.annotation.TransactionParam;
import ca.uhn.fhir.rest.annotation.Validate;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.api.PatchTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.ValidationModeEnum;
import ca.uhn.fhir.rest.client.api.IHttpRequest;
import ca.uhn.fhir.rest.client.method.AtParameter;
import ca.uhn.fhir.rest.client.method.BaseOutcomeReturningMethodBinding;
import ca.uhn.fhir.rest.client.method.ConditionalParamBinder;
import ca.uhn.fhir.rest.client.method.CountParameter;
import ca.uhn.fhir.rest.client.method.ElementsParameter;
import ca.uhn.fhir.rest.client.method.HttpGetClientInvocation;
import ca.uhn.fhir.rest.client.method.HttpPatchClientInvocation;
import ca.uhn.fhir.rest.client.method.HttpPostClientInvocation;
import ca.uhn.fhir.rest.client.method.HttpPutClientInvocation;
import ca.uhn.fhir.rest.client.method.IParameter;
import ca.uhn.fhir.rest.client.method.IncludeParameter;
import ca.uhn.fhir.rest.client.method.NullParameter;
import ca.uhn.fhir.rest.client.method.OffsetParameter;
import ca.uhn.fhir.rest.client.method.OperationParameter;
import ca.uhn.fhir.rest.client.method.PatchMethodBinding;
import ca.uhn.fhir.rest.client.method.PatchTypeParameter;
import ca.uhn.fhir.rest.client.method.RawParamsParmeter;
import ca.uhn.fhir.rest.client.method.ResourceParameter;
import ca.uhn.fhir.rest.client.method.SearchParameter;
import ca.uhn.fhir.rest.client.method.SinceParameter;
import ca.uhn.fhir.rest.client.method.SortParameter;
import ca.uhn.fhir.rest.client.method.SummaryEnumParameter;
import ca.uhn.fhir.rest.client.method.TransactionParameter;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.rest.param.binder.CollectionBinder;
import ca.uhn.fhir.util.DateUtils;
import ca.uhn.fhir.util.ParametersUtil;
import ca.uhn.fhir.util.ReflectionUtil;
import ca.uhn.fhir.util.UrlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodUtil {
    private static final Logger ourLog = LoggerFactory.getLogger(MethodUtil.class);

    private MethodUtil() {
    }

    public static void addAcceptHeaderToRequest(EncodingEnum theEncoding, IHttpRequest theHttpRequest, FhirContext theContext) {
        if (theEncoding == null) {
            if (!theContext.getVersion().getVersion().isNewerThan(FhirVersionEnum.DSTU2_1)) {
                theHttpRequest.addHeader("Accept", "application/xml+fhir;q=1.0, application/json+fhir;q=1.0");
            } else {
                theHttpRequest.addHeader("Accept", Constants.HEADER_ACCEPT_VALUE_XML_OR_JSON_NON_LEGACY);
            }
        } else if (theEncoding == EncodingEnum.JSON) {
            if (!theContext.getVersion().getVersion().isNewerThan(FhirVersionEnum.DSTU2_1)) {
                theHttpRequest.addHeader("Accept", "application/json+fhir");
            } else {
                theHttpRequest.addHeader("Accept", "application/fhir+json;q=1.0, application/json+fhir;q=0.9");
            }
        } else if (theEncoding == EncodingEnum.XML) {
            if (!theContext.getVersion().getVersion().isNewerThan(FhirVersionEnum.DSTU2_1)) {
                theHttpRequest.addHeader("Accept", "application/xml+fhir");
            } else {
                theHttpRequest.addHeader("Accept", "application/fhir+xml;q=1.0, application/xml+fhir;q=0.9");
            }
        }
    }

    public static HttpGetClientInvocation createConformanceInvocation(FhirContext theContext) {
        return new HttpGetClientInvocation(theContext, "metadata");
    }

    public static HttpPostClientInvocation createCreateInvocation(IBaseResource theResource, FhirContext theContext) {
        return MethodUtil.createCreateInvocation(theResource, null, theContext);
    }

    public static HttpPostClientInvocation createCreateInvocation(IBaseResource theResource, String theResourceBody, FhirContext theContext) {
        RuntimeResourceDefinition def = theContext.getResourceDefinition(theResource);
        String resourceName = def.getName();
        StringBuilder urlExtension = new StringBuilder();
        urlExtension.append(resourceName);
        HttpPostClientInvocation retVal = StringUtils.isBlank((CharSequence)theResourceBody) ? new HttpPostClientInvocation(theContext, theResource, urlExtension.toString()) : new HttpPostClientInvocation(theContext, theResourceBody, false, urlExtension.toString());
        retVal.setOmitResourceId(true);
        return retVal;
    }

    public static HttpPostClientInvocation createCreateInvocation(IBaseResource theResource, String theResourceBody, FhirContext theContext, Map<String, List<String>> theIfNoneExistParams) {
        HttpPostClientInvocation retVal = MethodUtil.createCreateInvocation(theResource, theResourceBody, theContext);
        retVal.setIfNoneExistParams((Map)theIfNoneExistParams);
        return retVal;
    }

    public static HttpPostClientInvocation createCreateInvocation(IBaseResource theResource, String theResourceBody, FhirContext theContext, String theIfNoneExistUrl) {
        HttpPostClientInvocation retVal = MethodUtil.createCreateInvocation(theResource, theResourceBody, theContext);
        retVal.setIfNoneExistString(theIfNoneExistUrl);
        return retVal;
    }

    public static HttpPatchClientInvocation createPatchInvocation(FhirContext theContext, IIdType theId, PatchTypeEnum thePatchType, String theBody) {
        return PatchMethodBinding.createPatchInvocation(theContext, theId, thePatchType, theBody);
    }

    public static HttpPatchClientInvocation createPatchInvocation(FhirContext theContext, PatchTypeEnum thePatchType, String theBody, String theResourceType, Map<String, List<String>> theMatchParams) {
        return PatchMethodBinding.createPatchInvocation(theContext, thePatchType, theBody, theResourceType, theMatchParams);
    }

    public static HttpPatchClientInvocation createPatchInvocation(FhirContext theContext, String theUrl, PatchTypeEnum thePatchType, String theBody) {
        return PatchMethodBinding.createPatchInvocation(theContext, theUrl, thePatchType, theBody);
    }

    public static HttpPutClientInvocation createUpdateInvocation(FhirContext theContext, IBaseResource theResource, String theResourceBody, Map<String, List<String>> theMatchParams) {
        String resourceType = theContext.getResourceType(theResource);
        StringBuilder b = MethodUtil.createUrl(resourceType, theMatchParams);
        HttpPutClientInvocation retVal = StringUtils.isBlank((CharSequence)theResourceBody) ? new HttpPutClientInvocation(theContext, theResource, b.toString()) : new HttpPutClientInvocation(theContext, theResourceBody, false, b.toString());
        return retVal;
    }

    public static HttpPutClientInvocation createUpdateInvocation(FhirContext theContext, IBaseResource theResource, String theResourceBody, String theMatchUrl) {
        HttpPutClientInvocation retVal = StringUtils.isBlank((CharSequence)theResourceBody) ? new HttpPutClientInvocation(theContext, theResource, theMatchUrl) : new HttpPutClientInvocation(theContext, theResourceBody, false, theMatchUrl);
        return retVal;
    }

    public static HttpPutClientInvocation createUpdateInvocation(IBaseResource theResource, String theResourceBody, IIdType theId, FhirContext theContext) {
        String resourceName = theContext.getResourceType(theResource);
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(resourceName);
        urlBuilder.append('/');
        urlBuilder.append(theId.getIdPart());
        String urlExtension = urlBuilder.toString();
        HttpPutClientInvocation retVal = StringUtils.isBlank((CharSequence)theResourceBody) ? new HttpPutClientInvocation(theContext, theResource, urlExtension) : new HttpPutClientInvocation(theContext, theResourceBody, false, urlExtension);
        retVal.setForceResourceId(theId);
        if (theId.hasVersionIdPart()) {
            retVal.addHeader("If-Match", '\"' + theId.getVersionIdPart() + '\"');
        }
        return retVal;
    }

    public static StringBuilder createUrl(String theResourceType, Map<String, List<String>> theMatchParams) {
        StringBuilder b = new StringBuilder();
        b.append(theResourceType);
        boolean haveQuestionMark = false;
        for (Map.Entry<String, List<String>> nextEntry : theMatchParams.entrySet()) {
            for (String nextValue : nextEntry.getValue()) {
                b.append(haveQuestionMark ? (char)'&' : '?');
                haveQuestionMark = true;
                b.append(UrlUtil.escapeUrlParam((String)nextEntry.getKey()));
                b.append('=');
                b.append(UrlUtil.escapeUrlParam((String)nextValue));
            }
        }
        return b;
    }

    public static List<IParameter> getResourceParameters(final FhirContext theContext, Method theMethod, Object theProvider, RestOperationTypeEnum theRestfulOperationTypeEnum) {
        ArrayList<IParameter> parameters = new ArrayList<IParameter>();
        Class<?>[] parameterTypes = theMethod.getParameterTypes();
        int paramIndex = 0;
        for (Annotation[] annotations : theMethod.getParameterAnnotations()) {
            IParameter param = null;
            Class parameterType = parameterTypes[paramIndex];
            Class outerCollectionType = null;
            Class innerCollectionType = null;
            if (TagList.class.isAssignableFrom(parameterType)) {
                param = new NullParameter();
            } else {
                if (Collection.class.isAssignableFrom(parameterType)) {
                    innerCollectionType = parameterType;
                    parameterType = ReflectionUtil.getGenericCollectionTypeOfMethodParameter((Method)theMethod, (int)paramIndex);
                }
                if (Collection.class.isAssignableFrom(parameterType)) {
                    outerCollectionType = innerCollectionType;
                    innerCollectionType = parameterType;
                    parameterType = ReflectionUtil.getGenericCollectionTypeOfMethodParameter((Method)theMethod, (int)paramIndex);
                }
                if (Collection.class.isAssignableFrom(parameterType)) {
                    throw new ConfigurationException("Argument #" + paramIndex + " of Method '" + theMethod.getName() + "' in type '" + theMethod.getDeclaringClass().getCanonicalName() + "' is of an invalid generic type (can not be a collection of a collection of a collection)");
                }
            }
            if (parameterType.equals(SummaryEnum.class)) {
                param = new SummaryEnumParameter();
            } else if (parameterType.equals(PatchTypeEnum.class)) {
                param = new PatchTypeParameter();
            } else {
                for (int i = 0; i < annotations.length && param == null; ++i) {
                    SearchParameter parameter;
                    Annotation nextAnnotation = annotations[i];
                    if (nextAnnotation instanceof RequiredParam) {
                        parameter = new SearchParameter();
                        parameter.setName(((RequiredParam)nextAnnotation).name());
                        parameter.setRequired(true);
                        parameter.setDeclaredTypes(((RequiredParam)nextAnnotation).targetTypes());
                        parameter.setCompositeTypes(((RequiredParam)nextAnnotation).compositeTypes());
                        parameter.setChainlists(((RequiredParam)nextAnnotation).chainWhitelist());
                        parameter.setType(theContext, parameterType, innerCollectionType, outerCollectionType);
                        param = parameter;
                        continue;
                    }
                    if (nextAnnotation instanceof OptionalParam) {
                        parameter = new SearchParameter();
                        parameter.setName(((OptionalParam)nextAnnotation).name());
                        parameter.setRequired(false);
                        parameter.setDeclaredTypes(((OptionalParam)nextAnnotation).targetTypes());
                        parameter.setCompositeTypes(((OptionalParam)nextAnnotation).compositeTypes());
                        parameter.setChainlists(((OptionalParam)nextAnnotation).chainWhitelist());
                        parameter.setType(theContext, parameterType, innerCollectionType, outerCollectionType);
                        param = parameter;
                        continue;
                    }
                    if (nextAnnotation instanceof RawParam) {
                        param = new RawParamsParmeter();
                        continue;
                    }
                    if (nextAnnotation instanceof IncludeParam) {
                        Class specType;
                        Class instantiableCollectionType;
                        if (parameterType == String.class) {
                            instantiableCollectionType = null;
                            specType = String.class;
                        } else {
                            if (parameterType != Include.class || innerCollectionType == null || outerCollectionType != null) {
                                throw new ConfigurationException("Method '" + theMethod.getName() + "' is annotated with @" + IncludeParam.class.getSimpleName() + " but has a type other than Collection<" + Include.class.getSimpleName() + ">");
                            }
                            instantiableCollectionType = CollectionBinder.getInstantiableCollectionType((Class)innerCollectionType, (String)("Method '" + theMethod.getName() + "'"));
                            specType = parameterType;
                        }
                        param = new IncludeParameter((IncludeParam)nextAnnotation, instantiableCollectionType, specType);
                        continue;
                    }
                    if (nextAnnotation instanceof ResourceParam) {
                        if (!IBaseResource.class.isAssignableFrom(parameterType) && !String.class.equals((Object)parameterType)) {
                            StringBuilder b = new StringBuilder();
                            b.append("Method '");
                            b.append(theMethod.getName());
                            b.append("' is annotated with @");
                            b.append(ResourceParam.class.getSimpleName());
                            b.append(" but has a type that is not an implementation of ");
                            b.append(IBaseResource.class.getCanonicalName());
                            throw new ConfigurationException(b.toString());
                        }
                        param = new ResourceParameter(parameterType);
                        continue;
                    }
                    if (nextAnnotation instanceof IdParam) {
                        param = new NullParameter();
                        continue;
                    }
                    if (nextAnnotation instanceof Elements) {
                        param = new ElementsParameter();
                        continue;
                    }
                    if (nextAnnotation instanceof Since) {
                        param = new SinceParameter();
                        ((SinceParameter)param).setType(theContext, parameterType, innerCollectionType, outerCollectionType);
                        continue;
                    }
                    if (nextAnnotation instanceof At) {
                        param = new AtParameter();
                        ((AtParameter)param).setType(theContext, parameterType, innerCollectionType, outerCollectionType);
                        continue;
                    }
                    if (nextAnnotation instanceof Count) {
                        param = new CountParameter();
                        continue;
                    }
                    if (nextAnnotation instanceof Offset) {
                        param = new OffsetParameter();
                        continue;
                    }
                    if (nextAnnotation instanceof Sort) {
                        param = new SortParameter(theContext);
                        continue;
                    }
                    if (nextAnnotation instanceof TransactionParam) {
                        param = new TransactionParameter(theContext);
                        continue;
                    }
                    if (nextAnnotation instanceof ConditionalUrlParam) {
                        param = new ConditionalParamBinder(theRestfulOperationTypeEnum, ((ConditionalUrlParam)nextAnnotation).supportsMultiple());
                        continue;
                    }
                    if (nextAnnotation instanceof OperationParam) {
                        Operation op = theMethod.getAnnotation(Operation.class);
                        param = new OperationParameter(theContext, op.name(), (OperationParam)nextAnnotation);
                        continue;
                    }
                    if (nextAnnotation instanceof Validate.Mode) {
                        if (!parameterType.equals(ValidationModeEnum.class)) {
                            throw new ConfigurationException("Parameter annotated with @" + Validate.class.getSimpleName() + "." + Validate.Mode.class.getSimpleName() + " must be of type " + ValidationModeEnum.class.getName());
                        }
                        param = new OperationParameter(theContext, "$validate", "mode", 0, 1).setConverter(new OperationParameter.IOperationParamConverter(){

                            @Override
                            public Object outgoingClient(Object theObject) {
                                return ParametersUtil.createString((FhirContext)theContext, (String)((ValidationModeEnum)theObject).getCode());
                            }
                        });
                        continue;
                    }
                    if (!(nextAnnotation instanceof Validate.Profile)) continue;
                    if (!parameterType.equals(String.class)) {
                        throw new ConfigurationException("Parameter annotated with @" + Validate.class.getSimpleName() + "." + Validate.Profile.class.getSimpleName() + " must be of type " + String.class.getName());
                    }
                    param = new OperationParameter(theContext, "$validate", "profile", 0, 1).setConverter(new OperationParameter.IOperationParamConverter(){

                        @Override
                        public Object outgoingClient(Object theObject) {
                            return ParametersUtil.createString((FhirContext)theContext, (String)theObject.toString());
                        }
                    });
                }
            }
            if (param == null) {
                throw new ConfigurationException("Parameter #" + (paramIndex + 1) + "/" + parameterTypes.length + " of method '" + theMethod.getName() + "' on type '" + theMethod.getDeclaringClass().getCanonicalName() + "' has no recognized FHIR interface parameter annotations. Don't know how to handle this parameter");
            }
            param.initializeTypes(theMethod, outerCollectionType, innerCollectionType, parameterType);
            parameters.add(param);
            ++paramIndex;
        }
        return parameters;
    }

    public static void parseClientRequestResourceHeaders(IIdType theRequestedId, Map<String, List<String>> theHeaders, IBaseResource resource) {
        String headerValue;
        List<String> locationHeaders;
        String headerValue2;
        List<String> clHeaders;
        List<String> lmHeaders = theHeaders.get(Constants.HEADER_LAST_MODIFIED_LOWERCASE);
        if (lmHeaders != null && lmHeaders.size() > 0 && StringUtils.isNotBlank((CharSequence)lmHeaders.get(0))) {
            String headerValue3 = lmHeaders.get(0);
            try {
                IAnyResource anyResource;
                Date headerDateValue = DateUtils.parseDate((String)headerValue3);
                if (resource instanceof IResource) {
                    IResource iResource = (IResource)resource;
                    InstantDt existing = (InstantDt)ResourceMetadataKeyEnum.UPDATED.get(iResource);
                    if (existing == null || existing.isEmpty()) {
                        InstantDt lmValue = new InstantDt(headerDateValue);
                        iResource.getResourceMetadata().put((Object)ResourceMetadataKeyEnum.UPDATED, (Object)lmValue);
                    }
                } else if (resource instanceof IAnyResource && (anyResource = (IAnyResource)resource).getMeta().getLastUpdated() == null) {
                    anyResource.getMeta().setLastUpdated(headerDateValue);
                }
            }
            catch (Exception e) {
                ourLog.warn("Unable to parse date string '{}'. Error is: {}", (Object)headerValue3, (Object)e.toString());
            }
        }
        if ((clHeaders = theHeaders.get(Constants.HEADER_CONTENT_LOCATION_LC)) != null && clHeaders.size() > 0 && StringUtils.isNotBlank((CharSequence)clHeaders.get(0)) && StringUtils.isNotBlank((CharSequence)(headerValue2 = clHeaders.get(0)))) {
            new IdDt(headerValue2).applyTo(resource);
        }
        if ((locationHeaders = theHeaders.get(Constants.HEADER_LOCATION_LC)) != null && locationHeaders.size() > 0 && StringUtils.isNotBlank((CharSequence)locationHeaders.get(0)) && StringUtils.isNotBlank((CharSequence)(headerValue = locationHeaders.get(0)))) {
            new IdDt(headerValue).applyTo(resource);
        }
        IdDt existing = IdDt.of((IBaseResource)resource);
        List<String> eTagHeaders = theHeaders.get(Constants.HEADER_ETAG_LC);
        String eTagVersion = null;
        if (eTagHeaders != null && eTagHeaders.size() > 0) {
            eTagVersion = ParameterUtil.parseETagValue((String)eTagHeaders.get(0));
        }
        if (StringUtils.isNotBlank(eTagVersion)) {
            if (existing == null || existing.isEmpty()) {
                if (theRequestedId != null) {
                    theRequestedId.withVersion(eTagVersion).applyTo(resource);
                }
            } else if (!existing.hasVersionIdPart()) {
                existing.withVersion(eTagVersion).applyTo(resource);
            }
        } else if ((existing == null || existing.isEmpty()) && theRequestedId != null) {
            theRequestedId.applyTo(resource);
        }
    }

    public static MethodOutcome process2xxResponse(FhirContext theContext, int theResponseStatusCode, String theResponseMimeType, InputStream theResponseReader, Map<String, List<String>> theHeaders) {
        List<String> clh;
        ArrayList<String> locationHeaders = new ArrayList<String>();
        List<String> lh = theHeaders.get(Constants.HEADER_LOCATION_LC);
        if (lh != null) {
            locationHeaders.addAll(lh);
        }
        if ((clh = theHeaders.get(Constants.HEADER_CONTENT_LOCATION_LC)) != null) {
            locationHeaders.addAll(clh);
        }
        MethodOutcome retVal = new MethodOutcome();
        if (locationHeaders.size() > 0) {
            String locationHeader = (String)locationHeaders.get(0);
            BaseOutcomeReturningMethodBinding.parseContentLocation(theContext, retVal, locationHeader);
        }
        if (theResponseStatusCode != 204) {
            EncodingEnum ct = EncodingEnum.forContentType((String)theResponseMimeType);
            if (ct != null) {
                PushbackInputStream reader = new PushbackInputStream(theResponseReader);
                try {
                    int firstByte = reader.read();
                    if (firstByte == -1) {
                        BaseOutcomeReturningMethodBinding.ourLog.debug("No content in response, not going to read");
                        reader = null;
                    } else {
                        reader.unread(firstByte);
                    }
                }
                catch (IOException e) {
                    BaseOutcomeReturningMethodBinding.ourLog.debug("No content in response, not going to read", (Throwable)e);
                    reader = null;
                }
                if (reader != null) {
                    IParser parser = ct.newParser(theContext);
                    IBaseResource outcome = parser.parseResource((InputStream)reader);
                    if (outcome instanceof IBaseOperationOutcome) {
                        retVal.setOperationOutcome((IBaseOperationOutcome)outcome);
                    } else {
                        retVal.setResource(outcome);
                    }
                }
            } else {
                BaseOutcomeReturningMethodBinding.ourLog.debug("Ignoring response content of type: {}", (Object)theResponseMimeType);
            }
        }
        return retVal;
    }
}

