/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.interceptor;

import ca.uhn.fhir.rest.client.api.IClientInterceptor;
import ca.uhn.fhir.rest.client.api.IHttpRequest;
import ca.uhn.fhir.rest.client.api.IHttpResponse;
import ca.uhn.fhir.rest.client.interceptor.CapturingInterceptor;

public class ThreadLocalCapturingInterceptor
implements IClientInterceptor {
    private final ThreadLocal<IHttpRequest> myRequestThreadLocal = new ThreadLocal();
    private final ThreadLocal<IHttpResponse> myResponseThreadLocal = new ThreadLocal();
    private boolean myBufferResponse;

    public void clearThreadLocals() {
        this.myRequestThreadLocal.remove();
        this.myResponseThreadLocal.remove();
    }

    public IHttpRequest getRequestForCurrentThread() {
        return this.myRequestThreadLocal.get();
    }

    public IHttpResponse getResponseForCurrentThread() {
        return this.myResponseThreadLocal.get();
    }

    public void interceptRequest(IHttpRequest theRequest) {
        this.myRequestThreadLocal.set(theRequest);
    }

    public void interceptResponse(IHttpResponse theResponse) {
        if (this.isBufferResponse()) {
            CapturingInterceptor.bufferResponse(theResponse);
        }
        this.myResponseThreadLocal.set(theResponse);
    }

    public boolean isBufferResponse() {
        return this.myBufferResponse;
    }

    public ThreadLocalCapturingInterceptor setBufferResponse(boolean theBufferResponse) {
        this.myBufferResponse = theBufferResponse;
        return this;
    }
}

