/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.annotation.ResourceParam;
import ca.uhn.fhir.rest.client.impl.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.client.method.BaseOutcomeReturningMethodBinding;
import ca.uhn.fhir.rest.client.method.IParameter;
import ca.uhn.fhir.rest.client.method.ResourceParameter;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.lang.reflect.Method;
import org.hl7.fhir.instance.model.api.IBaseResource;

abstract class BaseOutcomeReturningMethodBindingWithResourceParam
extends BaseOutcomeReturningMethodBinding {
    private String myResourceName;
    private int myResourceParameterIndex = -1;
    private Class<? extends IBaseResource> myResourceType;

    public BaseOutcomeReturningMethodBindingWithResourceParam(Method theMethod, FhirContext theContext, Class<?> theMethodAnnotation, Object theProvider) {
        super(theMethod, theContext, theMethodAnnotation, theProvider);
        ResourceParameter resourceParameter = null;
        int index = 0;
        for (IParameter next : this.getParameters()) {
            if (next instanceof ResourceParameter) {
                resourceParameter = (ResourceParameter)next;
                if (this.myResourceType != null) {
                    throw new ConfigurationException(Msg.code((int)1468) + "Method " + theMethod.getName() + " on type " + theMethod.getDeclaringClass() + " has more than one @ResourceParam. Only one is allowed.");
                }
                this.myResourceType = resourceParameter.getResourceType();
                this.myResourceParameterIndex = index;
            }
            ++index;
        }
        if (this.myResourceType == null) {
            throw new ConfigurationException(Msg.code((int)1469) + "Unable to determine resource type for method: " + theMethod);
        }
        this.myResourceName = theContext.getResourceType(this.myResourceType);
        if (resourceParameter == null) {
            throw new ConfigurationException(Msg.code((int)1470) + "Method " + theMethod.getName() + " in type " + theMethod.getDeclaringClass().getCanonicalName() + " does not have a resource parameter annotated with @" + ResourceParam.class.getSimpleName());
        }
    }

    @Override
    public String getResourceName() {
        return this.myResourceName;
    }

    @Override
    public BaseHttpClientInvocation invokeClient(Object[] theArgs) throws InternalErrorException {
        IBaseResource resource = (IBaseResource)theArgs[this.myResourceParameterIndex];
        if (resource == null) {
            throw new NullPointerException(Msg.code((int)1471) + "Resource can not be null");
        }
        BaseHttpClientInvocation retVal = this.createClientInvocation(theArgs, resource);
        return retVal;
    }

    protected void validateResourceIdAndUrlIdForNonConditionalOperation(IBaseResource theResource, String theResourceId, String theUrlId, String theMatchUrl) {
    }
}

