/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jaxrs.client;

import ca.uhn.fhir.rest.client.api.IHttpResponse;
import ca.uhn.fhir.rest.client.impl.BaseHttpResponse;
import ca.uhn.fhir.util.StopWatch;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class JaxRsHttpResponse
extends BaseHttpResponse
implements IHttpResponse {
    private boolean myBufferedEntity = false;
    private final Response myResponse;

    public JaxRsHttpResponse(Response theResponse, StopWatch theResponseStopWatch) {
        super(theResponseStopWatch);
        this.myResponse = theResponse;
    }

    public void bufferEntitity() throws IOException {
        this.bufferEntity();
    }

    public void bufferEntity() throws IOException {
        if (!this.myBufferedEntity && this.myResponse.hasEntity()) {
            this.myBufferedEntity = true;
            this.myResponse.bufferEntity();
        } else {
            this.myResponse.bufferEntity();
        }
    }

    public void close() {
    }

    public Reader createReader() {
        if (!this.myBufferedEntity && !this.myResponse.hasEntity()) {
            return new StringReader("");
        }
        return new StringReader((String)this.myResponse.readEntity(String.class));
    }

    public Map<String, List<String>> getAllHeaders() {
        ConcurrentHashMap<String, List<String>> theHeaders = new ConcurrentHashMap<String, List<String>>();
        for (Map.Entry iterable_element : this.myResponse.getStringHeaders().entrySet()) {
            theHeaders.put(((String)iterable_element.getKey()).toLowerCase(), (List<String>)iterable_element.getValue());
        }
        return theHeaders;
    }

    public String getMimeType() {
        MediaType mediaType = this.myResponse.getMediaType();
        if (mediaType == null) {
            return null;
        }
        return new MediaType(mediaType.getType(), mediaType.getSubtype()).toString();
    }

    public Response getResponse() {
        return this.myResponse;
    }

    public int getStatus() {
        return this.myResponse.getStatus();
    }

    public String getStatusInfo() {
        return this.myResponse.getStatusInfo().getReasonPhrase();
    }

    public InputStream readEntity() {
        if (!this.myBufferedEntity && !this.myResponse.hasEntity()) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return new ByteArrayInputStream((byte[])this.myResponse.readEntity(byte[].class));
    }

    public List<String> getHeaders(String theName) {
        List retVal = (List)this.myResponse.getStringHeaders().get((Object)theName);
        return retVal;
    }
}

