/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jaxrs.server;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.api.BundleInclusionRule;
import ca.uhn.fhir.jaxrs.server.AbstractJaxRsProvider;
import ca.uhn.fhir.jaxrs.server.interceptor.JaxRsExceptionInterceptor;
import ca.uhn.fhir.jaxrs.server.util.JaxRsMethodBindings;
import ca.uhn.fhir.jaxrs.server.util.JaxRsRequest;
import ca.uhn.fhir.rest.api.PreferReturnEnum;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.IRestfulServer;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.IPagingProvider;
import ca.uhn.fhir.rest.server.IResourceProvider;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import java.io.IOException;
import java.net.URL;
import javax.interceptor.Interceptors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.hl7.fhir.instance.model.api.IBaseResource;

@Produces(value={"application/json", "application/xml", "text/plain", "application/json+fhir", "application/xml+fhir"})
@Consumes(value={"application/x-www-form-urlencoded", "application/json", "application/json+fhir", "application/xml+fhir", "application/fhir+json", "application/fhir+xml", "application/octet-stream"})
@Interceptors(value={JaxRsExceptionInterceptor.class})
public abstract class AbstractJaxRsResourceProvider<R extends IBaseResource>
extends AbstractJaxRsProvider
implements IRestfulServer<JaxRsRequest>,
IResourceProvider {
    private final JaxRsMethodBindings theBindings;

    protected AbstractJaxRsResourceProvider() {
        this.theBindings = JaxRsMethodBindings.getMethodBindings(this, this.getClass());
    }

    protected AbstractJaxRsResourceProvider(FhirContext ctx) {
        super(ctx);
        this.theBindings = JaxRsMethodBindings.getMethodBindings(this, this.getClass());
    }

    protected AbstractJaxRsResourceProvider(Class<? extends AbstractJaxRsProvider> theProviderClass) {
        this.theBindings = JaxRsMethodBindings.getMethodBindings(this, theProviderClass);
    }

    protected AbstractJaxRsResourceProvider(FhirContext ctx, Class<? extends AbstractJaxRsProvider> theProviderClass) {
        super(ctx);
        this.theBindings = JaxRsMethodBindings.getMethodBindings(this, theProviderClass);
    }

    @Override
    public String getBaseForRequest() {
        try {
            return new URL(this.getUriInfo().getBaseUri().toURL(), this.getResourceType().getSimpleName()).toExternalForm();
        }
        catch (Exception e) {
            return null;
        }
    }

    @POST
    public Response create(String resource) throws IOException {
        return this.execute(this.getResourceRequest(RequestTypeEnum.POST, RestOperationTypeEnum.CREATE).resource(resource));
    }

    @POST
    @Path(value="/_search")
    public Response searchWithPost() throws IOException {
        return this.execute(this.getResourceRequest(RequestTypeEnum.POST, RestOperationTypeEnum.SEARCH_TYPE));
    }

    @GET
    public Response search() throws IOException {
        return this.execute(this.getResourceRequest(RequestTypeEnum.GET, RestOperationTypeEnum.SEARCH_TYPE));
    }

    @PUT
    public Response conditionalUpdate(String resource) throws IOException {
        return this.execute(this.getResourceRequest(RequestTypeEnum.PUT, RestOperationTypeEnum.UPDATE).resource(resource));
    }

    @PUT
    @Path(value="/{id}")
    public Response update(@PathParam(value="id") String id, String resource) throws IOException {
        return this.execute(this.getResourceRequest(RequestTypeEnum.PUT, RestOperationTypeEnum.UPDATE).id(id).resource(resource));
    }

    @DELETE
    public Response delete() throws IOException {
        return this.execute(this.getResourceRequest(RequestTypeEnum.DELETE, RestOperationTypeEnum.DELETE));
    }

    @DELETE
    @Path(value="/{id}")
    public Response delete(@PathParam(value="id") String id) throws IOException {
        return this.execute(this.getResourceRequest(RequestTypeEnum.DELETE, RestOperationTypeEnum.DELETE).id(id));
    }

    @GET
    @Path(value="/{id}")
    public Response find(@PathParam(value="id") String id) throws IOException {
        return this.execute(this.getResourceRequest(RequestTypeEnum.GET, RestOperationTypeEnum.READ).id(id));
    }

    protected Response customOperation(String resource, RequestTypeEnum requestType, String id, String operationName, RestOperationTypeEnum operationType) throws IOException {
        JaxRsRequest.Builder request = this.getResourceRequest(requestType, operationType).resource(resource).id(id);
        return this.execute(request, operationName);
    }

    @GET
    @Path(value="/{id}/_history/{version}")
    public Response findHistory(@PathParam(value="id") String id, @PathParam(value="version") String version) throws IOException {
        JaxRsRequest.Builder theRequest = this.getResourceRequest(RequestTypeEnum.GET, RestOperationTypeEnum.VREAD).id(id).version(version);
        return this.execute(theRequest);
    }

    @GET
    @Path(value="/{id}/{compartment}")
    public Response findCompartment(@PathParam(value="id") String id, @PathParam(value="compartment") String compartment) throws IOException {
        JaxRsRequest.Builder theRequest = this.getResourceRequest(RequestTypeEnum.GET, RestOperationTypeEnum.SEARCH_TYPE).id(id).compartment(compartment);
        return this.execute(theRequest, compartment);
    }

    @POST
    @Path(value="/$validate")
    public Response validate(String resource) throws IOException {
        return this.customOperation(resource, RequestTypeEnum.POST, null, "$validate", RestOperationTypeEnum.EXTENDED_OPERATION_TYPE);
    }

    private Response execute(JaxRsRequest.Builder theRequestBuilder, String methodKey) throws IOException {
        JaxRsRequest theRequest = theRequestBuilder.build();
        BaseMethodBinding<?> method = this.getBinding(theRequest.getRestOperationType(), methodKey);
        try {
            return (Response)method.invokeServer((IRestfulServer)this, (RequestDetails)theRequest);
        }
        catch (Throwable theException) {
            return this.handleException(theRequest, theException);
        }
    }

    private Response execute(JaxRsRequest.Builder theRequestBuilder) throws IOException {
        return this.execute(theRequestBuilder, "");
    }

    protected BaseMethodBinding<?> getBinding(RestOperationTypeEnum restOperation, String theBindingKey) {
        return this.getBindings().getBinding(restOperation, theBindingKey);
    }

    @Override
    public IPagingProvider getPagingProvider() {
        return null;
    }

    public BundleInclusionRule getBundleInclusionRule() {
        return BundleInclusionRule.BASED_ON_INCLUDES;
    }

    public PreferReturnEnum getDefaultPreferReturn() {
        return PreferReturnEnum.REPRESENTATION;
    }

    public abstract Class<R> getResourceType();

    public JaxRsMethodBindings getBindings() {
        return this.theBindings;
    }

    private JaxRsRequest.Builder getResourceRequest(RequestTypeEnum requestType, RestOperationTypeEnum restOperation) {
        return this.getRequest(requestType, restOperation, this.getResourceType().getSimpleName());
    }
}

