/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jaxrs.server.util;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.jaxrs.server.util.JaxRsRequest;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.api.server.ParseAction;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.RestfulResponse;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseBinary;

public class JaxRsResponse
extends RestfulResponse<JaxRsRequest> {
    public JaxRsResponse(JaxRsRequest request) {
        super((RequestDetails)request);
    }

    public Writer getResponseWriter(int theStatusCode, String theStatusMessage, String theContentType, String theCharset, boolean theRespondGzip) throws UnsupportedEncodingException, IOException {
        return new StringWriter();
    }

    public Response sendWriterResponse(int theStatus, String theContentType, String theCharset, Writer theWriter) {
        Response.ResponseBuilder builder = this.buildResponse(theStatus);
        if (StringUtils.isNotBlank((CharSequence)theContentType)) {
            String charContentType = theContentType + "; charset=" + (String)StringUtils.defaultIfBlank((CharSequence)theCharset, (CharSequence)"UTF-8");
            builder.header("Content-Type", (Object)charContentType);
        }
        builder.entity((Object)theWriter.toString());
        Response retVal = builder.build();
        return retVal;
    }

    public Response sendAttachmentResponse(IBaseBinary bin, int statusCode, String contentType) throws IOException {
        Response.ResponseBuilder response = this.buildResponse(statusCode);
        if (bin.getContent() != null && bin.getContent().length > 0) {
            response.header("Content-Type", (Object)contentType).entity((Object)bin.getContent());
        }
        return response.build();
    }

    public Response returnResponse(ParseAction<?> outcome, int operationStatus, boolean allowPrefer, MethodOutcome response, String resourceName) throws IOException {
        StringWriter writer = new StringWriter();
        if (outcome != null) {
            FhirContext fhirContext = ((JaxRsRequest)this.getRequestDetails()).getServer().getFhirContext();
            IParser parser = RestfulServerUtils.getNewParser((FhirContext)fhirContext, (FhirVersionEnum)fhirContext.getVersion().getVersion(), (RequestDetails)this.getRequestDetails());
            outcome.execute(parser, (Writer)writer);
        }
        return this.sendWriterResponse(operationStatus, this.getParserType(), null, writer);
    }

    protected String getParserType() {
        EncodingEnum encodingEnum = RestfulServerUtils.determineResponseEncodingWithDefault((RequestDetails)this.getRequestDetails()).getEncoding();
        return encodingEnum == EncodingEnum.JSON ? "application/json" : "application/xml";
    }

    private Response.ResponseBuilder buildResponse(int statusCode) {
        Response.ResponseBuilder response = Response.status((int)statusCode);
        for (Map.Entry header : this.getHeaders().entrySet()) {
            String key = (String)header.getKey();
            for (String value : (List)header.getValue()) {
                response.header(key, (Object)value);
            }
        }
        return response;
    }
}

