/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.util;

import ca.uhn.fhir.jpa.util.BaseCaptureQueriesListener;
import ca.uhn.fhir.jpa.util.SqlQuery;
import ca.uhn.fhir.util.StopWatch;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.hl7.fhir.r4.model.InstantType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CircularQueueCaptureQueriesListener
extends BaseCaptureQueriesListener {
    private static final int CAPACITY = 1000;
    private static final Logger ourLog = LoggerFactory.getLogger(CircularQueueCaptureQueriesListener.class);
    private Queue<SqlQuery> myQueries;
    private AtomicInteger myCommitCounter;
    private AtomicInteger myRollbackCounter;

    public CircularQueueCaptureQueriesListener() {
        this.startCollecting();
    }

    @Override
    protected Queue<SqlQuery> provideQueryList() {
        return this.myQueries;
    }

    @Override
    protected AtomicInteger provideCommitCounter() {
        return this.myCommitCounter;
    }

    @Override
    protected AtomicInteger provideRollbackCounter() {
        return this.myRollbackCounter;
    }

    public void clear() {
        this.myQueries.clear();
        this.myCommitCounter.set(0);
        this.myRollbackCounter.set(0);
    }

    public void startCollecting() {
        this.myQueries = Queues.synchronizedQueue((Queue)new CircularFifoQueue(1000));
        this.myCommitCounter = new AtomicInteger(0);
        this.myRollbackCounter = new AtomicInteger(0);
    }

    public void stopCollecting() {
        this.myQueries = null;
        this.myCommitCounter = null;
        this.myRollbackCounter = null;
    }

    public List<SqlQuery> getCapturedQueries() {
        ArrayList retVal = new ArrayList(1000);
        this.myQueries.forEach(retVal::add);
        return Collections.unmodifiableList(retVal);
    }

    private List<SqlQuery> getQueriesForCurrentThreadStartingWith(String theStart) {
        String threadName = Thread.currentThread().getName();
        return this.getQueriesStartingWith(theStart, threadName);
    }

    private List<SqlQuery> getQueriesStartingWith(String theStart, String theThreadName) {
        return this.getCapturedQueries().stream().filter(t -> theThreadName == null || t.getThreadName().equals(theThreadName)).filter(t -> t.getSql(false, false).toLowerCase().startsWith(theStart)).collect(Collectors.toList());
    }

    private List<SqlQuery> getQueriesStartingWith(String theStart) {
        return this.getQueriesStartingWith(theStart, null);
    }

    public int getCommitCount() {
        return this.myCommitCounter.get();
    }

    public int getRollbackCount() {
        return this.myRollbackCounter.get();
    }

    public List<SqlQuery> getSelectQueries() {
        return this.getQueriesStartingWith("select");
    }

    public List<SqlQuery> getInsertQueries() {
        return this.getQueriesStartingWith("insert");
    }

    public List<SqlQuery> getUpdateQueries() {
        return this.getQueriesStartingWith("update");
    }

    public List<SqlQuery> getDeleteQueries() {
        return this.getQueriesStartingWith("delete");
    }

    public List<SqlQuery> getSelectQueriesForCurrentThread() {
        return this.getQueriesForCurrentThreadStartingWith("select");
    }

    public List<SqlQuery> getInsertQueriesForCurrentThread() {
        return this.getQueriesForCurrentThreadStartingWith("insert");
    }

    public List<SqlQuery> getAllQueriesForCurrentThread() {
        return this.getQueriesForCurrentThreadStartingWith("");
    }

    public List<SqlQuery> getUpdateQueriesForCurrentThread() {
        return this.getQueriesForCurrentThreadStartingWith("update");
    }

    public List<SqlQuery> getDeleteQueriesForCurrentThread() {
        return this.getQueriesForCurrentThreadStartingWith("delete");
    }

    public String logUpdateQueriesForCurrentThread() {
        List queries = this.getUpdateQueriesForCurrentThread().stream().map(CircularQueueCaptureQueriesListener::formatQueryAsSql).collect(Collectors.toList());
        String joined = String.join((CharSequence)"\n", queries);
        ourLog.info("Update Queries:\n{}", (Object)joined);
        return joined;
    }

    public String logSelectQueriesForCurrentThread(int ... theIndexes) {
        List queries = this.getSelectQueriesForCurrentThread().stream().map(CircularQueueCaptureQueriesListener::formatQueryAsSql).collect(Collectors.toList());
        if (theIndexes != null && theIndexes.length > 0) {
            ArrayList newList = new ArrayList();
            for (int i = 0; i < theIndexes.length; ++i) {
                newList.add((String)queries.get(theIndexes[i]));
            }
            queries = newList;
        }
        String queriesAsString = String.join((CharSequence)"\n", queries);
        ourLog.info("Select Queries:\n{}", (Object)queriesAsString);
        return queriesAsString;
    }

    public List<SqlQuery> logSelectQueries() {
        return this.logSelectQueries(true, true);
    }

    public List<SqlQuery> logSelectQueries(boolean theInlineParams, boolean theFormatSql) {
        List<SqlQuery> queries = this.getSelectQueries();
        List queriesStrings = queries.stream().map(t -> CircularQueueCaptureQueriesListener.formatQueryAsSql(t, theInlineParams, theFormatSql)).collect(Collectors.toList());
        ourLog.info("Select Queries:\n{}", (Object)String.join((CharSequence)"\n", queriesStrings));
        return queries;
    }

    public void logFirstSelectQueryForCurrentThread() {
        String firstSelectQuery = this.getSelectQueriesForCurrentThread().stream().findFirst().map(CircularQueueCaptureQueriesListener::formatQueryAsSql).orElse("NONE FOUND");
        ourLog.info("First select SqlQuery:\n{}", (Object)firstSelectQuery);
    }

    public String logInsertQueriesForCurrentThread() {
        List queries = this.getInsertQueriesForCurrentThread().stream().map(CircularQueueCaptureQueriesListener::formatQueryAsSql).collect(Collectors.toList());
        String queriesAsString = String.join((CharSequence)"\n", queries);
        ourLog.info("Insert Queries:\n{}", (Object)queriesAsString);
        return queriesAsString;
    }

    public void logAllQueriesForCurrentThread() {
        List queries = this.getAllQueriesForCurrentThread().stream().map(CircularQueueCaptureQueriesListener::formatQueryAsSql).collect(Collectors.toList());
        ourLog.info("Queries:\n{}", (Object)String.join((CharSequence)"\n", queries));
    }

    public void logAllQueries() {
        List queries = this.getCapturedQueries().stream().map(CircularQueueCaptureQueriesListener::formatQueryAsSql).collect(Collectors.toList());
        ourLog.info("Queries:\n{}", (Object)String.join((CharSequence)"\n", queries));
    }

    public int logInsertQueries() {
        List<SqlQuery> insertQueries = this.getInsertQueries();
        List queries = insertQueries.stream().map(CircularQueueCaptureQueriesListener::formatQueryAsSql).collect(Collectors.toList());
        ourLog.info("Insert Queries:\n{}", (Object)String.join((CharSequence)"\n", queries));
        return insertQueries.stream().map(t -> t.getSize()).reduce(0, Integer::sum);
    }

    public int logUpdateQueries() {
        List<SqlQuery> updateQueries = this.getUpdateQueries();
        List queries = updateQueries.stream().map(CircularQueueCaptureQueriesListener::formatQueryAsSql).collect(Collectors.toList());
        ourLog.info("Update Queries:\n{}", (Object)String.join((CharSequence)"\n", queries));
        return updateQueries.stream().map(t -> t.getSize()).reduce(0, Integer::sum);
    }

    public String logDeleteQueriesForCurrentThread() {
        List queries = this.getDeleteQueriesForCurrentThread().stream().map(CircularQueueCaptureQueriesListener::formatQueryAsSql).collect(Collectors.toList());
        String joined = String.join((CharSequence)"\n", queries);
        ourLog.info("Delete Queries:\n{}", (Object)joined);
        return joined;
    }

    public int logDeleteQueries() {
        List<SqlQuery> deleteQueries = this.getDeleteQueries();
        List queries = deleteQueries.stream().map(CircularQueueCaptureQueriesListener::formatQueryAsSql).collect(Collectors.toList());
        ourLog.info("Delete Queries:\n{}", (Object)String.join((CharSequence)"\n", queries));
        return deleteQueries.stream().map(t -> t.getSize()).reduce(0, Integer::sum);
    }

    public int countSelectQueries() {
        return this.getSelectQueries().size();
    }

    public int countInsertQueries() {
        return this.getInsertQueries().stream().map(t -> t.getSize()).reduce(0, Integer::sum);
    }

    public int countUpdateQueries() {
        return this.getUpdateQueries().stream().map(t -> t.getSize()).reduce(0, Integer::sum);
    }

    public int countDeleteQueries() {
        return this.getDeleteQueries().stream().map(t -> t.getSize()).reduce(0, Integer::sum);
    }

    public int countSelectQueriesForCurrentThread() {
        return this.getSelectQueriesForCurrentThread().size();
    }

    public int countInsertQueriesForCurrentThread() {
        return this.getInsertQueriesForCurrentThread().size();
    }

    public int countUpdateQueriesForCurrentThread() {
        return this.getUpdateQueriesForCurrentThread().size();
    }

    public int countDeleteQueriesForCurrentThread() {
        return this.getDeleteQueriesForCurrentThread().size();
    }

    @Nonnull
    static String formatQueryAsSql(SqlQuery theQuery) {
        boolean inlineParams = true;
        boolean formatSql = true;
        return CircularQueueCaptureQueriesListener.formatQueryAsSql(theQuery, inlineParams, formatSql);
    }

    @Nonnull
    static String formatQueryAsSql(SqlQuery theQuery, boolean inlineParams, boolean formatSql) {
        String formattedSql = theQuery.getSql(inlineParams, formatSql);
        StringBuilder b = new StringBuilder();
        b.append("SqlQuery at ");
        b.append(new InstantType(new Date(theQuery.getQueryTimestamp())).getValueAsString());
        b.append(" took ").append(StopWatch.formatMillis((long)theQuery.getElapsedTime()));
        b.append(" on Thread: ").append(theQuery.getThreadName());
        if (theQuery.getSize() > 1) {
            b.append("\nExecution Count: ").append(theQuery.getSize()).append(" (parameters shown are for first execution)");
        }
        b.append("\nSQL:\n").append(formattedSql);
        if (theQuery.getStackTrace() != null) {
            b.append("\nStack:\n   ");
            Stream<String> stackTraceStream = Arrays.stream(theQuery.getStackTrace()).map(StackTraceElement::toString).filter(t -> t.startsWith("ca."));
            b.append(stackTraceStream.collect(Collectors.joining("\n   ")));
        }
        b.append("\n");
        return b.toString();
    }
}

