/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.cql.common.evaluation;

import ca.uhn.fhir.cql.common.helper.TranslatorHelper;
import ca.uhn.fhir.i18n.Msg;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang3.Validate;
import org.cqframework.cql.cql2elm.CqlTranslator;
import org.cqframework.cql.cql2elm.CqlTranslatorException;
import org.cqframework.cql.cql2elm.CqlTranslatorOptions;
import org.cqframework.cql.cql2elm.LibraryManager;
import org.cqframework.cql.cql2elm.ModelManager;
import org.hl7.elm.r1.Library;
import org.hl7.elm.r1.VersionedIdentifier;

public class LibraryLoader
implements org.opencds.cqf.cql.engine.execution.LibraryLoader {
    private LibraryManager libraryManager;
    private ModelManager modelManager;
    private Map<String, org.cqframework.cql.elm.execution.Library> libraries = new HashMap<String, org.cqframework.cql.elm.execution.Library>();

    public Collection<org.cqframework.cql.elm.execution.Library> getLibraries() {
        return this.libraries.values();
    }

    public LibraryManager getLibraryManager() {
        return this.libraryManager;
    }

    public ModelManager getModelManager() {
        return this.modelManager;
    }

    public LibraryLoader(LibraryManager libraryManager, ModelManager modelManager) {
        this.libraryManager = libraryManager;
        this.modelManager = modelManager;
    }

    private org.cqframework.cql.elm.execution.Library resolveLibrary(org.cqframework.cql.elm.execution.VersionedIdentifier libraryIdentifier) {
        Validate.notNull((Object)libraryIdentifier, (String)"Library identifier is null.", (Object[])new Object[0]);
        Validate.notNull((Object)libraryIdentifier.getId(), (String)"Library identifier id is null.", (Object[])new Object[0]);
        String mangledId = this.mangleIdentifer(libraryIdentifier);
        org.cqframework.cql.elm.execution.Library library = this.libraries.get(mangledId);
        if (library == null) {
            library = this.loadLibrary(libraryIdentifier);
            this.libraries.put(mangledId, library);
        }
        return library;
    }

    private String mangleIdentifer(org.cqframework.cql.elm.execution.VersionedIdentifier libraryIdentifier) {
        String id = libraryIdentifier.getId();
        String version = libraryIdentifier.getVersion();
        return version == null ? id : id + "-" + version;
    }

    private org.cqframework.cql.elm.execution.Library loadLibrary(org.cqframework.cql.elm.execution.VersionedIdentifier libraryIdentifier) {
        VersionedIdentifier identifier = new VersionedIdentifier().withId(libraryIdentifier.getId()).withSystem(libraryIdentifier.getSystem()).withVersion(libraryIdentifier.getVersion());
        ArrayList<CqlTranslatorException> errors = new ArrayList<CqlTranslatorException>();
        Library translatedLibrary = this.libraryManager.resolveLibrary(identifier, CqlTranslatorOptions.defaultOptions(), errors).getLibrary();
        if (CqlTranslatorException.HasErrors(errors)) {
            throw new IllegalArgumentException(Msg.code((int)1657) + TranslatorHelper.errorsToString(errors));
        }
        try {
            CqlTranslator translator = TranslatorHelper.getTranslator("", this.libraryManager, this.modelManager);
            if (translator.getErrors().size() > 0) {
                throw new IllegalArgumentException(Msg.code((int)1658) + TranslatorHelper.errorsToString(translator.getErrors()));
            }
            return TranslatorHelper.readLibrary(new ByteArrayInputStream(CqlTranslator.convertToXml((Library)translatedLibrary).getBytes(StandardCharsets.UTF_8)));
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException(Msg.code((int)1659) + String.format("Errors occurred translating library %s%s.", identifier.getId(), identifier.getVersion() != null ? "-" + identifier.getVersion() : ""));
        }
    }

    public org.cqframework.cql.elm.execution.Library load(org.cqframework.cql.elm.execution.VersionedIdentifier versionedIdentifier) {
        return this.resolveLibrary(versionedIdentifier);
    }
}

