/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.cql.common.helper;

import ca.uhn.fhir.i18n.Msg;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.xml.bind.JAXBException;
import org.cqframework.cql.cql2elm.CqlTranslator;
import org.cqframework.cql.cql2elm.CqlTranslatorException;
import org.cqframework.cql.cql2elm.LibraryManager;
import org.cqframework.cql.cql2elm.ModelManager;
import org.cqframework.cql.elm.execution.Library;
import org.cqframework.cql.elm.tracking.TrackBack;
import org.opencds.cqf.cql.engine.execution.CqlLibraryReader;

public class TranslatorHelper {
    public static Library readLibrary(InputStream xmlStream) {
        try {
            return CqlLibraryReader.read((InputStream)xmlStream);
        }
        catch (IOException | JAXBException e) {
            throw new IllegalArgumentException(Msg.code((int)1660) + "Error encountered while reading ELM xml: " + e.getMessage());
        }
    }

    public static String errorsToString(Iterable<CqlTranslatorException> exceptions) {
        ArrayList<CallSite> errors = new ArrayList<CallSite>();
        for (CqlTranslatorException error : exceptions) {
            TrackBack tb = error.getLocator();
            String lines = tb == null ? "[n/a]" : String.format("%s [%d:%d, %d:%d] ", tb.getLibrary() != null ? tb.getLibrary().getId() + (String)(tb.getLibrary().getVersion() != null ? "-" + tb.getLibrary().getVersion() : "") : "", tb.getStartLine(), tb.getStartChar(), tb.getEndLine(), tb.getEndChar());
            errors.add((CallSite)((Object)(lines + error.getMessage())));
        }
        return String.join((CharSequence)"\n", errors);
    }

    public static CqlTranslator getTranslator(String cql, LibraryManager libraryManager, ModelManager modelManager) {
        return TranslatorHelper.getTranslator(new ByteArrayInputStream(cql.getBytes(StandardCharsets.UTF_8)), libraryManager, modelManager);
    }

    public static CqlTranslator getTranslator(InputStream cqlStream, LibraryManager libraryManager, ModelManager modelManager) {
        CqlTranslator translator;
        ArrayList<CqlTranslator.Options> options = new ArrayList<CqlTranslator.Options>();
        options.add(CqlTranslator.Options.EnableAnnotations);
        options.add(CqlTranslator.Options.EnableLocators);
        options.add(CqlTranslator.Options.DisableListDemotion);
        options.add(CqlTranslator.Options.DisableListPromotion);
        options.add(CqlTranslator.Options.DisableMethodInvocation);
        try {
            translator = CqlTranslator.fromStream((InputStream)cqlStream, (ModelManager)modelManager, (LibraryManager)libraryManager, (CqlTranslator.Options[])options.toArray(new CqlTranslator.Options[options.size()]));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(Msg.code((int)1661) + String.format("Errors occurred translating library: %s", e.getMessage()));
        }
        return translator;
    }

    public static Library translateLibrary(String cql, LibraryManager libraryManager, ModelManager modelManager) {
        return TranslatorHelper.translateLibrary(new ByteArrayInputStream(cql.getBytes(StandardCharsets.UTF_8)), libraryManager, modelManager);
    }

    public static Library translateLibrary(InputStream cqlStream, LibraryManager libraryManager, ModelManager modelManager) {
        CqlTranslator translator = TranslatorHelper.getTranslator(cqlStream, libraryManager, modelManager);
        return TranslatorHelper.readLibrary(new ByteArrayInputStream(translator.toXml().getBytes(StandardCharsets.UTF_8)));
    }

    public static Library translateLibrary(CqlTranslator translator) {
        return TranslatorHelper.readLibrary(new ByteArrayInputStream(translator.toXml().getBytes(StandardCharsets.UTF_8)));
    }
}

