/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.cql.common.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Triple;
import org.cqframework.cql.elm.execution.Library;
import org.cqframework.cql.elm.execution.UsingDef;

public class UsingHelper {
    private static Map<String, String> urlsByModelName = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("FHIR", "http://hl7.org/fhir");
            this.put("QDM", "urn:healthit-gov:qdm:v5_4");
        }
    };

    public static List<Triple<String, String, String>> getUsingUrlAndVersion(Library.Usings usings) {
        if (usings == null || usings.getDef() == null) {
            return Collections.emptyList();
        }
        ArrayList<Triple<String, String, String>> usingDefs = new ArrayList<Triple<String, String, String>>();
        for (UsingDef def : usings.getDef()) {
            if (def.getLocalIdentifier().equals("System")) continue;
            usingDefs.add((Triple<String, String, String>)Triple.of((Object)def.getLocalIdentifier(), (Object)def.getVersion(), (Object)urlsByModelName.get(def.getLocalIdentifier())));
        }
        return usingDefs;
    }
}

