/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.cql.common.provider;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.cql.r4.provider.MeasureOperationsProvider;
import ca.uhn.fhir.i18n.Msg;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class CqlProviderFactory {
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private ApplicationContext myApplicationContext;

    public Object getMeasureOperationsProvider() {
        switch (this.myFhirContext.getVersion().getVersion()) {
            case DSTU3: {
                return this.myApplicationContext.getBean(ca.uhn.fhir.cql.dstu3.provider.MeasureOperationsProvider.class);
            }
            case R4: {
                return this.myApplicationContext.getBean(MeasureOperationsProvider.class);
            }
        }
        throw new ConfigurationException(Msg.code((int)1654) + "CQL is not supported for FHIR version " + this.myFhirContext.getVersion().getVersion());
    }
}

