/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.cql.common.provider;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.cql.common.provider.CqlProviderFactory;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.provider.ResourceProviderFactory;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CqlProviderLoader {
    private static final Logger myLogger = LoggerFactory.getLogger(CqlProviderLoader.class);
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private ResourceProviderFactory myResourceProviderFactory;
    @Autowired
    private CqlProviderFactory myCqlProviderFactory;

    @PostConstruct
    public void loadProvider() {
        switch (this.myFhirContext.getVersion().getVersion()) {
            case DSTU3: 
            case R4: {
                myLogger.info("Registering CQL Provider");
                this.myResourceProviderFactory.addSupplier(() -> this.myCqlProviderFactory.getMeasureOperationsProvider());
                break;
            }
            default: {
                throw new ConfigurationException(Msg.code((int)1653) + "CQL not supported for FHIR version " + this.myFhirContext.getVersion().getVersion());
            }
        }
    }
}

