/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.cql.common.provider;

import ca.uhn.fhir.cql.common.provider.LibraryResolutionProvider;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.function.Function;
import org.cqframework.cql.cql2elm.FhirLibrarySourceProvider;
import org.hl7.elm.r1.VersionedIdentifier;
import org.opencds.cqf.cql.evaluator.cql2elm.content.LibraryContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibraryContentProvider<LibraryType, AttachmentType>
implements org.opencds.cqf.cql.evaluator.cql2elm.content.LibraryContentProvider {
    private static final Logger ourLog = LoggerFactory.getLogger(LibraryContentProvider.class);
    private FhirLibrarySourceProvider innerProvider = new FhirLibrarySourceProvider();
    private LibraryResolutionProvider<LibraryType> provider;
    private Function<LibraryType, Iterable<AttachmentType>> getAttachments;
    private Function<AttachmentType, String> getContentType;
    private Function<AttachmentType, byte[]> getContent;

    public LibraryContentProvider(LibraryResolutionProvider<LibraryType> provider, Function<LibraryType, Iterable<AttachmentType>> getAttachments, Function<AttachmentType, String> getContentType, Function<AttachmentType, byte[]> getContent) {
        this.provider = provider;
        this.getAttachments = getAttachments;
        this.getContentType = getContentType;
        this.getContent = getContent;
    }

    public InputStream getLibraryContent(VersionedIdentifier versionedIdentifier, LibraryContentType libraryContentType) {
        if (libraryContentType != LibraryContentType.CQL) {
            return null;
        }
        try {
            LibraryType lib = this.provider.resolveLibraryByName(versionedIdentifier.getId(), versionedIdentifier.getVersion());
            for (AttachmentType attachment : this.getAttachments.apply(lib)) {
                if (!"text/cql".equals(this.getContentType.apply(attachment))) continue;
                return new ByteArrayInputStream(this.getContent.apply(attachment));
            }
        }
        catch (Exception e) {
            ourLog.warn("Failed to parse Library source for VersionedIdentifier '" + versionedIdentifier + "'!" + System.lineSeparator() + e.getMessage(), (Throwable)e);
        }
        return this.innerProvider.getLibrarySource(versionedIdentifier);
    }
}

